package edu.kit.ipd.sdq.kamp.core;

import java.util.ArrayList;
import java.util.List;

import de.uka.ipd.sdq.componentInternalDependencies.RoleToRoleDependency;
import de.uka.ipd.sdq.internalmodificationmark.InternalModificationMark;
import de.uka.ipd.sdq.pcm.core.composition.AssemblyConnector;
import de.uka.ipd.sdq.pcm.core.composition.AssemblyContext;
import de.uka.ipd.sdq.pcm.core.composition.Connector;
import de.uka.ipd.sdq.pcm.repository.BasicComponent;
import de.uka.ipd.sdq.pcm.repository.CompositeComponent;
import de.uka.ipd.sdq.pcm.repository.Interface;
import de.uka.ipd.sdq.pcm.repository.OperationInterface;
import de.uka.ipd.sdq.pcm.repository.OperationProvidedRole;
import de.uka.ipd.sdq.pcm.repository.OperationRequiredRole;
import de.uka.ipd.sdq.pcm.repository.ProvidedRole;
import de.uka.ipd.sdq.pcm.repository.RepositoryComponent;
import de.uka.ipd.sdq.pcm.repository.RequiredRole;

public class ArchitectureModelLookup {
	public static List<AssemblyContext> lookUpAssemblyContextsForRepositoryComponents(ArchitectureVersion version, RepositoryComponent component) {
		List<AssemblyContext> assemblyContexts = new ArrayList<AssemblyContext>();
		
		for (AssemblyContext assemblyContext : version.getSystem().getAssemblyContexts__ComposedStructure()) {
			if (assemblyContext.getEncapsulatedComponent__AssemblyContext()==component)
				assemblyContexts.add(assemblyContext);
		}

		assemblyContexts.addAll(lookUpAssemblyContextsInCompositeComponents(version, component));

		return assemblyContexts;
	}

	public static List<AssemblyConnector> lookUpAssemblyConnectorsBetweenAssemblyContexts(AssemblyContext providingAssemblyContext, AssemblyContext requiringAssemblyContext) {
		List<AssemblyConnector> assemblyConnectors = new ArrayList<AssemblyConnector>();
		
		for (Connector connector : providingAssemblyContext.getParentStructure__AssemblyContext().getConnectors__ComposedStructure()) {
			if (connector instanceof AssemblyConnector) {
				AssemblyConnector assemblyConnector = (AssemblyConnector) connector;
				
				if (assemblyConnector.getProvidingAssemblyContext_AssemblyConnector()==providingAssemblyContext && 
						assemblyConnector.getRequiringAssemblyContext_AssemblyConnector()==requiringAssemblyContext) {
					
					assemblyConnectors.add(assemblyConnector);
				}
				
			}
		}

		return assemblyConnectors;
	}
	
	private static List<AssemblyContext> lookUpAssemblyContextsInCompositeComponents(
			ArchitectureVersion version, RepositoryComponent component) {
		List<AssemblyContext> assemblyContexts = new ArrayList<AssemblyContext>();
		for (RepositoryComponent repcomponent : version.getRepository().getComponents__Repository()) {
			if (repcomponent instanceof CompositeComponent) {
				for (AssemblyContext assemblyContext : ((CompositeComponent)repcomponent).getAssemblyContexts__ComposedStructure()) {
					if (assemblyContext.getEncapsulatedComponent__AssemblyContext()==component)
						assemblyContexts.add(assemblyContext);
				}
			}
		}
		return assemblyContexts; 
	}

	public static List<ProvidingRequiredRolePair> lookUpMatchingRolePairs(
			RepositoryComponent providingComponent,
			RepositoryComponent requiringComponent) {
		List<ProvidingRequiredRolePair> pairs = new ArrayList<ProvidingRequiredRolePair>();
		
		for (ProvidedRole providedRole : providingComponent.getProvidedRoles_InterfaceProvidingEntity()) {
			for (RequiredRole requiredRole : requiringComponent.getRequiredRoles_InterfaceRequiringEntity()) {
				if (providedRole instanceof OperationProvidedRole && requiredRole instanceof OperationRequiredRole)
					if (((OperationProvidedRole)providedRole).getProvidedInterface__OperationProvidedRole()==((OperationRequiredRole)requiredRole).getRequiredInterface__OperationRequiredRole()) {
						pairs.add(new ProvidingRequiredRolePair(providedRole, requiredRole));
					}
			}
		}
		
		return pairs;
	}

	public static RepositoryComponent lookUpComponentByName(
			ArchitectureVersion version, String name) {
		
		for (RepositoryComponent repcomponent : version.getRepository().getComponents__Repository()) {
			if (repcomponent.getEntityName().equals(name)) {
				return repcomponent;
			}
		}
		
		return null;
	}

	public static Interface lookUpInterfaceByName(
			ArchitectureVersion version, String name) {
		
		for (Interface interf : version.getRepository().getInterfaces__Repository()) {
			if (interf.getEntityName().equals(name)) {
				return interf;
			}
		}
		
		return null;
	}

	
	public static InternalModificationMark lookUpInternalModificationMarkForComponent(
			ArchitectureVersion version, RepositoryComponent component) {

		for (InternalModificationMark mark : version.getInternalModificationMarkRepository().getInternalModificationMark()) {
			if (mark.getComponent()==component) {
				return mark;
			}
		}
		
		return null;
	}

	public static RoleToRoleDependency lookUpComponentInternalDependency(
			ArchitectureVersion version, BasicComponent component) {
		
		for (RoleToRoleDependency dep : version.getComponentInternalDependencyRepository().getDependencies()) {
			if (dep.getProvidedRole().getProvidingEntity_ProvidedRole()==component) 
				return dep;
		}
		
		return null;
	}

	public static List<ProvidedRole> lookUpDependentProvidedRolesForRequiredRole(
			ArchitectureVersion version,
			RequiredRole requiredRole) {
		
		List<ProvidedRole> providedRoles = new ArrayList<ProvidedRole>();
		
		for (RoleToRoleDependency dep : version.getComponentInternalDependencyRepository().getDependencies()) {
			if (dep.getRequiredRole()==requiredRole) {
				providedRoles.add(dep.getProvidedRole());
			}
		}
		
		return providedRoles;
	}
}
