/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.uka.ipd.sdq.fieldOfActivityAnnotations.provider;

import de.uka.ipd.sdq.fieldOfActivityAnnotations.util.FieldOfActivityAnnotationsAdapterFactory;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class FieldOfActivityAnnotationsItemProviderAdapterFactory extends FieldOfActivityAnnotationsAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FieldOfActivityAnnotationsItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.fieldOfActivityAnnotations.FieldOfActivityAnnotationsRepository} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FieldOfActivityAnnotationsRepositoryItemProvider fieldOfActivityAnnotationsRepositoryItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.fieldOfActivityAnnotations.FieldOfActivityAnnotationsRepository}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFieldOfActivityAnnotationsRepositoryAdapter() {
		if (fieldOfActivityAnnotationsRepositoryItemProvider == null) {
			fieldOfActivityAnnotationsRepositoryItemProvider = new FieldOfActivityAnnotationsRepositoryItemProvider(this);
		}

		return fieldOfActivityAnnotationsRepositoryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.fieldOfActivityAnnotations.SourceFile} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SourceFileItemProvider sourceFileItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.fieldOfActivityAnnotations.SourceFile}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSourceFileAdapter() {
		if (sourceFileItemProvider == null) {
			sourceFileItemProvider = new SourceFileItemProvider(this);
		}

		return sourceFileItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.fieldOfActivityAnnotations.SourceFileAggregation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SourceFileAggregationItemProvider sourceFileAggregationItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.fieldOfActivityAnnotations.SourceFileAggregation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSourceFileAggregationAdapter() {
		if (sourceFileAggregationItemProvider == null) {
			sourceFileAggregationItemProvider = new SourceFileAggregationItemProvider(this);
		}

		return sourceFileAggregationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.fieldOfActivityAnnotations.BuildConfiguration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BuildConfigurationItemProvider buildConfigurationItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.fieldOfActivityAnnotations.BuildConfiguration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBuildConfigurationAdapter() {
		if (buildConfigurationItemProvider == null) {
			buildConfigurationItemProvider = new BuildConfigurationItemProvider(this);
		}

		return buildConfigurationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.fieldOfActivityAnnotations.RuntimeInstance} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RuntimeInstanceItemProvider runtimeInstanceItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.fieldOfActivityAnnotations.RuntimeInstance}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRuntimeInstanceAdapter() {
		if (runtimeInstanceItemProvider == null) {
			runtimeInstanceItemProvider = new RuntimeInstanceItemProvider(this);
		}

		return runtimeInstanceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.fieldOfActivityAnnotations.RuntimeInstanceAggregation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RuntimeInstanceAggregationItemProvider runtimeInstanceAggregationItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.fieldOfActivityAnnotations.RuntimeInstanceAggregation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRuntimeInstanceAggregationAdapter() {
		if (runtimeInstanceAggregationItemProvider == null) {
			runtimeInstanceAggregationItemProvider = new RuntimeInstanceAggregationItemProvider(this);
		}

		return runtimeInstanceAggregationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.fieldOfActivityAnnotations.TestCase} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TestCaseItemProvider testCaseItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.fieldOfActivityAnnotations.TestCase}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTestCaseAdapter() {
		if (testCaseItemProvider == null) {
			testCaseItemProvider = new TestCaseItemProvider(this);
		}

		return testCaseItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.fieldOfActivityAnnotations.TestCaseAggregation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TestCaseAggregationItemProvider testCaseAggregationItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.fieldOfActivityAnnotations.TestCaseAggregation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTestCaseAggregationAdapter() {
		if (testCaseAggregationItemProvider == null) {
			testCaseAggregationItemProvider = new TestCaseAggregationItemProvider(this);
		}

		return testCaseAggregationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.fieldOfActivityAnnotations.DesignPatternRole} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DesignPatternRoleItemProvider designPatternRoleItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.fieldOfActivityAnnotations.DesignPatternRole}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDesignPatternRoleAdapter() {
		if (designPatternRoleItemProvider == null) {
			designPatternRoleItemProvider = new DesignPatternRoleItemProvider(this);
		}

		return designPatternRoleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.fieldOfActivityAnnotations.TechnologicalCorrespondence} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TechnologicalCorrespondenceItemProvider technologicalCorrespondenceItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.fieldOfActivityAnnotations.TechnologicalCorrespondence}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTechnologicalCorrespondenceAdapter() {
		if (technologicalCorrespondenceItemProvider == null) {
			technologicalCorrespondenceItemProvider = new TechnologicalCorrespondenceItemProvider(this);
		}

		return technologicalCorrespondenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.fieldOfActivityAnnotations.StaffAssignment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StaffAssignmentItemProvider staffAssignmentItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.fieldOfActivityAnnotations.StaffAssignment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStaffAssignmentAdapter() {
		if (staffAssignmentItemProvider == null) {
			staffAssignmentItemProvider = new StaffAssignmentItemProvider(this);
		}

		return staffAssignmentItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (fieldOfActivityAnnotationsRepositoryItemProvider != null) fieldOfActivityAnnotationsRepositoryItemProvider.dispose();
		if (sourceFileItemProvider != null) sourceFileItemProvider.dispose();
		if (sourceFileAggregationItemProvider != null) sourceFileAggregationItemProvider.dispose();
		if (buildConfigurationItemProvider != null) buildConfigurationItemProvider.dispose();
		if (runtimeInstanceItemProvider != null) runtimeInstanceItemProvider.dispose();
		if (runtimeInstanceAggregationItemProvider != null) runtimeInstanceAggregationItemProvider.dispose();
		if (testCaseItemProvider != null) testCaseItemProvider.dispose();
		if (testCaseAggregationItemProvider != null) testCaseAggregationItemProvider.dispose();
		if (designPatternRoleItemProvider != null) designPatternRoleItemProvider.dispose();
		if (technologicalCorrespondenceItemProvider != null) technologicalCorrespondenceItemProvider.dispose();
		if (staffAssignmentItemProvider != null) staffAssignmentItemProvider.dispose();
	}

}
