/*
 * Decompiled with CFR 0.152.
 */
package mrs.design;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import mrs.Layer;
import mrs.Metamodel;
import mrs.ModularReferenceStructure;
import mrs.custom.util.MRSUtil;
import mrs.design.Dependency;
import mrs.design.MetamodelInspector;
import mrs.design.ProfileInspector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.api.helper.graphicalfilters.HideFilterHelper;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.modelversioning.emfprofile.Stereotype;

public class Services {
    public Set<Metamodel> getReferencedMetamodels(Metamodel metamodel) {
        MetamodelInspector inspector = new MetamodelInspector(metamodel);
        return inspector.getReferencedMetamodels();
    }

    private Set<Dependency> getDependencies(Metamodel sourceMetamodel, Metamodel targetMetamodel) {
        MetamodelInspector inspector = new MetamodelInspector(sourceMetamodel);
        return inspector.getReferencedEClassifiers(targetMetamodel);
    }

    public Set<Metamodel> getExtendedMetamodels(Metamodel metamodel) {
        ProfileInspector inspector = new ProfileInspector(metamodel);
        return inspector.getExtensions().keySet();
    }

    public Set<Stereotype> getExtendingStereotypes(Metamodel extendingMetamodel, Metamodel extendedMetamodel) {
        ProfileInspector inspector = new ProfileInspector(extendingMetamodel);
        return inspector.getExtensions().get(extendedMetamodel);
    }

    public String printStereotypes(DDiagramElement view) {
        DEdge edge = (DEdge)view;
        Metamodel source = (Metamodel)((DSemanticDecorator)edge.getSourceNode()).getTarget();
        Metamodel target = (Metamodel)((DSemanticDecorator)edge.getTargetNode()).getTarget();
        Set<Stereotype> stereotypes = this.getExtendingStereotypes(source, target);
        String result = "";
        if (stereotypes != null) {
            for (Stereotype stereotype : stereotypes) {
                result = String.valueOf(result) + "<<" + stereotype.getProfile().getName() + "." + stereotype.getName() + ">>\n";
            }
        }
        return result;
    }

    public static Collection<Metamodel> getAllMetamodels(ModularReferenceStructure mrs) {
        return MRSUtil.getAllMetamodels((ModularReferenceStructure)mrs);
    }

    public static EPackage getTopMostPackage(EPackage ePackage) {
        return MRSUtil.getTopMostPackage((EPackage)ePackage);
    }

    public boolean edgeIsPointingDownwards(DEdge edge) {
        Metamodel source = (Metamodel)((DSemanticDecorator)edge.getSourceNode()).getTarget();
        Metamodel target = (Metamodel)((DSemanticDecorator)edge.getTargetNode()).getTarget();
        Layer sourceLayer = source.getLayer();
        Layer targetLayer = target.getLayer();
        ModularReferenceStructure mrs = sourceLayer.getModularReferenceStructure();
        if (sourceLayer == targetLayer) {
            return false;
        }
        EList layers = mrs.getLayers();
        return layers.indexOf((Object)targetLayer) > layers.indexOf((Object)sourceLayer);
    }

    public boolean edgeIsPartOfCycle(DEdge edge) {
        EdgeTarget sourceNode = edge.getSourceNode();
        EdgeTarget targetNode = edge.getTargetNode();
        LinkedList<EdgeTarget> queue = new LinkedList<EdgeTarget>();
        queue.add(targetNode);
        ArrayList<EdgeTarget> markedNodes = new ArrayList<EdgeTarget>();
        markedNodes.add(targetNode);
        while (!queue.isEmpty()) {
            EdgeTarget current = (EdgeTarget)queue.poll();
            Collection adjacentNodes = current.getOutgoingEdges().stream().map(x -> x.getTargetNode()).collect(Collectors.toList());
            if (adjacentNodes.contains(sourceNode)) {
                return true;
            }
            Collection unmarkedAdjacentNodes = adjacentNodes.stream().filter(x -> !markedNodes.contains(x)).collect(Collectors.toList());
            queue.addAll(unmarkedAdjacentNodes);
            markedNodes.addAll(unmarkedAdjacentNodes);
        }
        return false;
    }

    public Metamodel getContainingMetamodel(DNodeContainer containerView) {
        if (containerView.getTarget() instanceof Metamodel) {
            return (Metamodel)containerView.getTarget();
        }
        return this.getContainingMetamodel((DNodeContainer)containerView.eContainer());
    }

    public Collection<EPackage> getEAllSubPackages(EPackage ePackage) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        result.addAll((Collection<EPackage>)ePackage.getESubpackages());
        ePackage.getESubpackages().forEach(x -> {
            boolean bl = result.addAll(this.getEAllSubPackages((EPackage)x));
        });
        return result;
    }

    public Collection<EPackage> getAllPackages(EPackage ePackage) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        result.add(ePackage);
        result.addAll(this.getEAllSubPackages(ePackage));
        return result;
    }

    public List<EObject> getChainOfContainers(EObject eObject, EObject topMostContainer) {
        ArrayList<EObject> acc = new ArrayList<EObject>();
        List<EObject> result = this.getChainOfContainers(eObject, topMostContainer, acc);
        Collections.reverse(result);
        return result;
    }

    private List<EObject> getChainOfContainers(EObject eObject, EObject topMostContainer, List<EObject> acc) {
        if (eObject.eContainer() == topMostContainer) {
            return acc;
        }
        acc.add(eObject.eContainer());
        return this.getChainOfContainers(eObject.eContainer(), topMostContainer, acc);
    }

    public String printDependencies(DEdge edge) {
        Metamodel source = (Metamodel)((DSemanticDecorator)edge.getSourceNode()).getTarget();
        Metamodel target = (Metamodel)((DSemanticDecorator)edge.getTargetNode()).getTarget();
        Set<Dependency> dependencies = this.getDependencies(source, target);
        String result = "";
        if (dependencies != null) {
            for (Dependency dependency : dependencies) {
                result = String.valueOf(result) + dependency.getTarget().getName() + " (" + (Object)((Object)dependency.getType()) + " in " + dependency.getSource().getName() + ") \n";
            }
        }
        return result.isEmpty() ? result : result.substring(0, result.length() - 2);
    }

    public static List<EClassifier> getEAllClassifiers(EPackage ePackage) {
        ArrayList<EClassifier> result = new ArrayList<EClassifier>();
        result.addAll((Collection<EClassifier>)ePackage.getEClassifiers());
        ePackage.getESubpackages().forEach(x -> {
            boolean bl = result.addAll(Services.getEAllClassifiers(x));
        });
        return result;
    }

    public Metamodel getCorrespondingMetamodel(EPackage mainPackage, ModularReferenceStructure mrs) {
        return MRSUtil.getCorrespondingMetamodel((EPackage)mainPackage, (Collection)MRSUtil.getAllMetamodels((ModularReferenceStructure)mrs));
    }

    public boolean metamodelAlreadyExists(EPackage mainPackage, ModularReferenceStructure mrs) {
        return MRSUtil.metamodelAlreadyExists((EPackage)mainPackage, (ModularReferenceStructure)mrs);
    }

    public void hideTransitiveEdges(DSemanticDiagram diagram, boolean excludeCyclicalDependencies) {
        EList edges = diagram.getEdges();
        ArrayList<DEdge> transitiveEdges = new ArrayList<DEdge>();
        for (DEdge edge : edges) {
            if (excludeCyclicalDependencies && this.edgeIsPartOfCycle(edge) || !this.edgeIsTransitive(edge, transitiveEdges)) continue;
            transitiveEdges.add(edge);
        }
        for (DEdge edge : transitiveEdges) {
            HideFilterHelper.INSTANCE.hide((DDiagramElement)edge);
        }
    }

    private boolean edgeIsTransitive(DEdge edge, Collection<DEdge> transitiveEdges) {
        EdgeTarget sourceNode = edge.getSourceNode();
        EdgeTarget targetNode = edge.getTargetNode();
        LinkedList queue = new LinkedList();
        Collection sourceAdjacentNodes = sourceNode.getOutgoingEdges().stream().filter(e -> !transitiveEdges.contains(e)).map(x -> x.getTargetNode()).collect(Collectors.toList());
        sourceAdjacentNodes.remove(targetNode);
        queue.addAll(sourceAdjacentNodes);
        ArrayList markedNodes = new ArrayList();
        markedNodes.addAll(queue);
        markedNodes.add(sourceNode);
        while (!queue.isEmpty()) {
            EdgeTarget current = (EdgeTarget)queue.poll();
            Collection adjacentNodes = current.getOutgoingEdges().stream().filter(e -> !transitiveEdges.contains(e)).map(x -> x.getTargetNode()).collect(Collectors.toList());
            if (adjacentNodes.contains(targetNode)) {
                return true;
            }
            Collection unmarkedAdjacentNodes = adjacentNodes.stream().filter(x -> !markedNodes.contains(x)).collect(Collectors.toList());
            queue.addAll(unmarkedAdjacentNodes);
            markedNodes.addAll(unmarkedAdjacentNodes);
        }
        return false;
    }
}

