/*
 * Decompiled with CFR 0.152.
 */
package mrs.design;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mrs.Layer;
import mrs.Metamodel;
import mrs.ModularReferenceStructure;
import mrs.custom.util.MRSUtil;
import mrs.design.Dependency;
import mrs.design.Services;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.ETypeParameter;

public class MetamodelInspector {
    private Metamodel metamodel;
    private Map<Metamodel, Set<Dependency>> dependencies;

    public MetamodelInspector(Metamodel metamodel) {
        this.metamodel = metamodel;
        this.dependencies = new HashMap<Metamodel, Set<Dependency>>();
    }

    private Map<Metamodel, Set<Dependency>> computeDependencies() {
        for (EClassifier c : Services.getEAllClassifiers(this.metamodel.getMainPackage())) {
            if (!(c instanceof EClass)) continue;
            EClass eClass = (EClass)c;
            eClass.getESuperTypes().forEach(x -> this.addDependency(new Dependency((EClassifier)eClass, (EClassifier)x, Dependency.DependencyType.E_SUPER_TYPE)));
            eClass.getEReferences().forEach(x -> {
                this.addDependency(new Dependency((EClassifier)eClass, x.getEType(), Dependency.DependencyType.E_REFERENCE));
                this.visitGenericRef(x.getEGenericType(), (EClassifier)eClass);
            });
            eClass.getEAttributes().forEach(x -> {
                this.addDependency(new Dependency((EClassifier)eClass, x.getEType(), Dependency.DependencyType.E_ATTRIBUTE));
                this.visitGenericRef(x.getEGenericType(), (EClassifier)eClass);
            });
            eClass.getETypeParameters().forEach(x -> this.visitTypeParam((ETypeParameter)x, (EClassifier)eClass));
            eClass.getEGenericSuperTypes().forEach(x -> this.visitGenericSuperType((EGenericType)x, (EClassifier)eClass));
            eClass.getEOperations().forEach(x -> {
                this.addDependency(new Dependency((EClassifier)eClass, x.getEType(), Dependency.DependencyType.E_OPERATION_RETURN_TYPE));
                x.getEParameters().forEach(y -> {
                    this.addDependency(new Dependency((EClassifier)eClass, y.getEType(), Dependency.DependencyType.E_OPERATION_PARAMETER));
                    this.visitGenericType(y.getEGenericType(), (EClassifier)eClass);
                });
                this.visitGenericType(x.getEGenericType(), (EClassifier)eClass);
                x.getETypeParameters().forEach(y -> this.visitTypeParam((ETypeParameter)y, (EClassifier)eClass));
            });
        }
        return this.dependencies;
    }

    public Set<Metamodel> getReferencedMetamodels() {
        return this.computeDependencies().keySet();
    }

    public Set<Dependency> getReferencedEClassifiers(Metamodel metamodel) {
        return this.computeDependencies().get(metamodel);
    }

    private void addDependency(Dependency dependency) {
        EClassifier eClassifier = dependency.getTarget();
        EPackage mainPackage = MRSUtil.getTopMostPackage((EPackage)eClassifier.getEPackage());
        if (mainPackage == this.metamodel.getMainPackage()) {
            return;
        }
        Metamodel referencedMetamodel = this.getCorrespondingMetamodel(mainPackage);
        if (this.dependencies.containsKey(referencedMetamodel)) {
            this.dependencies.get(referencedMetamodel).add(dependency);
        } else {
            HashSet<Dependency> metamodelDependencies = new HashSet<Dependency>();
            metamodelDependencies.add(dependency);
            this.dependencies.put(referencedMetamodel, metamodelDependencies);
        }
    }

    private Metamodel getCorrespondingMetamodel(EPackage mainPackage) {
        Collection metamodels = MRSUtil.getAllMetamodels((ModularReferenceStructure)this.metamodel.getLayer().getModularReferenceStructure());
        Metamodel correspondingMetamodel = MRSUtil.getCorrespondingMetamodel((EPackage)mainPackage, (Collection)metamodels);
        if (correspondingMetamodel == null) {
            correspondingMetamodel = MRSUtil.createMetamodel((EPackage)mainPackage, (Layer)this.metamodel.getLayer());
        }
        return correspondingMetamodel;
    }

    private void visitTypeParam(ETypeParameter typeParam, EClassifier source) {
        typeParam.getEBounds().forEach(bound -> this.visitGenericType((EGenericType)bound, source));
    }

    private void visitGenericSuperType(EGenericType genericSuperType, EClassifier source) {
        if (genericSuperType.getETypeArguments().size() > 0) {
            this.visitGenericType(genericSuperType, source);
        }
    }

    private void visitGenericRef(EGenericType genericTypeOfRef, EClassifier source) {
        if (genericTypeOfRef.getETypeArguments().size() > 0) {
            this.visitGenericType(genericTypeOfRef, source);
        }
    }

    private void visitGenericType(EGenericType genericType, EClassifier source) {
        if (genericType == null) {
            return;
        }
        EClassifier eClassifier = genericType.getEClassifier();
        if (eClassifier != null) {
            this.addDependency(new Dependency(source, eClassifier, Dependency.DependencyType.E_GENERIC_TYPE));
        }
        this.visitGenericType(genericType.getEUpperBound(), source);
        this.visitGenericType(genericType.getELowerBound(), source);
        genericType.getETypeArguments().forEach(t -> this.visitGenericType((EGenericType)t, source));
        ETypeParameter typeParam = genericType.getETypeParameter();
        if (typeParam != null) {
            this.visitTypeParam(typeParam, source);
        }
    }
}

