/*
 * Decompiled with CFR 0.152.
 */
package mrs.custom.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mrs.Layer;
import mrs.Metamodel;
import mrs.ModularReferenceStructure;
import mrs.MrsFactory;
import mrs.custom.util.LoadResourceFromWorkspaceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.swt.widgets.Shell;

public class MRSUtil {
    public static EPackage getMainPackageByURI(URI uri, TransactionalEditingDomain editingDomain) {
        ResourceSet resourceSet = editingDomain.getResourceSet();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        Resource metamodelResource = resourceSet.getResource(uri, true);
        if (metamodelResource == null || metamodelResource.getContents().size() != 1) {
            System.out.println("Could not load resource with URI " + uri.toString());
            return null;
        }
        return (EPackage)metamodelResource.getContents().get(0);
    }

    public static Metamodel createMetamodel(EPackage mainPackage, Layer layer) {
        Metamodel metamodel = MrsFactory.eINSTANCE.createMetamodel();
        metamodel.setMainPackage(mainPackage);
        metamodel.setLayer(layer);
        metamodel.setName(mainPackage.getName());
        return metamodel;
    }

    public static List<URI> openLoadResourceFromWorkspaceDialog(Shell shell) {
        LoadResourceFromWorkspaceDialog dialog = new LoadResourceFromWorkspaceDialog(shell);
        dialog.open();
        return dialog.getURIText() == null || dialog.getURIText().isEmpty() ? null : dialog.getURIs();
    }

    public static Metamodel getCorrespondingMetamodel(EPackage mainPackage, Collection<Metamodel> metamodels) {
        for (Metamodel m : metamodels) {
            if (m.getMainPackage() != mainPackage) continue;
            return m;
        }
        return null;
    }

    public static boolean metamodelAlreadyExists(EPackage mainPackage, ModularReferenceStructure mrs) {
        for (Layer layer : mrs.getLayers()) {
            for (Metamodel metamodel : layer.getMetamodels()) {
                if (!mainPackage.equals(metamodel.getMainPackage())) continue;
                return true;
            }
        }
        return false;
    }

    public static Collection<Metamodel> getAllMetamodels(ModularReferenceStructure mrs) {
        ArrayList<Metamodel> result = new ArrayList<Metamodel>();
        for (Layer l : mrs.getLayers()) {
            result.addAll((Collection<Metamodel>)l.getMetamodels());
        }
        return result;
    }

    public static EPackage getTopMostPackage(EPackage ePackage) {
        if (ePackage.getESuperPackage() == null) {
            return ePackage;
        }
        return MRSUtil.getTopMostPackage(ePackage.getESuperPackage());
    }
}

