/*
 * Decompiled with CFR 0.152.
 */
package mrs.custom.externaljavaactions;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import mrs.Layer;
import mrs.custom.util.MRSUtil;
import mrs.custom.util.ProfileUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sirius.tools.api.ui.IExternalJavaAction;
import org.eclipse.sirius.viewpoint.DResource;
import org.modelversioning.emfprofile.Profile;

public class DropMetamodels
implements IExternalJavaAction {
    private final String ecoreExtension = "ecore";
    private final String profileExtension = "emfprofile_diagram";
    private final String[] extensions = new String[]{"ecore", "emfprofile_diagram"};

    public void execute(Collection<? extends EObject> selections, Map<String, Object> parameters) {
        Object element = parameters.get("element");
        if (!(element instanceof DResource)) {
            return;
        }
        Layer layer = (Layer)selections.iterator().next();
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)layer);
        File folder = new File(((DResource)element).getPath());
        Collection<File> files = this.getAllEcoreFiles(folder);
        for (File file : files) {
            IContainer container = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)new Path(file.getAbsolutePath()));
            URI uri = URI.createPlatformResourceURI((String)container.getFullPath().toString(), (boolean)true);
            if (uri.fileExtension().equals("ecore")) {
                EPackage mainPackage = MRSUtil.getMainPackageByURI(uri, editingDomain);
                if (mainPackage == null || MRSUtil.metamodelAlreadyExists(mainPackage, layer.getModularReferenceStructure())) continue;
                MRSUtil.createMetamodel(mainPackage, layer);
                continue;
            }
            if (!uri.fileExtension().equals("emfprofile_diagram")) continue;
            Profile profile = ProfileUtil.getProfileByURI(uri, editingDomain);
            if (!layer.getModularReferenceStructure().getLoadedProfiles().contains((Object)profile)) {
                layer.getModularReferenceStructure().getLoadedProfiles().add((Object)profile);
            }
            ProfileUtil.addMetamodelsToLayer(profile, layer);
        }
    }

    private Collection<File> getAllEcoreFiles(File file) {
        ArrayList<File> files = new ArrayList<File>();
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isFile() && Arrays.asList(this.extensions).contains(new Path(f.getPath()).getFileExtension())) {
                    files.add(f);
                } else if (f.isDirectory()) {
                    files.addAll(this.getAllEcoreFiles(f));
                }
                ++n2;
            }
        }
        return files;
    }

    public boolean canExecute(Collection<? extends EObject> selections) {
        return true;
    }
}

