/*
 * Decompiled with CFR 0.152.
 */
package mrs.custom.externaljavaactions;

import java.util.Collection;
import java.util.Map;
import mrs.Layer;
import mrs.Metamodel;
import mrs.custom.util.MRSUtil;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecoretools.design.ui.wizard.EcoreModelerWizard;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.sirius.tools.api.ui.IExternalJavaAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class CreateMetamodel
implements IExternalJavaAction {
    public static final Shell SHELL = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();

    public void execute(Collection<? extends EObject> selections, Map<String, Object> parameters) {
        Layer layer = (Layer)selections.iterator().next();
        Metamodel metamodel = (Metamodel)parameters.get("metamodel");
        EcoreModelerWizard wizard = new EcoreModelerWizard();
        IWorkbench workbench = PlatformUI.getWorkbench();
        IStructuredSelection selection = (IStructuredSelection)workbench.getActiveWorkbenchWindow().getSelectionService().getSelection();
        wizard.init(workbench, selection);
        WizardDialog dialog = new WizardDialog(SHELL, (IWizard)wizard);
        dialog.open();
        IProject project = wizard.getNewProject();
        if (project == null) {
            return;
        }
        IFolder modelFolder = project.getFolder("model");
        IResource modelResource = this.getModelResource(modelFolder);
        URI uri = URI.createPlatformResourceURI((String)modelResource.getFullPath().makeAbsolute().toString(), (boolean)true);
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)layer);
        EPackage mainPackage = MRSUtil.getMainPackageByURI(uri, editingDomain);
        metamodel.setMainPackage(mainPackage);
        metamodel.setName(mainPackage.getName());
    }

    private IResource getModelResource(IFolder modelFolder) {
        try {
            IResource[] iResourceArray = modelFolder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource r = iResourceArray[n2];
                if (r.getFileExtension().equals("ecore")) {
                    return r;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    public boolean canExecute(Collection<? extends EObject> selections) {
        return true;
    }
}

