/*
 * Decompiled with CFR 0.152.
 */
package requirements.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import requirements.Constraint;
import requirements.FunctionalRequirement;
import requirements.ProcessRequirement;
import requirements.ProcessRequirements;
import requirements.ProjectRequirement;
import requirements.ProjectRequirements;
import requirements.QualityRequirement;
import requirements.ReqPriorityEnum;
import requirements.ReqRepository;
import requirements.ReqStatusEnum;
import requirements.RequirementsFactory;
import requirements.RequirementsPackage;
import requirements.SystemRequirements;
import requirements.impl.ConstraintImpl;
import requirements.impl.FunctionalRequirementImpl;
import requirements.impl.ProcessRequirementImpl;
import requirements.impl.ProcessRequirementsImpl;
import requirements.impl.ProjectRequirementImpl;
import requirements.impl.ProjectRequirementsImpl;
import requirements.impl.QualityRequirementImpl;
import requirements.impl.ReqRepositoryImpl;
import requirements.impl.SystemRequirementsImpl;

public class RequirementsFactoryImpl
extends EFactoryImpl
implements RequirementsFactory {
    public static RequirementsFactory init() {
        try {
            RequirementsFactory theRequirementsFactory = (RequirementsFactory)EPackage.Registry.INSTANCE.getEFactory("http://toometa.de/requirements/0.6");
            if (theRequirementsFactory != null) {
                return theRequirementsFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new RequirementsFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createReqRepository();
            }
            case 2: {
                return this.createProjectRequirement();
            }
            case 4: {
                return this.createProcessRequirement();
            }
            case 5: {
                return this.createConstraint();
            }
            case 6: {
                return this.createFunctionalRequirement();
            }
            case 7: {
                return this.createQualityRequirement();
            }
            case 8: {
                return this.createProjectRequirements();
            }
            case 9: {
                return this.createSystemRequirements();
            }
            case 10: {
                return this.createProcessRequirements();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 11: {
                return this.createReqPriorityEnumFromString(eDataType, initialValue);
            }
            case 12: {
                return this.createReqStatusEnumFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 11: {
                return this.convertReqPriorityEnumToString(eDataType, instanceValue);
            }
            case 12: {
                return this.convertReqStatusEnumToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public ReqRepository createReqRepository() {
        ReqRepositoryImpl reqRepository = new ReqRepositoryImpl();
        return reqRepository;
    }

    @Override
    public ProjectRequirement createProjectRequirement() {
        ProjectRequirementImpl projectRequirement = new ProjectRequirementImpl();
        return projectRequirement;
    }

    @Override
    public ProcessRequirement createProcessRequirement() {
        ProcessRequirementImpl processRequirement = new ProcessRequirementImpl();
        return processRequirement;
    }

    @Override
    public Constraint createConstraint() {
        ConstraintImpl constraint = new ConstraintImpl();
        return constraint;
    }

    @Override
    public FunctionalRequirement createFunctionalRequirement() {
        FunctionalRequirementImpl functionalRequirement = new FunctionalRequirementImpl();
        return functionalRequirement;
    }

    @Override
    public QualityRequirement createQualityRequirement() {
        QualityRequirementImpl qualityRequirement = new QualityRequirementImpl();
        return qualityRequirement;
    }

    @Override
    public ProjectRequirements createProjectRequirements() {
        ProjectRequirementsImpl projectRequirements = new ProjectRequirementsImpl();
        return projectRequirements;
    }

    @Override
    public SystemRequirements createSystemRequirements() {
        SystemRequirementsImpl systemRequirements = new SystemRequirementsImpl();
        return systemRequirements;
    }

    @Override
    public ProcessRequirements createProcessRequirements() {
        ProcessRequirementsImpl processRequirements = new ProcessRequirementsImpl();
        return processRequirements;
    }

    public ReqPriorityEnum createReqPriorityEnumFromString(EDataType eDataType, String initialValue) {
        ReqPriorityEnum result = ReqPriorityEnum.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertReqPriorityEnumToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public ReqStatusEnum createReqStatusEnumFromString(EDataType eDataType, String initialValue) {
        ReqStatusEnum result = ReqStatusEnum.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertReqStatusEnumToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public RequirementsPackage getRequirementsPackage() {
        return (RequirementsPackage)this.getEPackage();
    }

    @Deprecated
    public static RequirementsPackage getPackage() {
        return RequirementsPackage.eINSTANCE;
    }
}

