/**
 */
package requirements.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import requirements.util.RequirementsAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class RequirementsItemProviderAdapterFactory extends RequirementsAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RequirementsItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link requirements.ReqRepository} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReqRepositoryItemProvider reqRepositoryItemProvider;

	/**
	 * This creates an adapter for a {@link requirements.ReqRepository}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReqRepositoryAdapter() {
		if (reqRepositoryItemProvider == null) {
			reqRepositoryItemProvider = new ReqRepositoryItemProvider(this);
		}

		return reqRepositoryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link requirements.ProjectRequirement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProjectRequirementItemProvider projectRequirementItemProvider;

	/**
	 * This creates an adapter for a {@link requirements.ProjectRequirement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProjectRequirementAdapter() {
		if (projectRequirementItemProvider == null) {
			projectRequirementItemProvider = new ProjectRequirementItemProvider(this);
		}

		return projectRequirementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link requirements.ProcessRequirement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessRequirementItemProvider processRequirementItemProvider;

	/**
	 * This creates an adapter for a {@link requirements.ProcessRequirement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessRequirementAdapter() {
		if (processRequirementItemProvider == null) {
			processRequirementItemProvider = new ProcessRequirementItemProvider(this);
		}

		return processRequirementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link requirements.Constraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConstraintItemProvider constraintItemProvider;

	/**
	 * This creates an adapter for a {@link requirements.Constraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConstraintAdapter() {
		if (constraintItemProvider == null) {
			constraintItemProvider = new ConstraintItemProvider(this);
		}

		return constraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link requirements.FunctionalRequirement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FunctionalRequirementItemProvider functionalRequirementItemProvider;

	/**
	 * This creates an adapter for a {@link requirements.FunctionalRequirement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFunctionalRequirementAdapter() {
		if (functionalRequirementItemProvider == null) {
			functionalRequirementItemProvider = new FunctionalRequirementItemProvider(this);
		}

		return functionalRequirementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link requirements.QualityRequirement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected QualityRequirementItemProvider qualityRequirementItemProvider;

	/**
	 * This creates an adapter for a {@link requirements.QualityRequirement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createQualityRequirementAdapter() {
		if (qualityRequirementItemProvider == null) {
			qualityRequirementItemProvider = new QualityRequirementItemProvider(this);
		}

		return qualityRequirementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link requirements.ProjectRequirements} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProjectRequirementsItemProvider projectRequirementsItemProvider;

	/**
	 * This creates an adapter for a {@link requirements.ProjectRequirements}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProjectRequirementsAdapter() {
		if (projectRequirementsItemProvider == null) {
			projectRequirementsItemProvider = new ProjectRequirementsItemProvider(this);
		}

		return projectRequirementsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link requirements.SystemRequirements} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SystemRequirementsItemProvider systemRequirementsItemProvider;

	/**
	 * This creates an adapter for a {@link requirements.SystemRequirements}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSystemRequirementsAdapter() {
		if (systemRequirementsItemProvider == null) {
			systemRequirementsItemProvider = new SystemRequirementsItemProvider(this);
		}

		return systemRequirementsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link requirements.ProcessRequirements} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessRequirementsItemProvider processRequirementsItemProvider;

	/**
	 * This creates an adapter for a {@link requirements.ProcessRequirements}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessRequirementsAdapter() {
		if (processRequirementsItemProvider == null) {
			processRequirementsItemProvider = new ProcessRequirementsItemProvider(this);
		}

		return processRequirementsItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (reqRepositoryItemProvider != null) reqRepositoryItemProvider.dispose();
		if (projectRequirementItemProvider != null) projectRequirementItemProvider.dispose();
		if (processRequirementItemProvider != null) processRequirementItemProvider.dispose();
		if (constraintItemProvider != null) constraintItemProvider.dispose();
		if (functionalRequirementItemProvider != null) functionalRequirementItemProvider.dispose();
		if (qualityRequirementItemProvider != null) qualityRequirementItemProvider.dispose();
		if (projectRequirementsItemProvider != null) projectRequirementsItemProvider.dispose();
		if (systemRequirementsItemProvider != null) systemRequirementsItemProvider.dispose();
		if (processRequirementsItemProvider != null) processRequirementsItemProvider.dispose();
	}

}
