/**
 */
package qualities.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import qualities.util.QualitiesAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class QualitiesItemProviderAdapterFactory extends QualitiesAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public QualitiesItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link qualities.ReliabilityCompliance} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReliabilityComplianceItemProvider reliabilityComplianceItemProvider;

	/**
	 * This creates an adapter for a {@link qualities.ReliabilityCompliance}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReliabilityComplianceAdapter() {
		if (reliabilityComplianceItemProvider == null) {
			reliabilityComplianceItemProvider = new ReliabilityComplianceItemProvider(this);
		}

		return reliabilityComplianceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link qualities.Installability} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InstallabilityItemProvider installabilityItemProvider;

	/**
	 * This creates an adapter for a {@link qualities.Installability}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInstallabilityAdapter() {
		if (installabilityItemProvider == null) {
			installabilityItemProvider = new InstallabilityItemProvider(this);
		}

		return installabilityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link qualities.Reliability} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReliabilityItemProvider reliabilityItemProvider;

	/**
	 * This creates an adapter for a {@link qualities.Reliability}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReliabilityAdapter() {
		if (reliabilityItemProvider == null) {
			reliabilityItemProvider = new ReliabilityItemProvider(this);
		}

		return reliabilityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link qualities.CoExistence} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CoExistenceItemProvider coExistenceItemProvider;

	/**
	 * This creates an adapter for a {@link qualities.CoExistence}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCoExistenceAdapter() {
		if (coExistenceItemProvider == null) {
			coExistenceItemProvider = new CoExistenceItemProvider(this);
		}

		return coExistenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link qualities.Operability} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OperabilityItemProvider operabilityItemProvider;

	/**
	 * This creates an adapter for a {@link qualities.Operability}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOperabilityAdapter() {
		if (operabilityItemProvider == null) {
			operabilityItemProvider = new OperabilityItemProvider(this);
		}

		return operabilityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link qualities.Stability} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StabilityItemProvider stabilityItemProvider;

	/**
	 * This creates an adapter for a {@link qualities.Stability}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStabilityAdapter() {
		if (stabilityItemProvider == null) {
			stabilityItemProvider = new StabilityItemProvider(this);
		}

		return stabilityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link qualities.MaintainabilityCompliance} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MaintainabilityComplianceItemProvider maintainabilityComplianceItemProvider;

	/**
	 * This creates an adapter for a {@link qualities.MaintainabilityCompliance}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMaintainabilityComplianceAdapter() {
		if (maintainabilityComplianceItemProvider == null) {
			maintainabilityComplianceItemProvider = new MaintainabilityComplianceItemProvider(this);
		}

		return maintainabilityComplianceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link qualities.Portability} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PortabilityItemProvider portabilityItemProvider;

	/**
	 * This creates an adapter for a {@link qualities.Portability}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPortabilityAdapter() {
		if (portabilityItemProvider == null) {
			portabilityItemProvider = new PortabilityItemProvider(this);
		}

		return portabilityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link qualities.Maintainability} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MaintainabilityItemProvider maintainabilityItemProvider;

	/**
	 * This creates an adapter for a {@link qualities.Maintainability}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMaintainabilityAdapter() {
		if (maintainabilityItemProvider == null) {
			maintainabilityItemProvider = new MaintainabilityItemProvider(this);
		}

		return maintainabilityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link qualities.Maturity} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MaturityItemProvider maturityItemProvider;

	/**
	 * This creates an adapter for a {@link qualities.Maturity}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMaturityAdapter() {
		if (maturityItemProvider == null) {
			maturityItemProvider = new MaturityItemProvider(this);
		}

		return maturityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link qualities.Attractiveness} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AttractivenessItemProvider attractivenessItemProvider;

	/**
	 * This creates an adapter for a {@link qualities.Attractiveness}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAttractivenessAdapter() {
		if (attractivenessItemProvider == null) {
			attractivenessItemProvider = new AttractivenessItemProvider(this);
		}

		return attractivenessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link qualities.Analyzability} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AnalyzabilityItemProvider analyzabilityItemProvider;

	/**
	 * This creates an adapter for a {@link qualities.Analyzability}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAnalyzabilityAdapter() {
		if (analyzabilityItemProvider == null) {
			analyzabilityItemProvider = new AnalyzabilityItemProvider(this);
		}

		return analyzabilityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link qualities.Replaceability} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReplaceabilityItemProvider replaceabilityItemProvider;

	/**
	 * This creates an adapter for a {@link qualities.Replaceability}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReplaceabilityAdapter() {
		if (replaceabilityItemProvider == null) {
			replaceabilityItemProvider = new ReplaceabilityItemProvider(this);
		}

		return replaceabilityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link qualities.Recoverability} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RecoverabilityItemProvider recoverabilityItemProvider;

	/**
	 * This creates an adapter for a {@link qualities.Recoverability}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRecoverabilityAdapter() {
		if (recoverabilityItemProvider == null) {
			recoverabilityItemProvider = new RecoverabilityItemProvider(this);
		}

		return recoverabilityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link qualities.Understandability} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UnderstandabilityItemProvider understandabilityItemProvider;

	/**
	 * This creates an adapter for a {@link qualities.Understandability}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUnderstandabilityAdapter() {
		if (understandabilityItemProvider == null) {
			understandabilityItemProvider = new UnderstandabilityItemProvider(this);
		}

		return understandabilityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link qualities.PortabilityCompliance} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PortabilityComplianceItemProvider portabilityComplianceItemProvider;

	/**
	 * This creates an adapter for a {@link qualities.PortabilityCompliance}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPortabilityComplianceAdapter() {
		if (portabilityComplianceItemProvider == null) {
			portabilityComplianceItemProvider = new PortabilityComplianceItemProvider(this);
		}

		return portabilityComplianceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link qualities.RessourceUtilization} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RessourceUtilizationItemProvider ressourceUtilizationItemProvider;

	/**
	 * This creates an adapter for a {@link qualities.RessourceUtilization}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRessourceUtilizationAdapter() {
		if (ressourceUtilizationItemProvider == null) {
			ressourceUtilizationItemProvider = new RessourceUtilizationItemProvider(this);
		}

		return ressourceUtilizationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link qualities.Changeability} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ChangeabilityItemProvider changeabilityItemProvider;

	/**
	 * This creates an adapter for a {@link qualities.Changeability}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createChangeabilityAdapter() {
		if (changeabilityItemProvider == null) {
			changeabilityItemProvider = new ChangeabilityItemProvider(this);
		}

		return changeabilityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link qualities.Interoperability} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InteroperabilityItemProvider interoperabilityItemProvider;

	/**
	 * This creates an adapter for a {@link qualities.Interoperability}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInteroperabilityAdapter() {
		if (interoperabilityItemProvider == null) {
			interoperabilityItemProvider = new InteroperabilityItemProvider(this);
		}

		return interoperabilityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link qualities.FaultTolerance} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FaultToleranceItemProvider faultToleranceItemProvider;

	/**
	 * This creates an adapter for a {@link qualities.FaultTolerance}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFaultToleranceAdapter() {
		if (faultToleranceItemProvider == null) {
			faultToleranceItemProvider = new FaultToleranceItemProvider(this);
		}

		return faultToleranceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link qualities.QualityTypeRepository} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected QualityTypeRepositoryItemProvider qualityTypeRepositoryItemProvider;

	/**
	 * This creates an adapter for a {@link qualities.QualityTypeRepository}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createQualityTypeRepositoryAdapter() {
		if (qualityTypeRepositoryItemProvider == null) {
			qualityTypeRepositoryItemProvider = new QualityTypeRepositoryItemProvider(this);
		}

		return qualityTypeRepositoryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link qualities.Adaptability} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AdaptabilityItemProvider adaptabilityItemProvider;

	/**
	 * This creates an adapter for a {@link qualities.Adaptability}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAdaptabilityAdapter() {
		if (adaptabilityItemProvider == null) {
			adaptabilityItemProvider = new AdaptabilityItemProvider(this);
		}

		return adaptabilityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link qualities.Functionality} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FunctionalityItemProvider functionalityItemProvider;

	/**
	 * This creates an adapter for a {@link qualities.Functionality}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFunctionalityAdapter() {
		if (functionalityItemProvider == null) {
			functionalityItemProvider = new FunctionalityItemProvider(this);
		}

		return functionalityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link qualities.TimeBehaviour} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TimeBehaviourItemProvider timeBehaviourItemProvider;

	/**
	 * This creates an adapter for a {@link qualities.TimeBehaviour}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTimeBehaviourAdapter() {
		if (timeBehaviourItemProvider == null) {
			timeBehaviourItemProvider = new TimeBehaviourItemProvider(this);
		}

		return timeBehaviourItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link qualities.Security} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SecurityItemProvider securityItemProvider;

	/**
	 * This creates an adapter for a {@link qualities.Security}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSecurityAdapter() {
		if (securityItemProvider == null) {
			securityItemProvider = new SecurityItemProvider(this);
		}

		return securityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link qualities.Accuracy} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AccuracyItemProvider accuracyItemProvider;

	/**
	 * This creates an adapter for a {@link qualities.Accuracy}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAccuracyAdapter() {
		if (accuracyItemProvider == null) {
			accuracyItemProvider = new AccuracyItemProvider(this);
		}

		return accuracyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link qualities.FunctionalityCompliance} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FunctionalityComplianceItemProvider functionalityComplianceItemProvider;

	/**
	 * This creates an adapter for a {@link qualities.FunctionalityCompliance}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFunctionalityComplianceAdapter() {
		if (functionalityComplianceItemProvider == null) {
			functionalityComplianceItemProvider = new FunctionalityComplianceItemProvider(this);
		}

		return functionalityComplianceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link qualities.Efficiency} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EfficiencyItemProvider efficiencyItemProvider;

	/**
	 * This creates an adapter for a {@link qualities.Efficiency}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEfficiencyAdapter() {
		if (efficiencyItemProvider == null) {
			efficiencyItemProvider = new EfficiencyItemProvider(this);
		}

		return efficiencyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link qualities.Safety} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SafetyItemProvider safetyItemProvider;

	/**
	 * This creates an adapter for a {@link qualities.Safety}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSafetyAdapter() {
		if (safetyItemProvider == null) {
			safetyItemProvider = new SafetyItemProvider(this);
		}

		return safetyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link qualities.EfficiencyCompliance} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EfficiencyComplianceItemProvider efficiencyComplianceItemProvider;

	/**
	 * This creates an adapter for a {@link qualities.EfficiencyCompliance}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEfficiencyComplianceAdapter() {
		if (efficiencyComplianceItemProvider == null) {
			efficiencyComplianceItemProvider = new EfficiencyComplianceItemProvider(this);
		}

		return efficiencyComplianceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link qualities.Suitability} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SuitabilityItemProvider suitabilityItemProvider;

	/**
	 * This creates an adapter for a {@link qualities.Suitability}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSuitabilityAdapter() {
		if (suitabilityItemProvider == null) {
			suitabilityItemProvider = new SuitabilityItemProvider(this);
		}

		return suitabilityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link qualities.Learnability} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LearnabilityItemProvider learnabilityItemProvider;

	/**
	 * This creates an adapter for a {@link qualities.Learnability}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLearnabilityAdapter() {
		if (learnabilityItemProvider == null) {
			learnabilityItemProvider = new LearnabilityItemProvider(this);
		}

		return learnabilityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link qualities.Usability} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UsabilityItemProvider usabilityItemProvider;

	/**
	 * This creates an adapter for a {@link qualities.Usability}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUsabilityAdapter() {
		if (usabilityItemProvider == null) {
			usabilityItemProvider = new UsabilityItemProvider(this);
		}

		return usabilityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link qualities.Performance} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PerformanceItemProvider performanceItemProvider;

	/**
	 * This creates an adapter for a {@link qualities.Performance}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPerformanceAdapter() {
		if (performanceItemProvider == null) {
			performanceItemProvider = new PerformanceItemProvider(this);
		}

		return performanceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link qualities.Testability} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TestabilityItemProvider testabilityItemProvider;

	/**
	 * This creates an adapter for a {@link qualities.Testability}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTestabilityAdapter() {
		if (testabilityItemProvider == null) {
			testabilityItemProvider = new TestabilityItemProvider(this);
		}

		return testabilityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link qualities.UsabilityCompliance} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UsabilityComplianceItemProvider usabilityComplianceItemProvider;

	/**
	 * This creates an adapter for a {@link qualities.UsabilityCompliance}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUsabilityComplianceAdapter() {
		if (usabilityComplianceItemProvider == null) {
			usabilityComplianceItemProvider = new UsabilityComplianceItemProvider(this);
		}

		return usabilityComplianceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link qualities.TextQuality} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TextQualityItemProvider textQualityItemProvider;

	/**
	 * This creates an adapter for a {@link qualities.TextQuality}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTextQualityAdapter() {
		if (textQualityItemProvider == null) {
			textQualityItemProvider = new TextQualityItemProvider(this);
		}

		return textQualityItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (reliabilityComplianceItemProvider != null) reliabilityComplianceItemProvider.dispose();
		if (installabilityItemProvider != null) installabilityItemProvider.dispose();
		if (reliabilityItemProvider != null) reliabilityItemProvider.dispose();
		if (coExistenceItemProvider != null) coExistenceItemProvider.dispose();
		if (operabilityItemProvider != null) operabilityItemProvider.dispose();
		if (stabilityItemProvider != null) stabilityItemProvider.dispose();
		if (maintainabilityComplianceItemProvider != null) maintainabilityComplianceItemProvider.dispose();
		if (portabilityItemProvider != null) portabilityItemProvider.dispose();
		if (maintainabilityItemProvider != null) maintainabilityItemProvider.dispose();
		if (maturityItemProvider != null) maturityItemProvider.dispose();
		if (attractivenessItemProvider != null) attractivenessItemProvider.dispose();
		if (analyzabilityItemProvider != null) analyzabilityItemProvider.dispose();
		if (replaceabilityItemProvider != null) replaceabilityItemProvider.dispose();
		if (recoverabilityItemProvider != null) recoverabilityItemProvider.dispose();
		if (understandabilityItemProvider != null) understandabilityItemProvider.dispose();
		if (portabilityComplianceItemProvider != null) portabilityComplianceItemProvider.dispose();
		if (ressourceUtilizationItemProvider != null) ressourceUtilizationItemProvider.dispose();
		if (changeabilityItemProvider != null) changeabilityItemProvider.dispose();
		if (interoperabilityItemProvider != null) interoperabilityItemProvider.dispose();
		if (faultToleranceItemProvider != null) faultToleranceItemProvider.dispose();
		if (qualityTypeRepositoryItemProvider != null) qualityTypeRepositoryItemProvider.dispose();
		if (adaptabilityItemProvider != null) adaptabilityItemProvider.dispose();
		if (functionalityItemProvider != null) functionalityItemProvider.dispose();
		if (timeBehaviourItemProvider != null) timeBehaviourItemProvider.dispose();
		if (securityItemProvider != null) securityItemProvider.dispose();
		if (accuracyItemProvider != null) accuracyItemProvider.dispose();
		if (functionalityComplianceItemProvider != null) functionalityComplianceItemProvider.dispose();
		if (efficiencyItemProvider != null) efficiencyItemProvider.dispose();
		if (safetyItemProvider != null) safetyItemProvider.dispose();
		if (efficiencyComplianceItemProvider != null) efficiencyComplianceItemProvider.dispose();
		if (suitabilityItemProvider != null) suitabilityItemProvider.dispose();
		if (learnabilityItemProvider != null) learnabilityItemProvider.dispose();
		if (usabilityItemProvider != null) usabilityItemProvider.dispose();
		if (performanceItemProvider != null) performanceItemProvider.dispose();
		if (testabilityItemProvider != null) testabilityItemProvider.dispose();
		if (usabilityComplianceItemProvider != null) usabilityComplianceItemProvider.dispose();
		if (textQualityItemProvider != null) textQualityItemProvider.dispose();
	}

}
