/*
 * Decompiled with CFR 0.152.
 */
package glossary;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TermCategory implements Enumerator
{
    KEYWORD(0, "KEYWORD", "KEYWORD"),
    GVERB(1, "GVERB", "GVERB"),
    GOBJECT(2, "GOBJECT", "GOBJECT"),
    QUESTION(3, "QUESTION", "QUESTION"),
    OTHER(4, "OTHER", "OTHER");

    public static final int KEYWORD_VALUE = 0;
    public static final int GVERB_VALUE = 1;
    public static final int GOBJECT_VALUE = 2;
    public static final int QUESTION_VALUE = 3;
    public static final int OTHER_VALUE = 4;
    private static final TermCategory[] VALUES_ARRAY;
    public static final List<TermCategory> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TermCategory[]{KEYWORD, GVERB, GOBJECT, QUESTION, OTHER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TermCategory get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TermCategory result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TermCategory getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TermCategory result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TermCategory get(int value) {
        switch (value) {
            case 0: {
                return KEYWORD;
            }
            case 1: {
                return GVERB;
            }
            case 2: {
                return GOBJECT;
            }
            case 3: {
                return QUESTION;
            }
            case 4: {
                return OTHER;
            }
        }
        return null;
    }

    private TermCategory(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

