/*
 * Decompiled with CFR 0.152.
 */
package decisions.impl;

import decisions.DecisionRepository;
import decisions.DecisionStatusEnum;
import decisions.DecisionsFactory;
import decisions.DecisionsPackage;
import decisions.TextDecision;
import decisions.TextRationale;
import decisions.impl.DecisionRepositoryImpl;
import decisions.impl.TextDecisionImpl;
import decisions.impl.TextRationaleImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class DecisionsFactoryImpl
extends EFactoryImpl
implements DecisionsFactory {
    public static DecisionsFactory init() {
        try {
            DecisionsFactory theDecisionsFactory = (DecisionsFactory)EPackage.Registry.INSTANCE.getEFactory("http://toometa.de/decisions/0.6");
            if (theDecisionsFactory != null) {
                return theDecisionsFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new DecisionsFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createDecisionRepository();
            }
            case 3: {
                return this.createTextDecision();
            }
            case 4: {
                return this.createTextRationale();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 5: {
                return this.createDecisionStatusEnumFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 5: {
                return this.convertDecisionStatusEnumToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public DecisionRepository createDecisionRepository() {
        DecisionRepositoryImpl decisionRepository = new DecisionRepositoryImpl();
        return decisionRepository;
    }

    @Override
    public TextDecision createTextDecision() {
        TextDecisionImpl textDecision = new TextDecisionImpl();
        return textDecision;
    }

    @Override
    public TextRationale createTextRationale() {
        TextRationaleImpl textRationale = new TextRationaleImpl();
        return textRationale;
    }

    public DecisionStatusEnum createDecisionStatusEnumFromString(EDataType eDataType, String initialValue) {
        DecisionStatusEnum result = DecisionStatusEnum.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertDecisionStatusEnumToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public DecisionsPackage getDecisionsPackage() {
        return (DecisionsPackage)this.getEPackage();
    }

    @Deprecated
    public static DecisionsPackage getPackage() {
        return DecisionsPackage.eINSTANCE;
    }
}

