/*
 * Decompiled with CFR 0.152.
 */
package archoptions.tests;

import archoptions.ArchoptionsPackage;
import java.io.File;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

public class ArchoptionsExample {
    public static void main(String[] args) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        resourceSet.getPackageRegistry().put((Object)"http://toometa.de/archoptions/0.6", (Object)ArchoptionsPackage.eINSTANCE);
        if (args.length == 0) {
            System.out.println("Enter a list of file paths or URIs");
        } else {
            int i = 0;
            while (i < args.length) {
                File file = new File(args[i]);
                URI uri = file.isFile() ? URI.createFileURI((String)file.getAbsolutePath()) : URI.createURI((String)args[i]);
                try {
                    Resource resource = resourceSet.getResource(uri, true);
                    System.out.println("Loaded " + uri);
                    for (EObject eObject : resource.getContents()) {
                        Diagnostic diagnostic = Diagnostician.INSTANCE.validate(eObject);
                        if (diagnostic.getSeverity() == 0) continue;
                        ArchoptionsExample.printDiagnostic(diagnostic, "");
                    }
                }
                catch (RuntimeException exception) {
                    System.out.println("Problem loading " + uri);
                    exception.printStackTrace();
                }
                ++i;
            }
        }
    }

    protected static void printDiagnostic(Diagnostic diagnostic, String indent) {
        System.out.print(indent);
        System.out.println(diagnostic.getMessage());
        for (Diagnostic child : diagnostic.getChildren()) {
            ArchoptionsExample.printDiagnostic(child, String.valueOf(indent) + "  ");
        }
    }
}

