/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.kamp.workplan;

import edu.kit.ipd.sdq.kamp.util.MapUtil;
import edu.kit.ipd.sdq.kamp.workplan.Activity;
import edu.kit.ipd.sdq.kamp.workplan.BasicActivity;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class WorkplanDuplicateRemoval {
    public static List<Activity> removeModificationDuplicates(List<Activity> actvityList) {
        LinkedList<Activity> result = new LinkedList<Activity>();
        HashMap objectsWithActivity = new HashMap();
        for (Activity activityToAnalyze : actvityList) {
            if (activityToAnalyze.getBasicActivity().equals((Object)BasicActivity.MODIFY)) {
                boolean merged = false;
                if (objectsWithActivity.containsKey(activityToAnalyze.getElement())) {
                    for (Activity existingActivity : (Set)objectsWithActivity.get(activityToAnalyze.getElement())) {
                        if (!existingActivity.getElement().equals(activityToAnalyze.getElement()) || !existingActivity.getType().equals(activityToAnalyze.getType())) continue;
                        WorkplanDuplicateRemoval.mergeActivities(existingActivity, activityToAnalyze);
                        merged = true;
                        break;
                    }
                }
                if (merged) continue;
                Activity modificationActivity = WorkplanDuplicateRemoval.copyActivity(activityToAnalyze);
                result.add(modificationActivity);
                MapUtil.putOrAddToMap(objectsWithActivity, modificationActivity.getElement(), modificationActivity);
                continue;
            }
            result.add(WorkplanDuplicateRemoval.copyActivity(activityToAnalyze));
        }
        return result;
    }

    private static Activity copyActivity(Activity activityToCopy) {
        Activity result = new Activity(activityToCopy.getType(), activityToCopy.getElementType(), activityToCopy.getElement(), activityToCopy.getElementName(), activityToCopy.getCausingElementsNames(), activityToCopy.getBasicActivity(), activityToCopy.getDescription());
        for (Activity subActivity : activityToCopy.getSubActivities()) {
            result.addSubActivity(WorkplanDuplicateRemoval.copyActivity(subActivity));
        }
        for (Activity followUpActivity : activityToCopy.getFollowupActivities()) {
            result.addFollowupActivity(WorkplanDuplicateRemoval.copyActivity(followUpActivity));
        }
        return result;
    }

    private static void mergeActivities(Activity existingActivity, Activity activityToAnalyze) {
        List<Activity> followUpActivities = new LinkedList<Activity>();
        followUpActivities.addAll(existingActivity.getFollowupActivities());
        followUpActivities.addAll(activityToAnalyze.getFollowupActivities());
        followUpActivities = WorkplanDuplicateRemoval.removeModificationDuplicates(followUpActivities);
        existingActivity.getFollowupActivities().clear();
        existingActivity.addFollowUpActivities(followUpActivities);
        List<Activity> subActivities = new LinkedList<Activity>();
        subActivities.addAll(existingActivity.getSubActivities());
        subActivities.addAll(activityToAnalyze.getSubActivities());
        subActivities = WorkplanDuplicateRemoval.removeModificationDuplicates(subActivities);
        existingActivity.getSubActivities().clear();
        existingActivity.addSubActivities(subActivities);
        if (existingActivity.getElementType().getElementClass().isAssignableFrom(activityToAnalyze.getElementType().getElementClass())) {
            existingActivity.setElementType(activityToAnalyze.getElementType());
        }
        existingActivity.getCausingElementsNames().addAll(activityToAnalyze.getCausingElementsNames());
    }
}

