/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.kamp.workplan;

import edu.kit.ipd.sdq.kamp.workplan.Activity;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import jxl.Workbook;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;

public class ExcelWriter {
    public static final int COLUMN_PREFIX = 0;
    public static final int COLUMN_ACTIVITYTYPE = 1;
    public static final int COLUMN_DESCRIPTION = 2;
    public static final int COLUMN_ELEMENTNAME = 3;
    public static final int COLUMN_CAUSES = 4;
    private int currentRow;
    private WritableSheet sheet;

    public void saveActivitiesToExcelFile(String filename, List<Activity> activityList, String prefix) {
        WritableWorkbook workbook = null;
        this.currentRow = 0;
        try {
            workbook = Workbook.createWorkbook((File)new File(filename));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (workbook != null) {
            String username = System.getProperty("user.name");
            this.sheet = workbook.createSheet("Work plan" + (username != null ? " " + username : ""), 0);
            this.addLabelToSheet(this.sheet, 1, this.currentRow, "Activity type");
            this.addLabelToSheet(this.sheet, 2, this.currentRow, "Activity description");
            this.addLabelToSheet(this.sheet, 3, this.currentRow, "Affected element");
            this.addLabelToSheet(this.sheet, 4, this.currentRow, "Causing elements");
            ++this.currentRow;
            this.saveActivitiesToExcelFile(activityList, "");
            try {
                workbook.write();
                workbook.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (WriteException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void addLabelToSheet(WritableSheet sheet, int column, int row, String text) {
        Label label = new Label(column, row, text);
        try {
            sheet.addCell((WritableCell)label);
        }
        catch (RowsExceededException e) {
            throw new RuntimeException(e);
        }
        catch (WriteException e) {
            throw new RuntimeException(e);
        }
    }

    protected void saveActivitiesToExcelFile(List<Activity> activityList, String prefix) {
        for (Activity activity : activityList) {
            this.addLabelToSheet(this.sheet, 0, this.currentRow, prefix);
            this.addLabelToSheet(this.sheet, 1, this.currentRow, activity.getType().getName());
            this.addLabelToSheet(this.sheet, 2, this.currentRow, activity.getDescription());
            this.addLabelToSheet(this.sheet, 3, this.currentRow, activity.getElementName());
            this.addLabelToSheet(this.sheet, 4, this.currentRow, ExcelWriter.concatenate(activity.getCausingElementsNames()));
            ++this.currentRow;
            this.saveActivitiesToExcelFile(activity.getSubActivities(), String.valueOf(prefix) + "=");
            this.saveActivitiesToExcelFile(activity.getFollowupActivities(), String.valueOf(prefix) + "=>");
        }
    }

    private static String concatenate(Collection<String> strings) {
        StringBuilder result = new StringBuilder();
        for (String oneString : strings) {
            result = result.append(oneString).append(", ");
        }
        if (result.length() >= 2) {
            result.delete(result.length() - 2, result.length());
        }
        return result.toString();
    }
}

