/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.kamp.workplan;

import edu.kit.ipd.sdq.kamp.workplan.AbstractActivityElementType;
import edu.kit.ipd.sdq.kamp.workplan.AbstractActivityType;
import edu.kit.ipd.sdq.kamp.workplan.BasicActivity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.emf.ecore.EObject;

public class Activity {
    private AbstractActivityType type;
    private AbstractActivityElementType elementType;
    private String elementName;
    private EObject element;
    private SortedSet<String> causingElementsNames;
    private BasicActivity basicActivity;
    private String description;
    private Activity parentActivity;
    private List<Activity> subActivities;
    private List<Activity> followupActivities;

    public Activity(AbstractActivityType type, AbstractActivityElementType elementType, EObject element, String elementName, Collection<String> causingElementsNames, BasicActivity basicActivity, String description) {
        this.type = type;
        this.elementType = elementType;
        this.element = element;
        this.elementName = elementName;
        this.causingElementsNames = causingElementsNames != null ? new TreeSet<String>(causingElementsNames) : new TreeSet<String>();
        this.basicActivity = basicActivity;
        this.description = description;
        this.subActivities = new ArrayList<Activity>();
        this.followupActivities = new ArrayList<Activity>();
    }

    public AbstractActivityType getType() {
        return this.type;
    }

    public AbstractActivityElementType getElementType() {
        return this.elementType;
    }

    public void setElementType(AbstractActivityElementType elementType) {
        this.elementType = elementType;
    }

    public String getElementName() {
        return this.elementName;
    }

    public BasicActivity getBasicActivity() {
        return this.basicActivity;
    }

    public String getDescription() {
        return this.description;
    }

    public void addSubActivities(Collection<Activity> subActivities) {
        for (Activity subActivity : subActivities) {
            this.addSubActivity(subActivity);
        }
    }

    public void addSubActivity(Activity subActivity) {
        this.subActivities.add(subActivity);
        subActivity.parentActivity = this;
    }

    public void addFollowUpActivities(Collection<Activity> followUpActivities) {
        for (Activity followUpActivity : followUpActivities) {
            this.addFollowupActivity(followUpActivity);
        }
    }

    public void addFollowupActivity(Activity followupActivity) {
        this.followupActivities.add(followupActivity);
        followupActivity.parentActivity = this;
    }

    public EObject getElement() {
        return this.element;
    }

    public SortedSet<String> getCausingElementsNames() {
        return this.causingElementsNames;
    }

    public List<Activity> getSubActivities() {
        return this.subActivities;
    }

    public List<Activity> getFollowupActivities() {
        return this.followupActivities;
    }

    public Activity getParentActivity() {
        return this.parentActivity;
    }
}

