/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.kamp.workplan;

import edu.kit.ipd.sdq.kamp.architecture.AbstractArchitectureVersion;
import edu.kit.ipd.sdq.kamp.workplan.Activity;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.EObject;

public abstract class AbstractWorkplanDerivation<T extends AbstractArchitectureVersion<?>> {
    public abstract List<Activity> deriveWorkplan(T var1, T var2);

    protected abstract void checkForDifferencesAndAddToWorkplan(Diff var1, List<Activity> var2);

    public static List<Diff> calculateDiffModel(EObject source, EObject target) {
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)target, (Notifier)source, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        return differences;
    }

    protected List<Activity> deriveAddAndRemoveActivities(List<Diff> diff) {
        ArrayList<Activity> workplan = new ArrayList<Activity>();
        for (Diff diffElement : diff) {
            this.checkForDifferencesAndAddToWorkplan(diffElement, workplan);
        }
        return workplan;
    }

    public static boolean isChangedElementInstanceOfClass(Diff diffElements, Class<?> targetElementType) {
        return targetElementType.isInstance(((ReferenceChange)diffElements).getValue());
    }

    public static boolean detectionRuleAdded(Diff diffElements, Class<?> modelElementClass) {
        return diffElements instanceof ReferenceChange && diffElements.getKind() == DifferenceKind.ADD && AbstractWorkplanDerivation.isChangedElementInstanceOfClass(diffElements, modelElementClass);
    }

    public static boolean detectionRuleDeleted(Diff diffElements, Class<?> modelElementClass) {
        return diffElements instanceof ReferenceChange && diffElements.getKind() == DifferenceKind.DELETE && AbstractWorkplanDerivation.isChangedElementInstanceOfClass(diffElements, modelElementClass);
    }
}

