/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.kamp.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MapUtil {
    public static <S, T extends Set<U>, U, V extends S, W extends Collection<? extends U>> void putOrAddToMap(Map<S, T> initialMap, Map<V, W> mapToAdd) {
        for (Map.Entry<V, W> entryToAdd : mapToAdd.entrySet()) {
            MapUtil.putOrAddToMap(initialMap, entryToAdd.getKey(), (Collection)entryToAdd.getValue());
        }
    }

    public static <S, T extends Set<U>, U, V extends S, W extends Collection<? extends U>> void putOrAddToMap(Map<S, T> map, V key, W values) {
        if (!values.isEmpty()) {
            if (!map.containsKey(key)) {
                map.put(key, new HashSet());
            }
            ((Set)map.get(key)).addAll(values);
        }
    }

    public static <S, T extends Set<U>, U, V extends U> void putOrAddToMap(Map<S, T> map, S key, V value) {
        if (!map.containsKey(key)) {
            map.put(key, new HashSet());
        }
        ((Set)map.get(key)).add(value);
    }

    public static <S, T> void removeAllFromMap(Map<? super S, T> map, Collection<? extends S> keysToRemove) {
        for (S key : keysToRemove) {
            map.remove(key);
        }
    }

    public static <S, T extends Collection<U>, U> void removeAllFromMap(Map<? super S, T> map, Map<? super S, T> mapToRemove) {
        for (Map.Entry<S, T> entryToRemove : mapToRemove.entrySet()) {
            if (!map.containsKey(entryToRemove.getKey())) continue;
            ((Collection)map.get(entryToRemove.getKey())).removeAll((Collection)entryToRemove.getValue());
            if (!((Collection)map.get(entryToRemove.getKey())).isEmpty()) continue;
            map.remove(entryToRemove.getKey());
        }
    }

    public static <S, T> void retainAll(Map<S, T> map, Collection<? extends S> keysToRetain) {
        HashSet<S> keysToRemove = new HashSet<S>(map.keySet());
        keysToRemove.removeAll(keysToRetain);
        MapUtil.removeAllFromMap(map, keysToRemove);
    }
}

