/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.kamp.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class FileAndFolderManagement {
    public static IContainer retrieveSelectedFolder(ISelection aselection) {
        if (aselection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)aselection;
            ArrayList<IContainer> selectedFolders = new ArrayList<IContainer>();
            for (Object partSelection : structuredSelection.toList()) {
                if (!(partSelection instanceof IFolder) && !(partSelection instanceof IProject)) continue;
                selectedFolders.add((IContainer)partSelection);
            }
            if (selectedFolders.size() == 1) {
                return (IContainer)selectedFolders.get(0);
            }
        }
        return null;
    }

    public static IFile retrieveFileWithExtension(IContainer folder, String fileExtension) {
        try {
            IResource[] iResourceArray = folder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IFile && resource.getFileExtension().equals(fileExtension)) {
                    return (IFile)resource;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static Collection<IFile> retrieveFilesWithExtension(IContainer folder, String fileExtension) {
        LinkedList<IFile> result = new LinkedList<IFile>();
        try {
            IResource[] iResourceArray = folder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IFile && resource.getFileExtension().equals(fileExtension)) {
                    result.add((IFile)resource);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

