/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.kamp.ui;

import edu.kit.ipd.sdq.kamp.util.FileAndFolderManagement;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IActionDelegate;

public class CreateSubalternativeAction
implements IActionDelegate {
    private ISelection selection;

    public void run(IAction action) {
        String PREFIX = "subversion";
        IContainer selectedFolder = FileAndFolderManagement.retrieveSelectedFolder(this.selection);
        IFolder newFolder = null;
        newFolder = this.determineNewSubfolder("subversion", selectedFolder);
        if (newFolder != null) {
            this.createFolderIfNotExisting(newFolder);
            this.copyContentsOfParentFolderIntoSubfolder(selectedFolder, newFolder);
        }
    }

    private void copyContentsOfParentFolderIntoSubfolder(IContainer selectedFolder, IFolder newFolder) {
        if (newFolder.exists()) {
            try {
                IResource[] iResourceArray = selectedFolder.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource = iResourceArray[n2];
                    if (resource instanceof IFile) {
                        IPath destination = newFolder.getFullPath().append(resource.getName());
                        resource.copy(destination, true, null);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void createFolderIfNotExisting(IFolder newFolder) {
        if (!newFolder.exists()) {
            try {
                newFolder.create(true, true, null);
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private IFolder determineNewSubfolder(String PREFIX, IContainer selectedFolder) {
        IFolder newFolder = null;
        int count = 1;
        if (selectedFolder instanceof IFolder) {
            while (((IFolder)selectedFolder).getFolder(String.valueOf(PREFIX) + count).exists()) {
                ++count;
            }
            newFolder = ((IFolder)selectedFolder).getFolder(String.valueOf(PREFIX) + count);
        } else if (selectedFolder instanceof IProject) {
            while (((IProject)selectedFolder).getFolder(String.valueOf(PREFIX) + count).exists()) {
                ++count;
            }
            newFolder = ((IProject)selectedFolder).getFolder(String.valueOf(PREFIX) + count);
        }
        return newFolder;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }
}

