/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.kamp.ui;

import edu.kit.ipd.sdq.kamp.architecture.AbstractArchitectureVersion;
import edu.kit.ipd.sdq.kamp.architecture.AbstractArchitectureVersionPersistency;
import edu.kit.ipd.sdq.kamp.util.FileAndFolderManagement;
import edu.kit.ipd.sdq.kamp.workplan.AbstractEnrichedWorkplanDerivation;
import edu.kit.ipd.sdq.kamp.workplan.AbstractWorkplanDerivation;
import edu.kit.ipd.sdq.kamp.workplan.Activity;
import edu.kit.ipd.sdq.kamp.workplan.WorkplanDuplicateRemoval;
import edu.kit.ipd.sdq.kamp.workplan.WorkplanSorter;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractDeriveWorkplanAction<T extends AbstractArchitectureVersion<?>>
implements IActionDelegate {
    private AbstractWorkplanDerivation<? super T> workplanDerivation;
    private AbstractEnrichedWorkplanDerivation<? super T> enrichedWorkplanDerivation;
    private AbstractArchitectureVersionPersistency<? extends T> architectureVersionPersistency;
    private ISelection selection;

    public void run(IAction action) {
        IContainer selectedFolder = FileAndFolderManagement.retrieveSelectedFolder(this.getSelection());
        if (selectedFolder != null) {
            T targetversion = this.loadVersion(selectedFolder, "target");
            T baseversion = this.loadVersion(selectedFolder.getParent(), "base");
            if (baseversion != null && targetversion != null) {
                String username = System.getProperty("user.name");
                String usernameSuffix = username != null ? "-" + username : "";
                List<Activity> baseActivityList = this.getWorkplanDerivation().deriveWorkplan(baseversion, targetversion);
                baseActivityList = WorkplanDuplicateRemoval.removeModificationDuplicates(baseActivityList);
                WorkplanSorter.sortWorkplanActivities(baseActivityList);
                this.getArchitectureVersionPersistency().saveActivityListToExcelFile(selectedFolder.getFullPath().toString(), "workplan-base" + usernameSuffix, baseActivityList);
                List<Activity> enrichedActivityList = this.getEnrichedWorkplanDerivation().deriveEnrichedWorkplan(baseversion, targetversion, baseActivityList);
                WorkplanSorter.sortWorkplanActivities(enrichedActivityList);
                this.getArchitectureVersionPersistency().saveActivityListToExcelFile(selectedFolder.getFullPath().toString(), "workplan-enriched" + usernameSuffix, enrichedActivityList);
                AbstractDeriveWorkplanAction.showMessage("Activity lists have been calculated.");
                AbstractDeriveWorkplanAction.refreshAllProjectsInWorkspace();
            }
            if (baseversion == null) {
                AbstractDeriveWorkplanAction.showMessage("Activity list could not be calculated, as the base version was not found.");
            }
            if (targetversion == null) {
                AbstractDeriveWorkplanAction.showMessage("Activity list could not be calculated, as the target version was not found.");
            }
        }
    }

    protected T loadVersion(IContainer folder, String versionName) {
        T result = null;
        if (folder != null) {
            result = this.getArchitectureVersionPersistency().load(folder, versionName);
        }
        return result;
    }

    public static void showMessage(String text) {
        if (text != null && !text.trim().equals("")) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            int style = 2;
            MessageBox messageBox = new MessageBox(shell, style);
            messageBox.setMessage(text);
            messageBox.open();
        }
    }

    protected static void refreshAllProjectsInWorkspace() {
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                project.refreshLocal(2, null);
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
            ++n2;
        }
    }

    protected ISelection getSelection() {
        return this.selection;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    protected AbstractWorkplanDerivation<? super T> getWorkplanDerivation() {
        return this.workplanDerivation;
    }

    protected void setWorkplanDerivation(AbstractWorkplanDerivation<? super T> differenceCalculation) {
        this.workplanDerivation = differenceCalculation;
    }

    protected AbstractEnrichedWorkplanDerivation<? super T> getEnrichedWorkplanDerivation() {
        return this.enrichedWorkplanDerivation;
    }

    protected void setEnrichedWorkplanDerivation(AbstractEnrichedWorkplanDerivation<? super T> enrichedWorkplanDerivation) {
        this.enrichedWorkplanDerivation = enrichedWorkplanDerivation;
    }

    protected AbstractArchitectureVersionPersistency<? extends T> getArchitectureVersionPersistency() {
        return this.architectureVersionPersistency;
    }

    protected void setArchitectureVersionPersistency(AbstractArchitectureVersionPersistency<? extends T> architectureVersionPersistency) {
        this.architectureVersionPersistency = architectureVersionPersistency;
    }
}

