/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.kamp.propagation;

import edu.kit.ipd.sdq.kamp.architecture.ArchitectureModelLookup;
import edu.kit.ipd.sdq.kamp.model.modificationmarks.AbstractChangePropagationStep;
import edu.kit.ipd.sdq.kamp.model.modificationmarks.AbstractModification;
import edu.kit.ipd.sdq.kamp.model.modificationmarks.AbstractModificationRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class UserDecisionAnalysis {
    public static void considerUserDecisions(AbstractModificationRepository<?, ?> modificationRepository) {
        ArrayList<Object> elementsToAnalyze = new ArrayList<Object>(ArchitectureModelLookup.lookUpExcludedElements(modificationRepository));
        ArrayList<Object> elementsToRemove = new ArrayList<Object>(elementsToAnalyze);
        Set<AbstractModification> modifications = ArchitectureModelLookup.lookUpAllModificationMarksOfAType(modificationRepository, AbstractModification.class);
        while (!elementsToAnalyze.isEmpty()) {
            Object objectToAnalyze = elementsToAnalyze.remove(0);
            for (AbstractModification modification : modifications) {
                boolean objectIsCause = UserDecisionAnalysis.removeCauseForElement(modification, objectToAnalyze);
                if (!objectIsCause || !UserDecisionAnalysis.hasModificationNoCauses(modification) || elementsToRemove.contains(modification.getAffectedElement())) continue;
                elementsToRemove.add(modification.getAffectedElement());
                elementsToAnalyze.add(modification.getAffectedElement());
            }
        }
        UserDecisionAnalysis.removeModificationsForElementsFromRepository(elementsToRemove, modificationRepository);
    }

    protected static boolean removeCauseForElement(AbstractModification<?, ?> modification, Object cause) {
        return modification.getCausingElements().remove(cause);
    }

    protected static boolean hasModificationNoCauses(AbstractModification<?, ?> modification) {
        return modification.getCausingElements().isEmpty();
    }

    protected static void removeModificationsForElementsFromRepository(Collection<Object> affectedElementsToRemove, AbstractModificationRepository<?, ?> modificationRepository) {
        if (!affectedElementsToRemove.isEmpty()) {
            LinkedList<AbstractModification> modificationsToRemove = new LinkedList<AbstractModification>();
            TreeIterator iterator = modificationRepository.eAllContents();
            while (iterator.hasNext()) {
                AbstractModification modification;
                EObject eObject = (EObject)iterator.next();
                if (!(eObject instanceof AbstractModification) || !affectedElementsToRemove.contains((modification = (AbstractModification)eObject).getAffectedElement())) continue;
                modificationsToRemove.add(modification);
            }
            for (EObject eObject : modificationsToRemove) {
                EcoreUtil.remove((EObject)eObject);
            }
            for (AbstractChangePropagationStep abstractChangePropagationStep : new ArrayList(modificationRepository.getChangePropagationSteps())) {
                if (!abstractChangePropagationStep.eContents().isEmpty()) continue;
                modificationRepository.getChangePropagationSteps().remove((Object)abstractChangePropagationStep);
            }
        }
    }
}

