/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.kamp.architecture;

import edu.kit.ipd.sdq.kamp.architecture.AbstractArchitectureVersion;
import edu.kit.ipd.sdq.kamp.model.modificationmarks.AbstractChangePropagationStep;
import edu.kit.ipd.sdq.kamp.model.modificationmarks.AbstractModification;
import edu.kit.ipd.sdq.kamp.model.modificationmarks.AbstractModificationRepository;
import edu.kit.ipd.sdq.kamp.model.modificationmarks.AcceptanceAndConfirmationState;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ArchitectureModelLookup {
    public static <T> Set<T> lookUpMarkedObjectsOfAType(AbstractArchitectureVersion<?> version, Class<T> objectClass) {
        return ArchitectureModelLookup.lookUpMarkedObjectsOfATypeInAnIterator(((AbstractModificationRepository)version.getModificationMarkRepository()).eAllContents(), objectClass);
    }

    public static <T> Set<T> lookUpMarkedObjectsOfATypeInSeedModifications(AbstractArchitectureVersion<?> version, Class<T> objectClass) {
        return ArchitectureModelLookup.lookUpMarkedObjectsOfATypeInAnIterator(((AbstractModificationRepository)version.getModificationMarkRepository()).getSeedModifications().eAllContents(), objectClass);
    }

    public static <T> Set<T> lookUpMarkedObjectsOfATypeInAnIterator(Iterator<?> objectsToSearch, Class<T> objectClass) {
        HashSet<Object> results = new HashSet<Object>();
        while (objectsToSearch.hasNext()) {
            AbstractModification modification;
            Object object = objectsToSearch.next();
            if (!(object instanceof AbstractModification) || (modification = (AbstractModification)object).getAffectedElement() == null || !objectClass.isAssignableFrom(modification.getAffectedElement().getClass())) continue;
            results.add(modification.getAffectedElement());
        }
        return results;
    }

    public static <T extends AbstractModification<?, ?>> Set<T> lookUpAllModificationMarksOfAType(AbstractArchitectureVersion<?> version, Class<T> modificationClass) {
        return ArchitectureModelLookup.lookUpAllModificationMarksOfATypeInAnIterator(modificationClass, ((AbstractModificationRepository)version.getModificationMarkRepository()).eAllContents());
    }

    public static <T extends AbstractModification<?, ?>> Set<T> lookUpAllModificationMarksOfAType(AbstractModificationRepository<?, ?> modificationRepository, Class<T> modificationClass) {
        return ArchitectureModelLookup.lookUpAllModificationMarksOfATypeInAnIterator(modificationClass, modificationRepository.eAllContents());
    }

    public static <T extends AbstractModification<?, ?>> Set<T> lookUpAllSeedModificationMarksOfAType(AbstractArchitectureVersion<?> version, Class<T> modificationClass) {
        return ArchitectureModelLookup.lookUpAllModificationMarksOfATypeInAnIterator(modificationClass, ((AbstractModificationRepository)version.getModificationMarkRepository()).getSeedModifications().eAllContents());
    }

    public static <T extends AbstractModification<?, ?>> Set<T> lookUpAllCalculatedMarksOfAType(AbstractArchitectureVersion<?> version, Class<T> modificationClass) {
        HashSet<T> results = new HashSet<T>();
        for (AbstractChangePropagationStep cpStep : ((AbstractModificationRepository)version.getModificationMarkRepository()).getChangePropagationSteps()) {
            results.addAll(ArchitectureModelLookup.lookUpAllModificationMarksOfATypeInAnIterator(modificationClass, cpStep.eAllContents()));
        }
        return results;
    }

    private static <T extends AbstractModification<?, ?>> Set<T> lookUpAllModificationMarksOfATypeInAnIterator(Class<T> modificationClass, Iterator<?> objectsToSearch) {
        HashSet<AbstractModification> results = new HashSet<AbstractModification>();
        while (objectsToSearch.hasNext()) {
            Object object = objectsToSearch.next();
            if (!modificationClass.isAssignableFrom(object.getClass())) continue;
            results.add((AbstractModification)object);
        }
        return results;
    }

    public static Set<Object> lookUpExcludedElements(AbstractModificationRepository<?, ?> modificationRepository) {
        HashSet<Object> result = new HashSet<Object>();
        Set<AbstractModification> modificationMarks = ArchitectureModelLookup.lookUpAllModificationMarksOfAType(modificationRepository, AbstractModification.class);
        for (AbstractModification modificationMark : modificationMarks) {
            if (modificationMark.getUserDecision() != AcceptanceAndConfirmationState.EXCLUDED) continue;
            result.add(modificationMark.getAffectedElement());
        }
        return result;
    }
}

