/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.kamp.architecture;

import edu.kit.ipd.sdq.kamp.architecture.AbstractArchitectureVersion;
import edu.kit.ipd.sdq.kamp.model.modificationmarks.ModificationmarksPackage;
import edu.kit.ipd.sdq.kamp.workplan.Activity;
import edu.kit.ipd.sdq.kamp.workplan.ExcelWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;

public abstract class AbstractArchitectureVersionPersistency<T extends AbstractArchitectureVersion<?>> {
    private ExcelWriter excelWriter = new ExcelWriter();
    public static final String FILEEXTENSION_ACTIVITYLIST = "activitylist";
    public static final String FILEEXTENSION_EXCEL = "xls";
    public static final String FILEEXTENSION_MODIFICATIONMARK = "modificationmarks";

    public abstract T load(String var1, String var2, String var3);

    public abstract T load(IContainer var1, String var2);

    public abstract void save(String var1, String var2, T var3);

    public void saveModificationMarkFile(String targetDirectoryPath, String filename, T version) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        String internalModFilePath = String.valueOf(filename) + "." + FILEEXTENSION_MODIFICATIONMARK;
        if (((AbstractArchitectureVersion)version).getModificationMarkRepository() != null) {
            AbstractArchitectureVersionPersistency.saveEmfModelToResource(((AbstractArchitectureVersion)version).getModificationMarkRepository(), targetDirectoryPath, internalModFilePath, (ResourceSet)resourceSet);
        }
    }

    public void saveActivityListToTextFile(String targetDirectoryPath, String filename, List<Activity> activityList) {
        String activityListFilePath = String.valueOf(filename) + "." + FILEEXTENSION_ACTIVITYLIST;
        String workspaceURI = ResourcesPlugin.getWorkspace().getRoot().getLocationURI().getPath().toString();
        File file = new File(String.valueOf(workspaceURI) + "/" + targetDirectoryPath + "/" + activityListFilePath);
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        try {
            file.createNewFile();
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            if (writer != null) {
                this.saveActivityListToTextFile(writer, activityList, "");
            }
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void saveActivityListToTextFile(FileWriter writer, List<Activity> activityList, String prefix) {
        try {
            if (writer != null) {
                if (prefix == null) {
                    prefix = "";
                }
                for (Activity activity : activityList) {
                    writer.write(String.valueOf(prefix) + " " + (Object)((Object)activity.getBasicActivity()) + " " + activity.getElementType() + " " + activity.getElementName());
                    writer.write("\n");
                    if (!activity.getSubActivities().isEmpty()) {
                        this.saveActivityListToTextFile(writer, activity.getSubActivities(), String.valueOf(prefix) + "=");
                    }
                    if (activity.getFollowupActivities().isEmpty()) continue;
                    this.saveActivityListToTextFile(writer, activity.getFollowupActivities(), String.valueOf(prefix) + "->");
                }
                writer.flush();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void saveActivityListToExcelFile(String targetDirectoryPath, String filename, List<Activity> activityList) {
        String activityListFilePath = String.valueOf(filename) + "." + FILEEXTENSION_EXCEL;
        String workspaceURI = ResourcesPlugin.getWorkspace().getRoot().getLocationURI().getPath().toString();
        ExcelWriter excelWriter = this.getExcelWriter();
        excelWriter.saveActivitiesToExcelFile(String.valueOf(workspaceURI) + "/" + targetDirectoryPath + "/" + activityListFilePath, activityList, "");
    }

    public EObject loadEmfModelFromResource(String folderPath, String filePath, ResourceSet resourceSet) {
        this.registerEPackages(resourceSet);
        URI loadURI = URI.createPlatformResourceURI((String)folderPath, (boolean)true);
        if (filePath != null) {
            loadURI = loadURI.appendSegment(filePath);
        }
        try {
            Resource resource = resourceSet.createResource(loadURI);
            ((ResourceImpl)resource).setIntrinsicIDToEObjectMap(new HashMap());
            Map<Object, Object> loadOptions = AbstractArchitectureVersionPersistency.setupLoadOptions(resource);
            resource.load(loadOptions);
            if (!resource.getContents().isEmpty()) {
                return (EObject)resource.getContents().get(0);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    protected void registerEPackages(ResourceSet resourceSet) {
        resourceSet.getPackageRegistry().put((Object)"http://sdq.ipd.kit.edu/Modificationmarks/1.0", (Object)ModificationmarksPackage.eINSTANCE);
    }

    protected static Map<Object, Object> setupLoadOptions(Resource resource) {
        Map loadOptions = ((XMLResourceImpl)resource).getDefaultLoadOptions();
        loadOptions.put("DEFER_ATTACHMENT", Boolean.TRUE);
        loadOptions.put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
        loadOptions.put("USE_DEPRECATED_METHODS", Boolean.TRUE);
        loadOptions.put("USE_PARSER_POOL", new XMLParserPoolImpl());
        loadOptions.put("USE_XML_NAME_TO_FEATURE_MAP", new HashMap());
        return loadOptions;
    }

    public static void saveEmfModelToResource(EObject model, String directoryPath, String fileName, ResourceSet resourceSet) {
        if (directoryPath != null) {
            URI saveURI = URI.createPlatformResourceURI((String)directoryPath, (boolean)true);
            if (fileName != null) {
                saveURI = saveURI.appendSegment(fileName);
            } else if (model.eResource() != null) {
                String segment = model.eResource().getURI().lastSegment();
                saveURI = saveURI.appendSegment(segment);
            }
            Resource resource = resourceSet.createResource(saveURI);
            Map<Object, Object> saveOptions = AbstractArchitectureVersionPersistency.setupLoadOptions(resource);
            resource.getContents().add((Object)model);
            try {
                resource.save(saveOptions);
            }
            catch (IOException e) {
                throw new RuntimeException("Saving of resource failed", e);
            }
        }
    }

    protected ExcelWriter getExcelWriter() {
        return this.excelWriter;
    }

    protected void setExcelWriter(ExcelWriter excelWriter) {
        this.excelWriter = excelWriter;
    }
}

