/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.kamp4req.core.derivation;

import decisions.Decision;
import edu.kit.ipd.sdq.kamp.derivation.AbstractDifferenceCalculation;
import edu.kit.ipd.sdq.kamp.workplan.AbstractActivityElementType;
import edu.kit.ipd.sdq.kamp.workplan.AbstractActivityType;
import edu.kit.ipd.sdq.kamp.workplan.Activity;
import edu.kit.ipd.sdq.kamp.workplan.BasicActivity;
import edu.kit.ipd.sdq.kamp4bp.core.BPArchitectureVersion;
import edu.kit.ipd.sdq.kamp4bp.core.derivation.BPDifferenceCalculation;
import edu.kit.ipd.sdq.kamp4is.core.ISActivityType;
import edu.kit.ipd.sdq.kamp4req.core.ReqActivityElementType;
import edu.kit.ipd.sdq.kamp4req.core.ReqArchitectureVersion;
import edu.kit.ipd.sdq.kamp4req.core.derivation.ReqInternalModificationDerivation;
import java.util.List;
import options.Option;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.ecore.EObject;
import requirements.Requirement;

public class ReqDifferenceCalculation
extends AbstractDifferenceCalculation<ReqArchitectureVersion> {
    private final BPDifferenceCalculation bpDifferenceCalculation = new BPDifferenceCalculation();
    private final ReqInternalModificationDerivation reqInternalModificationDerivation = new ReqInternalModificationDerivation();

    public List<Activity> deriveWorkplan(ReqArchitectureVersion baseVersion, ReqArchitectureVersion targetVersion) {
        List activityList = this.bpDifferenceCalculation.deriveWorkplan((BPArchitectureVersion)baseVersion, (BPArchitectureVersion)targetVersion);
        activityList.addAll(this.deriveAddAndRemoveActivities(ReqDifferenceCalculation.calculateDiffModel((EObject)baseVersion.getRequirementsRepository(), (EObject)targetVersion.getRequirementsRepository())));
        activityList.addAll(this.deriveAddAndRemoveActivities(ReqDifferenceCalculation.calculateDiffModel((EObject)baseVersion.getDecisionRepository(), (EObject)targetVersion.getDecisionRepository())));
        activityList.addAll(this.deriveAddAndRemoveActivities(ReqDifferenceCalculation.calculateDiffModel((EObject)baseVersion.getOptionRepository(), (EObject)targetVersion.getOptionRepository())));
        activityList.addAll(this.reqInternalModificationDerivation.deriveInternalModifications(targetVersion));
        return activityList;
    }

    protected void checkForDifferencesAndAddToWorkplan(Diff diffElement, List<Activity> workplan) {
        this.bpDifferenceCalculation.checkForDifferencesAndAddToWorkplan(diffElement, workplan);
        if (ReqDifferenceCalculation.detectionRuleAdded((Diff)diffElement, Requirement.class)) {
            Requirement requirement = (Requirement)((ReferenceChange)diffElement).getValue();
            String elementName = "\"" + requirement.getSpecification() + "\"";
            workplan.add(ReqDifferenceCalculation.createReqAddActivity((EObject)requirement, elementName));
        } else if (ReqDifferenceCalculation.detectionRuleDeleted((Diff)diffElement, Requirement.class)) {
            Requirement requirement = (Requirement)((ReferenceChange)diffElement).getValue();
            String elementName = "\"" + requirement.getSpecification() + "\"";
            workplan.add(ReqDifferenceCalculation.createReqRemoveActivity((EObject)requirement, elementName));
        } else if (ReqDifferenceCalculation.detectionRuleAdded((Diff)diffElement, Decision.class)) {
            Decision decision = (Decision)((ReferenceChange)diffElement).getValue();
            String elementName = "\"" + decision.getDescription() + "\"";
            workplan.add(ReqDifferenceCalculation.createReqAddActivity((EObject)decision, elementName));
        } else if (ReqDifferenceCalculation.detectionRuleDeleted((Diff)diffElement, Decision.class)) {
            Decision decision = (Decision)((ReferenceChange)diffElement).getValue();
            String elementName = "\"" + decision.getDescription() + "\"";
            workplan.add(ReqDifferenceCalculation.createReqRemoveActivity((EObject)decision, elementName));
        } else if (ReqDifferenceCalculation.detectionRuleAdded((Diff)diffElement, Option.class)) {
            Option option = (Option)((ReferenceChange)diffElement).getValue();
            String elementName = "\"" + option.getDescription() + "\"";
            workplan.add(ReqDifferenceCalculation.createReqAddActivity((EObject)option, elementName));
        } else if (ReqDifferenceCalculation.detectionRuleDeleted((Diff)diffElement, Option.class)) {
            Option option = (Option)((ReferenceChange)diffElement).getValue();
            String elementName = "\"" + option.getDescription() + "\"";
            workplan.add(ReqDifferenceCalculation.createReqRemoveActivity((EObject)option, elementName));
        }
    }

    protected static Activity createReqAddActivity(EObject element, String elementName) {
        ReqActivityElementType activityElementType = ReqActivityElementType.getActivityTypeForObject(element);
        return new Activity((AbstractActivityType)ISActivityType.INTERNALMODIFICATIONMARK, (AbstractActivityElementType)activityElementType, element, elementName, null, BasicActivity.MODIFY, "Add " + element.eClass().getName() + " " + elementName + ".");
    }

    protected static Activity createReqRemoveActivity(EObject element, String elementName) {
        ReqActivityElementType activityElementType = ReqActivityElementType.getActivityTypeForObject(element);
        return new Activity((AbstractActivityType)ISActivityType.INTERNALMODIFICATIONMARK, (AbstractActivityElementType)activityElementType, element, elementName, null, BasicActivity.MODIFY, "Remove " + element.eClass().getName() + " " + elementName + ".");
    }
}

