/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.kamp4req.core;

import decisions.Decision;
import edu.kit.ipd.sdq.kamp.architecture.AbstractArchitectureVersion;
import edu.kit.ipd.sdq.kamp.architecture.ArchitectureModelLookup;
import edu.kit.ipd.sdq.kamp.model.modificationmarks.AbstractModification;
import edu.kit.ipd.sdq.kamp.util.MapUtil;
import edu.kit.ipd.sdq.kamp4bp.core.BPArchitectureVersion;
import edu.kit.ipd.sdq.kamp4bp.core.BPChangePropagationAnalysis;
import edu.kit.ipd.sdq.kamp4bp.model.modificationmarks.BPChangePropagationDueToDataDependencies;
import edu.kit.ipd.sdq.kamp4is.core.AbstractISChangePropagationAnalysis;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.AbstractISModificationRepository;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.ISModificationmarksFactory;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.ISModifyDataType;
import edu.kit.ipd.sdq.kamp4req.core.ReqArchitectureModelLookup;
import edu.kit.ipd.sdq.kamp4req.core.ReqArchitectureVersion;
import edu.kit.ipd.sdq.kamp4req.model.modificationmarks.ReqChangePropagationDueToSpecificationDependencies;
import edu.kit.ipd.sdq.kamp4req.model.modificationmarks.ReqModificationmarksFactory;
import edu.kit.ipd.sdq.kamp4req.model.modificationmarks.ReqModifyDecision;
import edu.kit.ipd.sdq.kamp4req.model.modificationmarks.ReqModifyEntity;
import edu.kit.ipd.sdq.kamp4req.model.modificationmarks.ReqModifyOption;
import edu.kit.ipd.sdq.kamp4req.model.modificationmarks.ReqModifyRequirement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import options.Option;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.repository.DataType;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import relations.TraceableObject;
import requirements.Requirement;

public class ReqChangePropagationAnalysis
extends AbstractISChangePropagationAnalysis<ReqArchitectureVersion, BPChangePropagationDueToDataDependencies> {
    private BPChangePropagationAnalysis bpChangePropagationAnalysis;
    private ReqChangePropagationDueToSpecificationDependencies changePropagationDueToSpecificationDependencies;
    private Collection<Requirement> markedRequirements;
    private Collection<Decision> markedDecisions;
    private Collection<Option> markedOptions;

    public void runChangePropagationAnalysis(ReqArchitectureVersion version) {
        HashMap elementsMarkedInThisStep = new HashMap();
        this.prepareAnalysis(version);
        this.calculateRequirementsToArchitecturePropagation(version, elementsMarkedInThisStep);
        this.getBpChangePropagationAnalysis().runChangePropagationAnalysis((BPArchitectureVersion)version);
    }

    private void prepareAnalysis(ReqArchitectureVersion version) {
        this.setBpChangePropagationAnalysis(new BPChangePropagationAnalysis());
        this.setReqChangePropagationDueToSpecificationDependencies(ReqModificationmarksFactory.eINSTANCE.createReqChangePropagationDueToSpecificationDependencies());
        ((AbstractISModificationRepository)version.getModificationMarkRepository()).getChangePropagationSteps().add((Object)this.getReqChangePropagationDueToSpecificationDependencies());
        this.setMarkedRequirements(ArchitectureModelLookup.lookUpMarkedObjectsOfAType((AbstractArchitectureVersion)version, Requirement.class));
        this.setMarkedDecisions(ArchitectureModelLookup.lookUpMarkedObjectsOfAType((AbstractArchitectureVersion)version, Decision.class));
        this.setMarkedOptions(ArchitectureModelLookup.lookUpMarkedObjectsOfAType((AbstractArchitectureVersion)version, Option.class));
    }

    public void calculateRequirementsToArchitecturePropagation(ReqArchitectureVersion version, Map<EObject, AbstractModification<?, EObject>> elementsMarkedInThisStep) {
        Map requirementsToBeMarked = ReqArchitectureModelLookup.lookUpObjectsDependOnObjects(this.getMarkedRequirements(), Requirement.class);
        this.createAndAddRequirementModifications(requirementsToBeMarked, elementsMarkedInThisStep);
        this.calculateAndMarkRequirementToDecisionAndOptionPropagation(elementsMarkedInThisStep);
        Map decisionsToBeMarked = ReqArchitectureModelLookup.lookUpObjectsDependOnObjects(this.getMarkedDecisions(), Decision.class);
        this.createAndAddDecisionModifications(decisionsToBeMarked, elementsMarkedInThisStep);
        Map optionsToBeMarked = ReqArchitectureModelLookup.lookUpObjectsDependOnObjects(this.getMarkedOptions(), Option.class);
        this.createAndAddOptionModifications(optionsToBeMarked, elementsMarkedInThisStep);
        this.calculateAndMarkDecisionToArchitectureAndBusinessProcessPropagation(version, elementsMarkedInThisStep);
        this.calculateAndMarkOptionToArchitectureAndBusinessProcessPropagation(version, elementsMarkedInThisStep);
        if (this.getReqChangePropagationDueToSpecificationDependencies().eContents().isEmpty()) {
            ((AbstractISModificationRepository)version.getModificationMarkRepository()).getChangePropagationSteps().remove((Object)this.getReqChangePropagationDueToSpecificationDependencies());
        }
    }

    protected void calculateAndMarkRequirementToDecisionAndOptionPropagation(Map<EObject, AbstractModification<?, EObject>> elementsMarkedInThisStep) {
        HashMap decisionsToBeMarked = new HashMap();
        MapUtil.putOrAddToMap(decisionsToBeMarked, ReqArchitectureModelLookup.lookUpDecisionsTriggeredByTriggerObjects(this.getMarkedRequirements()));
        MapUtil.putOrAddToMap(decisionsToBeMarked, ReqArchitectureModelLookup.lookUpDecisionsResolvingResolveObjects(this.getMarkedRequirements()));
        MapUtil.putOrAddToMap(decisionsToBeMarked, ReqArchitectureModelLookup.lookUpDecisionsCouldBeResolvingResolveObjects(this.getMarkedRequirements()));
        this.createAndAddDecisionModifications(decisionsToBeMarked, elementsMarkedInThisStep);
        HashMap optionsToBeMarked = new HashMap();
        MapUtil.putOrAddToMap(optionsToBeMarked, ReqArchitectureModelLookup.lookUpOptionsTriggeredByTriggerObjects(this.getMarkedRequirements()));
        MapUtil.putOrAddToMap(optionsToBeMarked, ReqArchitectureModelLookup.lookUpOptionsResolvingResolveObjects(this.getMarkedRequirements()));
        MapUtil.putOrAddToMap(optionsToBeMarked, ReqArchitectureModelLookup.lookUpOptionsCouldBeResolvingResolveObjects(this.getMarkedRequirements()));
        this.createAndAddOptionModifications(optionsToBeMarked, elementsMarkedInThisStep);
    }

    protected void calculateAndMarkDecisionToArchitectureAndBusinessProcessPropagation(ReqArchitectureVersion version, Map<EObject, AbstractModification<?, EObject>> elementsMarkedInThisStep) {
        Map dataTypesToBeMarked = ReqArchitectureModelLookup.lookUpDataTypesReferencedByDecisions(version, this.getMarkedDecisions());
        this.createAndAddDataTypeModifications(dataTypesToBeMarked, elementsMarkedInThisStep);
        Map interfacesToBeMarked = ReqArchitectureModelLookup.lookUpInterfacesReferencedByDecisions(version, this.getMarkedDecisions());
        this.createAndAddInterfaceModifications(interfacesToBeMarked, elementsMarkedInThisStep);
        Map componentsToBeMarked = ReqArchitectureModelLookup.lookUpComponentsReferencedByDecisions(version, this.getMarkedDecisions());
        this.createAndAddComponentModifications(componentsToBeMarked, elementsMarkedInThisStep);
        Map entitiesToBeMarked = ReqArchitectureModelLookup.lookUpEntitiesReferencedByDecisions(version, this.getMarkedDecisions());
        this.createAndAddEntityModifications(entitiesToBeMarked, elementsMarkedInThisStep);
    }

    protected void calculateAndMarkOptionToArchitectureAndBusinessProcessPropagation(ReqArchitectureVersion version, Map<EObject, AbstractModification<?, EObject>> elementsMarkedInThisStep) {
        Map dataTypesToBeMarked = ReqArchitectureModelLookup.lookUpDataTypesReferencedByOptions(version, this.getMarkedOptions());
        this.createAndAddDataTypeModifications(dataTypesToBeMarked, elementsMarkedInThisStep);
        Map interfacesToBeMarked = ReqArchitectureModelLookup.lookUpInterfacesReferencedByOptions(version, this.getMarkedOptions());
        this.createAndAddInterfaceModifications(interfacesToBeMarked, elementsMarkedInThisStep);
        Map componentsToBeMarked = ReqArchitectureModelLookup.lookUpComponentsReferencedByOptions(version, this.getMarkedOptions());
        this.createAndAddComponentModifications(componentsToBeMarked, elementsMarkedInThisStep);
        Map entitiesToBeMarked = ReqArchitectureModelLookup.lookUpEntitiesReferencedByOptions(version, this.getMarkedOptions());
        this.createAndAddEntityModifications(entitiesToBeMarked, elementsMarkedInThisStep);
    }

    private <T extends TraceableObject> void createAndAddDataTypeModifications(Map<DataType, Set<T>> dataTypesToBeMarked, Map<EObject, AbstractModification<?, EObject>> elementsMarkedInThisStep) {
        for (Map.Entry<DataType, Set<T>> dataTypeToBeMarkedEntry : dataTypesToBeMarked.entrySet()) {
            if (elementsMarkedInThisStep.containsKey(dataTypeToBeMarkedEntry.getKey())) {
                elementsMarkedInThisStep.get(dataTypeToBeMarkedEntry.getKey()).getCausingElements().addAll((Collection)dataTypeToBeMarkedEntry.getValue());
                continue;
            }
            ISModifyDataType modifyDataType = ISModificationmarksFactory.eINSTANCE.createISModifyDataType();
            modifyDataType.setToolderived(true);
            modifyDataType.setAffectedElement((Object)dataTypeToBeMarkedEntry.getKey());
            modifyDataType.getCausingElements().addAll((Collection)dataTypeToBeMarkedEntry.getValue());
            elementsMarkedInThisStep.put((EObject)dataTypeToBeMarkedEntry.getKey(), (AbstractModification<?, EObject>)modifyDataType);
            this.getReqChangePropagationDueToSpecificationDependencies().getDataTypeModifications().add((Object)modifyDataType);
        }
    }

    private <T extends TraceableObject> void createAndAddInterfaceModifications(Map<OperationInterface, Set<T>> interfacesToBeMarked, Map<EObject, AbstractModification<?, EObject>> elementsMarkedInThisStep) {
        for (Map.Entry<OperationInterface, Set<T>> interfaceToBeMarkedEntry : interfacesToBeMarked.entrySet()) {
            if (elementsMarkedInThisStep.containsKey(interfaceToBeMarkedEntry.getKey())) {
                elementsMarkedInThisStep.get(interfaceToBeMarkedEntry.getKey()).getCausingElements().addAll((Collection)interfaceToBeMarkedEntry.getValue());
                continue;
            }
            ReqModifyEntity modifyInterface = ReqModificationmarksFactory.eINSTANCE.createReqModifyEntity();
            modifyInterface.setToolderived(true);
            modifyInterface.setAffectedElement((Object)((Entity)interfaceToBeMarkedEntry.getKey()));
            modifyInterface.getCausingElements().addAll((Collection)interfaceToBeMarkedEntry.getValue());
            elementsMarkedInThisStep.put((EObject)interfaceToBeMarkedEntry.getKey(), (AbstractModification<?, EObject>)modifyInterface);
            this.getReqChangePropagationDueToSpecificationDependencies().getEntityModifications().add((Object)modifyInterface);
        }
    }

    private <T extends TraceableObject> void createAndAddComponentModifications(Map<RepositoryComponent, Set<T>> componentsToBeMarked, Map<EObject, AbstractModification<?, EObject>> elementsMarkedInThisStep) {
        for (Map.Entry<RepositoryComponent, Set<T>> componentToBeMarkedEntry : componentsToBeMarked.entrySet()) {
            if (elementsMarkedInThisStep.containsKey(componentToBeMarkedEntry.getKey())) {
                elementsMarkedInThisStep.get(componentToBeMarkedEntry.getKey()).getCausingElements().addAll((Collection)componentToBeMarkedEntry.getValue());
                continue;
            }
            ReqModifyEntity modifyComponent = ReqModificationmarksFactory.eINSTANCE.createReqModifyEntity();
            modifyComponent.setToolderived(true);
            modifyComponent.setAffectedElement((Object)((Entity)componentToBeMarkedEntry.getKey()));
            modifyComponent.getCausingElements().addAll((Collection)componentToBeMarkedEntry.getValue());
            elementsMarkedInThisStep.put((EObject)componentToBeMarkedEntry.getKey(), (AbstractModification<?, EObject>)modifyComponent);
            this.getReqChangePropagationDueToSpecificationDependencies().getEntityModifications().add((Object)modifyComponent);
        }
    }

    private <T extends TraceableObject> void createAndAddEntityModifications(Map<Entity, Set<T>> entitysToBeMarked, Map<EObject, AbstractModification<?, EObject>> elementsMarkedInThisStep) {
        for (Map.Entry<Entity, Set<T>> entityToBeMarkedEntry : entitysToBeMarked.entrySet()) {
            if (elementsMarkedInThisStep.containsKey(entityToBeMarkedEntry.getKey())) {
                elementsMarkedInThisStep.get(entityToBeMarkedEntry.getKey()).getCausingElements().addAll((Collection)entityToBeMarkedEntry.getValue());
                continue;
            }
            ReqModifyEntity modifyEntity = ReqModificationmarksFactory.eINSTANCE.createReqModifyEntity();
            modifyEntity.setToolderived(true);
            modifyEntity.setAffectedElement((Object)entityToBeMarkedEntry.getKey());
            modifyEntity.getCausingElements().addAll((Collection)entityToBeMarkedEntry.getValue());
            elementsMarkedInThisStep.put((EObject)entityToBeMarkedEntry.getKey(), (AbstractModification<?, EObject>)modifyEntity);
            this.getReqChangePropagationDueToSpecificationDependencies().getEntityModifications().add((Object)modifyEntity);
        }
    }

    private <S extends EObject> void createAndAddRequirementModifications(Map<Requirement, Set<S>> requirementsToBeMarked, Map<EObject, AbstractModification<?, EObject>> elementsMarkedInThisStep) {
        ReqChangePropagationAnalysis.filterCircularCauses(requirementsToBeMarked, elementsMarkedInThisStep);
        for (Map.Entry<Requirement, Set<S>> requirementToBeMarkedEntry : requirementsToBeMarked.entrySet()) {
            Requirement requirement = requirementToBeMarkedEntry.getKey();
            if (elementsMarkedInThisStep.containsKey(requirement)) {
                elementsMarkedInThisStep.get(requirement).getCausingElements().addAll((Collection)requirementToBeMarkedEntry.getValue());
                continue;
            }
            ReqModifyRequirement modifyRequirement = ReqModificationmarksFactory.eINSTANCE.createReqModifyRequirement();
            modifyRequirement.setToolderived(true);
            modifyRequirement.setAffectedElement((Object)requirement);
            modifyRequirement.getCausingElements().addAll((Collection)requirementToBeMarkedEntry.getValue());
            elementsMarkedInThisStep.put((EObject)requirement, (AbstractModification<?, EObject>)modifyRequirement);
            this.getMarkedRequirements().add(requirement);
            this.getReqChangePropagationDueToSpecificationDependencies().getRequirementModifications().add((Object)modifyRequirement);
        }
    }

    private <S extends EObject> void createAndAddDecisionModifications(Map<Decision, Set<S>> decisionsToBeMarked, Map<EObject, AbstractModification<?, EObject>> elementsMarkedInThisStep) {
        ReqChangePropagationAnalysis.filterCircularCauses(decisionsToBeMarked, elementsMarkedInThisStep);
        for (Map.Entry<Decision, Set<S>> decisionToBeMarkedEntry : decisionsToBeMarked.entrySet()) {
            Decision decision = decisionToBeMarkedEntry.getKey();
            if (elementsMarkedInThisStep.containsKey(decision)) {
                elementsMarkedInThisStep.get(decision).getCausingElements().addAll((Collection)decisionToBeMarkedEntry.getValue());
                continue;
            }
            ReqModifyDecision modifyDecision = ReqModificationmarksFactory.eINSTANCE.createReqModifyDecision();
            modifyDecision.setToolderived(true);
            modifyDecision.setAffectedElement((Object)decision);
            modifyDecision.getCausingElements().addAll((Collection)decisionToBeMarkedEntry.getValue());
            elementsMarkedInThisStep.put((EObject)decision, (AbstractModification<?, EObject>)modifyDecision);
            this.getMarkedDecisions().add(decision);
            this.getReqChangePropagationDueToSpecificationDependencies().getDecisionModifications().add((Object)modifyDecision);
        }
    }

    private <S extends EObject> void createAndAddOptionModifications(Map<Option, Set<S>> optionsToBeMarked, Map<EObject, AbstractModification<?, EObject>> elementsMarkedInThisStep) {
        ReqChangePropagationAnalysis.filterCircularCauses(optionsToBeMarked, elementsMarkedInThisStep);
        for (Map.Entry<Option, Set<S>> optionToBeMarkedEntry : optionsToBeMarked.entrySet()) {
            Option option = optionToBeMarkedEntry.getKey();
            if (elementsMarkedInThisStep.containsKey(option)) {
                elementsMarkedInThisStep.get(option).getCausingElements().addAll((Collection)optionToBeMarkedEntry.getValue());
                continue;
            }
            ReqModifyOption modifyOption = ReqModificationmarksFactory.eINSTANCE.createReqModifyOption();
            modifyOption.setToolderived(true);
            modifyOption.setAffectedElement((Object)option);
            modifyOption.getCausingElements().addAll((Collection)optionToBeMarkedEntry.getValue());
            elementsMarkedInThisStep.put((EObject)option, (AbstractModification<?, EObject>)modifyOption);
            this.getMarkedOptions().add(option);
            this.getReqChangePropagationDueToSpecificationDependencies().getOptionModifications().add((Object)modifyOption);
        }
    }

    private static <S extends EObject, T extends TraceableObject> void filterCircularCauses(Map<T, Set<S>> objectsToBeMarked, Map<EObject, AbstractModification<?, EObject>> elementsMarkedInThisStep) {
        HashMap circularMarks = new HashMap();
        for (Map.Entry<T, Set<S>> objectsToBeMarkedEntry : objectsToBeMarked.entrySet()) {
            for (EObject causingObject : objectsToBeMarkedEntry.getValue()) {
                if (!elementsMarkedInThisStep.containsKey(causingObject) || !elementsMarkedInThisStep.get(causingObject).getCausingElements().contains(objectsToBeMarkedEntry.getKey())) continue;
                MapUtil.putOrAddToMap(circularMarks, (Object)((TraceableObject)objectsToBeMarkedEntry.getKey()), (Object)causingObject);
            }
        }
        MapUtil.removeAllFromMap(objectsToBeMarked, circularMarks);
    }

    private BPChangePropagationAnalysis getBpChangePropagationAnalysis() {
        return this.bpChangePropagationAnalysis;
    }

    private void setBpChangePropagationAnalysis(BPChangePropagationAnalysis bpChangePropagationAnalysis) {
        this.bpChangePropagationAnalysis = bpChangePropagationAnalysis;
    }

    private ReqChangePropagationDueToSpecificationDependencies getReqChangePropagationDueToSpecificationDependencies() {
        return this.changePropagationDueToSpecificationDependencies;
    }

    private void setReqChangePropagationDueToSpecificationDependencies(ReqChangePropagationDueToSpecificationDependencies changePropagationDueToSpecificationDependencies) {
        this.changePropagationDueToSpecificationDependencies = changePropagationDueToSpecificationDependencies;
    }

    private Collection<Requirement> getMarkedRequirements() {
        return this.markedRequirements;
    }

    private void setMarkedRequirements(Collection<Requirement> markedRequirements) {
        this.markedRequirements = markedRequirements;
    }

    private Collection<Decision> getMarkedDecisions() {
        return this.markedDecisions;
    }

    private void setMarkedDecisions(Collection<Decision> markedDecisions) {
        this.markedDecisions = markedDecisions;
    }

    private Collection<Option> getMarkedOptions() {
        return this.markedOptions;
    }

    private void setMarkedOptions(Collection<Option> markedOptions) {
        this.markedOptions = markedOptions;
    }
}

