/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.kamp4is.core.derivation;

import edu.kit.ipd.sdq.kamp.architecture.AbstractArchitectureVersion;
import edu.kit.ipd.sdq.kamp.architecture.ArchitectureModelLookup;
import edu.kit.ipd.sdq.kamp.model.modificationmarks.AbstractModification;
import edu.kit.ipd.sdq.kamp.workplan.AbstractActivityElementType;
import edu.kit.ipd.sdq.kamp.workplan.AbstractActivityType;
import edu.kit.ipd.sdq.kamp.workplan.Activity;
import edu.kit.ipd.sdq.kamp.workplan.BasicActivity;
import edu.kit.ipd.sdq.kamp4is.core.ISActivityElementType;
import edu.kit.ipd.sdq.kamp4is.core.ISActivityType;
import edu.kit.ipd.sdq.kamp4is.core.ISArchitectureVersion;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.ISModifyComponent;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.ISModifyDataType;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.ISModifyEntity;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.ISModifyInterface;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.ISModifyProvidedRole;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.ISModifyRequiredRole;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.ISModifySignature;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.provider.ISLabelCustomizing;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.repository.DataType;

public class ISInternalModificationDerivation {
    public static List<String> getCausingElementsNames(AbstractModification<?, ?> modification) {
        LinkedList<String> causingElementNames = new LinkedList<String>();
        for (Object causingElement : modification.getCausingElements()) {
            if (causingElement instanceof Entity) {
                Entity causingEntity = (Entity)causingElement;
                causingElementNames.add(String.valueOf(causingEntity.eClass().getName()) + " \"" + causingEntity.getEntityName() + "\"");
                continue;
            }
            if (!(causingElement instanceof DataType)) continue;
            DataType causingDataType = (DataType)causingElement;
            causingElementNames.add(String.valueOf(causingDataType.eClass().getName()) + " \"" + ISLabelCustomizing.getDataTypeName((DataType)causingDataType) + "\"");
        }
        return causingElementNames;
    }

    public static Activity createModificationActivity(AbstractModification<?, ?> modification, List<String> causingElementNames, AbstractActivityElementType activityElementType) {
        if (modification instanceof ISModifyEntity) {
            Entity entity = (Entity)((ISModifyEntity)modification).getAffectedElement();
            return new Activity((AbstractActivityType)ISActivityType.INTERNALMODIFICATIONMARK, activityElementType, (EObject)entity, entity.getEntityName(), causingElementNames, BasicActivity.MODIFY, "Modify " + entity.eClass().getName() + " " + entity.getEntityName() + ".");
        }
        if (modification instanceof ISModifyDataType) {
            DataType dataType = (DataType)((ISModifyDataType)modification).getAffectedElement();
            String dataTypeName = ISLabelCustomizing.getDataTypeName((DataType)dataType);
            return new Activity((AbstractActivityType)ISActivityType.INTERNALMODIFICATIONMARK, activityElementType, (EObject)dataType, dataTypeName, causingElementNames, BasicActivity.MODIFY, "Modify DataType " + dataTypeName + ".");
        }
        return null;
    }

    public static Activity createModificationActivity(AbstractModification<?, ?> modification, AbstractActivityElementType activityElementType) {
        List<String> causingElementNames = ISInternalModificationDerivation.getCausingElementsNames(modification);
        return ISInternalModificationDerivation.createModificationActivity(modification, causingElementNames, activityElementType);
    }

    public static Activity addModificationSubActivity(AbstractModification<?, ?> modification, AbstractActivityElementType activityType, Activity superActivity) {
        Activity result = ISInternalModificationDerivation.createModificationActivity(modification, activityType);
        superActivity.addSubActivity(result);
        return result;
    }

    public List<Activity> deriveInternalModifications(ISArchitectureVersion targetVersion) {
        ArrayList<Activity> activityList = new ArrayList<Activity>();
        this.deriveComponentModifications(targetVersion, activityList);
        this.deriveInterfaceModifications(targetVersion, activityList);
        return activityList;
    }

    private void deriveComponentModifications(ISArchitectureVersion targetVersion, List<Activity> activityList) {
        Set modifyComponents = ArchitectureModelLookup.lookUpAllCalculatedMarksOfAType((AbstractArchitectureVersion)targetVersion, ISModifyComponent.class);
        for (ISModifyComponent modifyComponent : modifyComponents) {
            Activity componentActivity = ISInternalModificationDerivation.createModificationActivity(modifyComponent, ISActivityElementType.COMPONENT);
            activityList.add(componentActivity);
            this.deriveSubActivities(modifyComponent, componentActivity);
        }
    }

    private void deriveInterfaceModifications(ISArchitectureVersion targetVersion, List<Activity> activityList) {
        Set modifyInterfaces = ArchitectureModelLookup.lookUpAllCalculatedMarksOfAType((AbstractArchitectureVersion)targetVersion, ISModifyInterface.class);
        for (ISModifyInterface modifyInterface : modifyInterfaces) {
            Activity interfaceActivity = ISInternalModificationDerivation.createModificationActivity(modifyInterface, ISActivityElementType.INTERFACE);
            activityList.add(interfaceActivity);
            for (ISModifySignature modifySignature : modifyInterface.getSignatureModifications()) {
                ISInternalModificationDerivation.addModificationSubActivity(modifySignature, ISActivityElementType.SIGNATURE, interfaceActivity);
            }
        }
    }

    private void deriveSubActivities(ISModifyComponent modifyComponent, Activity componentActivity) {
        for (ISModifyProvidedRole modifyProvidedRole : modifyComponent.getProvidedRoleModifications()) {
            Activity providedRoleActivity = ISInternalModificationDerivation.addModificationSubActivity(modifyProvidedRole, ISActivityElementType.PROVIDEDROLE, componentActivity);
            for (ISModifySignature modifySignature : modifyProvidedRole.getSignatureModifications()) {
                ISInternalModificationDerivation.addModificationSubActivity(modifySignature, ISActivityElementType.PROVIDEDOPERATION, providedRoleActivity);
            }
        }
        for (ISModifyRequiredRole modifyRequiredRole : modifyComponent.getRequiredRoleModifications()) {
            Activity requiredRoleActivity = ISInternalModificationDerivation.addModificationSubActivity(modifyRequiredRole, ISActivityElementType.REQUIREDROLE, componentActivity);
            for (ISModifySignature modifySignature : modifyRequiredRole.getSignatureModifications()) {
                ISInternalModificationDerivation.addModificationSubActivity(modifySignature, ISActivityElementType.REQUIREDOPERATION, requiredRoleActivity);
            }
        }
    }
}

