/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.kamp4is.core;

import de.uka.ipd.sdq.componentInternalDependencies.RoleToRoleDependency;
import edu.kit.ipd.sdq.kamp.architecture.AbstractArchitectureVersion;
import edu.kit.ipd.sdq.kamp.architecture.ArchitectureModelLookup;
import edu.kit.ipd.sdq.kamp.util.MapUtil;
import edu.kit.ipd.sdq.kamp4is.core.ISArchitectureVersion;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.ISModifyComponent;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.ISModifyProvidedRole;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.ISModifyRequiredRole;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.ISModifySignature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.palladiosimulator.pcm.core.composition.AssemblyConnector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.Connector;
import org.palladiosimulator.pcm.repository.CompositeComponent;
import org.palladiosimulator.pcm.repository.DataType;
import org.palladiosimulator.pcm.repository.EventGroup;
import org.palladiosimulator.pcm.repository.Interface;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.Parameter;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.repository.Role;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.repository.SinkRole;
import org.palladiosimulator.pcm.repository.SourceRole;

public class ISArchitectureModelLookup {
    public static List<AssemblyConnector> lookUpAssemblyConnectorsAttachedToProvidedRole(ISArchitectureVersion version, ProvidedRole providedRole) {
        ArrayList<AssemblyConnector> assemblyConnectors = new ArrayList<AssemblyConnector>();
        RepositoryComponent component = (RepositoryComponent)providedRole.getProvidingEntity_ProvidedRole();
        List<AssemblyContext> assemblyContexts = ISArchitectureModelLookup.lookUpAssemblyContextsForRepositoryComponent(version, component);
        for (AssemblyContext assemblycontext : assemblyContexts) {
            for (Connector connector : assemblycontext.getParentStructure__AssemblyContext().getConnectors__ComposedStructure()) {
                if (!(connector instanceof AssemblyConnector) || ((AssemblyConnector)connector).getProvidedRole_AssemblyConnector() != providedRole) continue;
                assemblyConnectors.add((AssemblyConnector)connector);
            }
        }
        return assemblyConnectors;
    }

    public static List<AssemblyContext> lookUpAssemblyContextsForRepositoryComponent(ISArchitectureVersion version, RepositoryComponent component) {
        ArrayList<AssemblyContext> assemblyContexts = new ArrayList<AssemblyContext>();
        for (AssemblyContext assemblyContext : version.getSystem().getAssemblyContexts__ComposedStructure()) {
            if (assemblyContext.getEncapsulatedComponent__AssemblyContext() != component) continue;
            assemblyContexts.add(assemblyContext);
        }
        assemblyContexts.addAll(ISArchitectureModelLookup.lookUpAssemblyContextsInCompositeComponents(version, component));
        return assemblyContexts;
    }

    public static List<CompositeComponent> lookUpCompositeComponents(ISArchitectureVersion version) {
        ArrayList<CompositeComponent> compositeComponents = new ArrayList<CompositeComponent>();
        for (RepositoryComponent component : version.getRepository().getComponents__Repository()) {
            if (!(component instanceof CompositeComponent)) continue;
            compositeComponents.add((CompositeComponent)component);
        }
        return compositeComponents;
    }

    public static List<OperationRequiredRole> lookUpRequiredRolesForAssemblyConnectors(List<AssemblyConnector> assemblyConnectors) {
        ArrayList<OperationRequiredRole> results = new ArrayList<OperationRequiredRole>();
        for (AssemblyConnector assemblyConnector : assemblyConnectors) {
            results.add(assemblyConnector.getRequiredRole_AssemblyConnector());
        }
        return results;
    }

    private static List<AssemblyContext> lookUpAssemblyContextsInCompositeComponents(ISArchitectureVersion version, RepositoryComponent component) {
        ArrayList<AssemblyContext> assemblyContexts = new ArrayList<AssemblyContext>();
        List<CompositeComponent> compositeComponents = ISArchitectureModelLookup.lookUpCompositeComponents(version);
        for (CompositeComponent compositeComponent : compositeComponents) {
            for (AssemblyContext assemblyContext : compositeComponent.getAssemblyContexts__ComposedStructure()) {
                if (assemblyContext.getEncapsulatedComponent__AssemblyContext() != component) continue;
                assemblyContexts.add(assemblyContext);
            }
        }
        return assemblyContexts;
    }

    public static Map<Signature, Interface> lookUpSignaturesWithInterfaces(Collection<Interface> interfaces) {
        HashMap<Signature, Interface> results = new HashMap<Signature, Interface>();
        for (Interface interfac : interfaces) {
            if (interfac instanceof OperationInterface) {
                for (Signature signature : ((OperationInterface)interfac).getSignatures__OperationInterface()) {
                    results.put(signature, interfac);
                }
                continue;
            }
            if (!(interfac instanceof EventGroup)) continue;
            for (Signature signature : ((EventGroup)interfac).getEventTypes__EventGroup()) {
                results.put(signature, interfac);
            }
        }
        return results;
    }

    public static void lookUpInterfacesAndSignaturesWithParametersOfTypes(ISArchitectureVersion version, Collection<DataType> dataTypes, Map<Interface, Set<Signature>> affectedInterfaces, Map<Signature, Set<DataType>> affectedSignatures) {
        for (Interface interfac : version.getRepository().getInterfaces__Repository()) {
            for (DataType dataType : dataTypes) {
                if (interfac instanceof OperationInterface) {
                    OperationInterface operationInterface = (OperationInterface)interfac;
                    for (OperationSignature signature : operationInterface.getSignatures__OperationInterface()) {
                        ISArchitectureModelLookup.checkSignatureForDatatype(signature, operationInterface, dataType, affectedInterfaces, affectedSignatures);
                    }
                    continue;
                }
                if (!(interfac instanceof EventGroup)) continue;
                EventGroup eventGroup = (EventGroup)interfac;
                for (OperationSignature signature : eventGroup.getEventTypes__EventGroup()) {
                    if (signature.getParameter__EventType() == null) continue;
                    ISArchitectureModelLookup.checkDataTypeForDataType(signature.getParameter__EventType().getDataType__Parameter(), (Signature)signature, interfac, dataType, affectedInterfaces, affectedSignatures);
                }
            }
        }
    }

    protected static void checkSignatureForDatatype(OperationSignature signature, OperationInterface interfac, DataType dataType, Map<Interface, Set<Signature>> affectedInterfaces, Map<Signature, Set<DataType>> affectedSignatures) {
        for (Parameter parameter : signature.getParameters__OperationSignature()) {
            ISArchitectureModelLookup.checkDataTypeForDataType(parameter.getDataType__Parameter(), (Signature)signature, (Interface)interfac, dataType, affectedInterfaces, affectedSignatures);
        }
        ISArchitectureModelLookup.checkDataTypeForDataType(signature.getReturnType__OperationSignature(), (Signature)signature, (Interface)interfac, dataType, affectedInterfaces, affectedSignatures);
    }

    protected static void checkDataTypeForDataType(DataType typeToCheck, Signature signature, Interface interfac, DataType targetType, Map<Interface, Set<Signature>> affectedInterfaces, Map<Signature, Set<DataType>> affectedSignatures) {
        if (targetType != null && targetType.equals(typeToCheck)) {
            MapUtil.putOrAddToMap(affectedSignatures, (Object)signature, (Object)targetType);
            MapUtil.putOrAddToMap(affectedInterfaces, (Object)interfac, (Object)signature);
        }
    }

    public static Map<Interface, Set<Signature>> lookUpInterfacesAndSignaturesWithSignatures(ISArchitectureVersion version, Collection<Signature> signatures) {
        HashMap<Interface, Set<Signature>> results = new HashMap<Interface, Set<Signature>>();
        for (Interface interfac : version.getRepository().getInterfaces__Repository()) {
            HashSet<Signature> matchingSignatures = new HashSet<Signature>(signatures);
            if (interfac instanceof OperationInterface) {
                OperationInterface operationInterface = (OperationInterface)interfac;
                matchingSignatures.retainAll((Collection<?>)operationInterface.getSignatures__OperationInterface());
                MapUtil.putOrAddToMap(results, (Object)operationInterface, matchingSignatures);
                continue;
            }
            if (!(interfac instanceof EventGroup)) continue;
            EventGroup eventGroup = (EventGroup)interfac;
            matchingSignatures.retainAll((Collection<?>)eventGroup.getEventTypes__EventGroup());
            MapUtil.putOrAddToMap(results, (Object)eventGroup, matchingSignatures);
        }
        return results;
    }

    public static void lookUpComponentsAndRolesWithInterfaces(ISArchitectureVersion version, Collection<Interface> interfaces, Map<RepositoryComponent, Set<Role>> affectedComponents, Map<ProvidedRole, Interface> affectedProvidedRoles, Map<RequiredRole, Interface> affectedRequiredRoles) {
        for (RepositoryComponent component : version.getRepository().getComponents__Repository()) {
            for (Interface interfac : interfaces) {
                for (ProvidedRole providedRole : component.getProvidedRoles_InterfaceProvidingEntity()) {
                    if ((!(providedRole instanceof OperationProvidedRole) || !interfac.equals(((OperationProvidedRole)providedRole).getProvidedInterface__OperationProvidedRole())) && (!(providedRole instanceof SinkRole) || !interfac.equals(((SinkRole)providedRole).getEventGroup__SinkRole()))) continue;
                    MapUtil.putOrAddToMap(affectedComponents, (Object)component, (Object)providedRole);
                    affectedProvidedRoles.put(providedRole, interfac);
                }
                for (RequiredRole requiredRole : component.getRequiredRoles_InterfaceRequiringEntity()) {
                    if ((!(requiredRole instanceof OperationRequiredRole) || !interfac.equals(((OperationRequiredRole)requiredRole).getRequiredInterface__OperationRequiredRole())) && (!(requiredRole instanceof SourceRole) || !interfac.equals(((SourceRole)requiredRole).getEventGroup__SourceRole()))) continue;
                    MapUtil.putOrAddToMap(affectedComponents, (Object)component, (Object)requiredRole);
                    affectedRequiredRoles.put(requiredRole, interfac);
                }
            }
        }
    }

    public static Map<ProvidedRole, Set<Signature>> lookUpMarkedProvidedSignaturesForProvidedRoles(Collection<ProvidedRole> providedRoles, ISArchitectureVersion version) {
        HashMap<ProvidedRole, Set<Signature>> results = new HashMap<ProvidedRole, Set<Signature>>();
        Set markedSignatures = ArchitectureModelLookup.lookUpMarkedObjectsOfAType((AbstractArchitectureVersion)version, Signature.class);
        for (ProvidedRole providedRole : providedRoles) {
            HashSet providedSignatures;
            if (providedRole instanceof OperationProvidedRole) {
                providedSignatures = new HashSet(((OperationProvidedRole)providedRole).getProvidedInterface__OperationProvidedRole().getSignatures__OperationInterface());
                providedSignatures.retainAll(markedSignatures);
                results.put(providedRole, providedSignatures);
                continue;
            }
            if (!(providedRole instanceof SinkRole)) continue;
            providedSignatures = new HashSet(((SinkRole)providedRole).getEventGroup__SinkRole().getEventTypes__EventGroup());
            providedSignatures.retainAll(markedSignatures);
            results.put(providedRole, providedSignatures);
        }
        return results;
    }

    public static ISModifySignature lookUpProvidedSignatureMarkForRoleModification(Signature signature, ISModifyProvidedRole modifyProvidedRole) {
        for (ISModifySignature modifySignature : modifyProvidedRole.getSignatureModifications()) {
            if (!signature.equals(modifySignature.getAffectedElement())) continue;
            return modifySignature;
        }
        return null;
    }

    public static Map<RequiredRole, Set<Signature>> lookUpMarkedRequiredSignaturesForRequiredRoles(Collection<RequiredRole> requiredRoles, ISArchitectureVersion version) {
        HashMap<RequiredRole, Set<Signature>> results = new HashMap<RequiredRole, Set<Signature>>();
        Set markedSignatures = ArchitectureModelLookup.lookUpMarkedObjectsOfAType((AbstractArchitectureVersion)version, Signature.class);
        for (RequiredRole requiredRole : requiredRoles) {
            HashSet requiredSignatures;
            if (requiredRole instanceof OperationRequiredRole) {
                requiredSignatures = new HashSet(((OperationRequiredRole)requiredRole).getRequiredInterface__OperationRequiredRole().getSignatures__OperationInterface());
                requiredSignatures.retainAll(markedSignatures);
                results.put(requiredRole, requiredSignatures);
                continue;
            }
            if (!(requiredRole instanceof SourceRole)) continue;
            requiredSignatures = new HashSet(((SourceRole)requiredRole).getEventGroup__SourceRole().getEventTypes__EventGroup());
            requiredSignatures.retainAll(markedSignatures);
            results.put(requiredRole, requiredSignatures);
        }
        return results;
    }

    public static Set<Signature> lookUpMarkedRequiredSignaturesForRequiredRoleModification(ISModifyRequiredRole modifyRequiredRole) {
        HashSet<Signature> requiredSignatures = new HashSet<Signature>();
        for (ISModifySignature modifySignature : modifyRequiredRole.getSignatureModifications()) {
            requiredSignatures.add((Signature)modifySignature.getAffectedElement());
        }
        return requiredSignatures;
    }

    public static Map<RequiredRole, List<RoleToRoleDependency>> lookUpInternalDependenciesWithRequiredRoles(ISArchitectureVersion version, Collection<RequiredRole> requiredRoles) {
        HashMap<RequiredRole, List<RoleToRoleDependency>> results = new HashMap<RequiredRole, List<RoleToRoleDependency>>();
        if (version.getComponentInternalDependencyRepository() != null) {
            for (RoleToRoleDependency dependency : version.getComponentInternalDependencyRepository().getDependencies()) {
                if (!requiredRoles.contains(dependency.getRequiredRole())) continue;
                if (!results.containsKey(dependency.getRequiredRole())) {
                    results.put(dependency.getRequiredRole(), new LinkedList());
                }
                ((List)results.get(dependency.getRequiredRole())).add(dependency);
            }
        }
        return results;
    }

    public static ISModifyProvidedRole lookUpMarkedProvidedRoleForDependency(ISModifyComponent modifyComponent, RoleToRoleDependency roleToRoleDependency) {
        for (ISModifyProvidedRole modifyProvidedRole : modifyComponent.getProvidedRoleModifications()) {
            if (!((ProvidedRole)modifyProvidedRole.getAffectedElement()).equals(roleToRoleDependency.getProvidedRole())) continue;
            return modifyProvidedRole;
        }
        return null;
    }
}

