/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.kamp4is.core;

import de.uka.ipd.sdq.componentInternalDependencies.OperationToOperationDependency;
import de.uka.ipd.sdq.componentInternalDependencies.RoleToRoleDependency;
import edu.kit.ipd.sdq.kamp.architecture.ArchitectureModelLookup;
import edu.kit.ipd.sdq.kamp.propagation.AbstractChangePropagationAnalysis;
import edu.kit.ipd.sdq.kamp.util.MapUtil;
import edu.kit.ipd.sdq.kamp4is.core.ISArchitectureModelLookup;
import edu.kit.ipd.sdq.kamp4is.core.ISArchitectureVersion;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.AbstractISModificationRepository;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.ISChangePropagationDueToDataDependencies;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.ISChangePropagationDueToInterfaceDependencies;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.ISIntercomponentPropagation;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.ISIntracomponentPropagation;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.ISModificationmarksFactory;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.ISModifyComponent;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.ISModifyConnector;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.ISModifyInterface;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.ISModifyProvidedRole;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.ISModifyRequiredRole;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.ISModifySignature;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.core.composition.AssemblyConnector;
import org.palladiosimulator.pcm.repository.DataType;
import org.palladiosimulator.pcm.repository.Interface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.repository.Role;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.repository.SinkRole;

public abstract class AbstractISChangePropagationAnalysis<S extends ISArchitectureVersion, T extends ISChangePropagationDueToDataDependencies>
implements AbstractChangePropagationAnalysis<S> {
    private T changePropagationDueToDataDependencies;
    private Map<ProvidedRole, Set<Signature>> visitedProvidedRoles = new HashMap<ProvidedRole, Set<Signature>>();

    protected void calculateAndMarkToInterfacePropagation(S version) {
        Set initialMarkedSignatures = ArchitectureModelLookup.lookUpMarkedObjectsOfAType(version, Signature.class);
        Set initialMarkedDataTypes = ArchitectureModelLookup.lookUpMarkedObjectsOfAType(version, DataType.class);
        Map<Interface, Set<Signature>> interfacesToBeMarked = ISArchitectureModelLookup.lookUpInterfacesAndSignaturesWithSignatures(version, initialMarkedSignatures);
        HashMap<Signature, Set<DataType>> signaturesToBeMarked = new HashMap<Signature, Set<DataType>>();
        ISArchitectureModelLookup.lookUpInterfacesAndSignaturesWithParametersOfTypes(version, initialMarkedDataTypes, interfacesToBeMarked, signaturesToBeMarked);
        this.createAndAddInterfaceModifications(interfacesToBeMarked, signaturesToBeMarked, (Collection<ISModifyInterface>)this.getChangePropagationDueToDataDependencies().getInterfaceModifications());
    }

    private void createAndAddInterfaceModifications(Map<Interface, Set<Signature>> interfacesToBeMarked, Map<Signature, Set<DataType>> signaturesToBeMarked, Collection<ISModifyInterface> targetCollection) {
        for (Map.Entry<Interface, Set<Signature>> interfaceToBeMarkedEntry : interfacesToBeMarked.entrySet()) {
            ISModifyInterface modifyInterface = ISModificationmarksFactory.eINSTANCE.createISModifyInterface();
            modifyInterface.setToolderived(true);
            modifyInterface.setAffectedElement((Object)interfaceToBeMarkedEntry.getKey());
            modifyInterface.getCausingElements().addAll((Collection)interfaceToBeMarkedEntry.getValue());
            for (Signature signature : interfaceToBeMarkedEntry.getValue()) {
                if (!signaturesToBeMarked.containsKey(signature)) continue;
                ISModifySignature modifySignature = ISModificationmarksFactory.eINSTANCE.createISModifySignature();
                modifySignature.setToolderived(true);
                modifySignature.setAffectedElement((Object)signature);
                modifySignature.getCausingElements().addAll((Collection)signaturesToBeMarked.get(signature));
                modifyInterface.getSignatureModifications().add((Object)modifySignature);
            }
            targetCollection.add(modifyInterface);
        }
    }

    public void calculateInterfaceAndComponentPropagation(S version) {
        ISChangePropagationDueToInterfaceDependencies cp = ISModificationmarksFactory.eINSTANCE.createISChangePropagationDueToInterfaceDependencies();
        this.calculateAndMarkInterfaceToSignaturePropagation(version, cp);
        this.calculateAndMarkInterfaceToComponentPropagation(version, cp);
        if (!cp.eContents().isEmpty()) {
            ((AbstractISModificationRepository)version.getModificationMarkRepository()).getChangePropagationSteps().add((Object)cp);
        }
        HashMap<RequiredRole, Map<ProvidedRole, Set<Signature>>> requiredRolesToBeAnalysedInNextIteration = new HashMap();
        Map<Object, Object> providedRolesToBeAnalysedInNextIteration = new HashMap();
        Set initiallyMarkedRequiredRoles = ArchitectureModelLookup.lookUpMarkedObjectsOfAType(version, RequiredRole.class);
        Map<RequiredRole, Set<Signature>> markedRequiredRolesWithCauses = ISArchitectureModelLookup.lookUpMarkedRequiredSignaturesForRequiredRoles(initiallyMarkedRequiredRoles, version);
        providedRolesToBeAnalysedInNextIteration = this.calculateInitialIntraComponentPropagation(markedRequiredRolesWithCauses, version);
        Set initiallyMarkedProvidedRoles = ArchitectureModelLookup.lookUpMarkedObjectsOfAType(version, ProvidedRole.class);
        Map<ProvidedRole, Set<Signature>> markedProvidedRolesWithCauses = ISArchitectureModelLookup.lookUpMarkedProvidedSignaturesForProvidedRoles(initiallyMarkedProvidedRoles, version);
        MapUtil.putOrAddToMap(providedRolesToBeAnalysedInNextIteration, markedProvidedRolesWithCauses);
        while (!(providedRolesToBeAnalysedInNextIteration = this.calculateIntraComponentPropagation(requiredRolesToBeAnalysedInNextIteration = this.calculateInterComponentPropagation(providedRolesToBeAnalysedInNextIteration, version), version)).isEmpty()) {
        }
    }

    protected void calculateAndMarkInterfaceToSignaturePropagation(S version, ISChangePropagationDueToInterfaceDependencies changePropagation) {
        Set seedInterfaces = ArchitectureModelLookup.lookUpMarkedObjectsOfATypeInSeedModifications(version, Interface.class);
        Map<Signature, Interface> signaturesToBeMarked = ISArchitectureModelLookup.lookUpSignaturesWithInterfaces(seedInterfaces);
        for (Map.Entry<Signature, Interface> signatureToBeMarkedEntry : signaturesToBeMarked.entrySet()) {
            ISModifySignature modifySignature = ISModificationmarksFactory.eINSTANCE.createISModifySignature();
            modifySignature.setToolderived(true);
            modifySignature.setAffectedElement((Object)signatureToBeMarkedEntry.getKey());
            modifySignature.getCausingElements().add((Object)((EObject)signatureToBeMarkedEntry.getValue()));
            changePropagation.getSignatureModifications().add((Object)modifySignature);
        }
    }

    protected void calculateAndMarkInterfaceToComponentPropagation(S version, ISChangePropagationDueToInterfaceDependencies changePropagation) {
        Set initialMarkedInterfaces = ArchitectureModelLookup.lookUpMarkedObjectsOfAType(version, Interface.class);
        HashMap<RepositoryComponent, Set<Role>> componentsToBeMarked = new HashMap<RepositoryComponent, Set<Role>>();
        HashMap<ProvidedRole, Interface> providedRolesToBeMarked = new HashMap<ProvidedRole, Interface>();
        HashMap<RequiredRole, Interface> requiredRolesToBeMarked = new HashMap<RequiredRole, Interface>();
        ISArchitectureModelLookup.lookUpComponentsAndRolesWithInterfaces(version, initialMarkedInterfaces, componentsToBeMarked, providedRolesToBeMarked, requiredRolesToBeMarked);
        this.createAndAddComponentModifications(changePropagation, componentsToBeMarked, providedRolesToBeMarked, requiredRolesToBeMarked);
    }

    private void createAndAddComponentModifications(ISChangePropagationDueToInterfaceDependencies changePropagation, Map<RepositoryComponent, Set<Role>> componentsToBeMarked, Map<ProvidedRole, Interface> providedRolesToBeMarked, Map<RequiredRole, Interface> requiredRolesToBeMarked) {
        for (Map.Entry<RepositoryComponent, Set<Role>> componentToBeMarkedEntry : componentsToBeMarked.entrySet()) {
            ISModifyComponent modifyComponent = ISModificationmarksFactory.eINSTANCE.createISModifyComponent();
            modifyComponent.setToolderived(true);
            modifyComponent.setAffectedElement((Object)componentToBeMarkedEntry.getKey());
            for (Role roleToBeMarked : componentToBeMarkedEntry.getValue()) {
                if (roleToBeMarked instanceof ProvidedRole && providedRolesToBeMarked.containsKey(roleToBeMarked)) {
                    ISModifyProvidedRole modifyProvidedRole = ISModificationmarksFactory.eINSTANCE.createISModifyProvidedRole();
                    modifyProvidedRole.setToolderived(true);
                    modifyProvidedRole.setAffectedElement((Object)((ProvidedRole)roleToBeMarked));
                    modifyProvidedRole.getCausingElements().add((Object)((EObject)providedRolesToBeMarked.get(roleToBeMarked)));
                    modifyComponent.getProvidedRoleModifications().add((Object)modifyProvidedRole);
                    modifyComponent.getCausingElements().add((Object)roleToBeMarked);
                    continue;
                }
                if (!(roleToBeMarked instanceof RequiredRole) || !requiredRolesToBeMarked.containsKey(roleToBeMarked)) continue;
                ISModifyRequiredRole modifyRequiredRole = ISModificationmarksFactory.eINSTANCE.createISModifyRequiredRole();
                modifyRequiredRole.setToolderived(true);
                modifyRequiredRole.setAffectedElement((Object)((RequiredRole)roleToBeMarked));
                modifyRequiredRole.getCausingElements().add((Object)((EObject)requiredRolesToBeMarked.get(roleToBeMarked)));
                modifyComponent.getRequiredRoleModifications().add((Object)modifyRequiredRole);
                modifyComponent.getCausingElements().add((Object)roleToBeMarked);
            }
            if (modifyComponent.getCausingElements().isEmpty()) continue;
            changePropagation.getComponentModifications().add((Object)modifyComponent);
        }
    }

    public Map<ProvidedRole, Set<Signature>> calculateInitialIntraComponentPropagation(Map<RequiredRole, Set<Signature>> requiredRolesToBeAnalyzed, S version) {
        HashMap<ProvidedRole, Set<Signature>> providedRolesToBeAnalysedInNextStep = new HashMap<ProvidedRole, Set<Signature>>();
        Map<RequiredRole, List<RoleToRoleDependency>> dependenciesToBeMarked = ISArchitectureModelLookup.lookUpInternalDependenciesWithRequiredRoles(version, requiredRolesToBeAnalyzed.keySet());
        ISIntracomponentPropagation intracomponentPropagation = ISModificationmarksFactory.eINSTANCE.createISIntracomponentPropagation();
        HashMap<RepositoryComponent, ISModifyComponent> componentsMarkedInThisStep = new HashMap<RepositoryComponent, ISModifyComponent>();
        for (Map.Entry<RequiredRole, List<RoleToRoleDependency>> dependenciesToBeMarkedEntry : dependenciesToBeMarked.entrySet()) {
            RequiredRole requiredRole = dependenciesToBeMarkedEntry.getKey();
            if (!(requiredRole.getRequiringEntity_RequiredRole() instanceof RepositoryComponent)) continue;
            ISModifyComponent modifyComponent = this.createComponentModificationForRequiredRole(requiredRole, componentsMarkedInThisStep, intracomponentPropagation);
            ISModifyRequiredRole modifyRequiredRole = this.createRequiredRoleModification(requiredRole, requiredRolesToBeAnalyzed.get(requiredRole));
            modifyComponent.getRequiredRoleModifications().add((Object)modifyRequiredRole);
            this.calculateRoleToRoleDependencies((Iterable<RoleToRoleDependency>)dependenciesToBeMarkedEntry.getValue(), modifyComponent, providedRolesToBeAnalysedInNextStep, ISArchitectureModelLookup.lookUpMarkedRequiredSignaturesForRequiredRoleModification(modifyRequiredRole));
        }
        if (!intracomponentPropagation.getComponentModifications().isEmpty()) {
            ((AbstractISModificationRepository)version.getModificationMarkRepository()).getChangePropagationSteps().add((Object)intracomponentPropagation);
        }
        return providedRolesToBeAnalysedInNextStep;
    }

    public Map<ProvidedRole, Set<Signature>> calculateIntraComponentPropagation(Map<RequiredRole, Map<ProvidedRole, Set<Signature>>> requiredRolesToBeAnalyzed, S version) {
        HashMap<ProvidedRole, Set<Signature>> providedRolesToBeAnalysedInNextStep = new HashMap<ProvidedRole, Set<Signature>>();
        Map<RequiredRole, List<RoleToRoleDependency>> dependenciesToBeMarked = ISArchitectureModelLookup.lookUpInternalDependenciesWithRequiredRoles(version, requiredRolesToBeAnalyzed.keySet());
        ISIntracomponentPropagation intracomponentPropagation = ISModificationmarksFactory.eINSTANCE.createISIntracomponentPropagation();
        HashMap<RepositoryComponent, ISModifyComponent> componentsMarkedInThisStep = new HashMap<RepositoryComponent, ISModifyComponent>();
        for (Map.Entry<RequiredRole, List<RoleToRoleDependency>> dependenciesToBeMarkedEntry : dependenciesToBeMarked.entrySet()) {
            RequiredRole requiredRole = dependenciesToBeMarkedEntry.getKey();
            if (!(requiredRole.getRequiringEntity_RequiredRole() instanceof RepositoryComponent)) continue;
            ISModifyComponent modifyComponent = this.createComponentModificationForRequiredRole(requiredRole, componentsMarkedInThisStep, intracomponentPropagation);
            ISModifyRequiredRole modifyRequiredRole = this.createRequiredRoleModification(requiredRole, requiredRolesToBeAnalyzed.get(requiredRole));
            modifyComponent.getRequiredRoleModifications().add((Object)modifyRequiredRole);
            this.calculateRoleToRoleDependencies((Iterable<RoleToRoleDependency>)dependenciesToBeMarkedEntry.getValue(), modifyComponent, providedRolesToBeAnalysedInNextStep, ISArchitectureModelLookup.lookUpMarkedRequiredSignaturesForRequiredRoleModification(modifyRequiredRole));
        }
        if (!intracomponentPropagation.getComponentModifications().isEmpty()) {
            ((AbstractISModificationRepository)version.getModificationMarkRepository()).getChangePropagationSteps().add((Object)intracomponentPropagation);
        }
        return providedRolesToBeAnalysedInNextStep;
    }

    private ISModifyComponent createComponentModificationForRequiredRole(RequiredRole requiredRole, Map<RepositoryComponent, ISModifyComponent> componentsMarkedInThisStep, ISIntracomponentPropagation intracomponentPropagation) {
        ISModifyComponent result = null;
        RepositoryComponent component = (RepositoryComponent)requiredRole.getRequiringEntity_RequiredRole();
        result = componentsMarkedInThisStep.get(component);
        if (result == null) {
            result = ISModificationmarksFactory.eINSTANCE.createISModifyComponent();
            result.setToolderived(true);
            result.setAffectedElement((Object)component);
            result.getCausingElements().add((Object)requiredRole);
            componentsMarkedInThisStep.put(component, result);
            intracomponentPropagation.getComponentModifications().add((Object)result);
        } else {
            result.getCausingElements().add((Object)requiredRole);
        }
        return result;
    }

    private ISModifyRequiredRole createRequiredRoleModification(RequiredRole requiredRole, Set<? extends Signature> causingSignatures) {
        ISModifyRequiredRole modifyRequiredRole = ISModificationmarksFactory.eINSTANCE.createISModifyRequiredRole();
        modifyRequiredRole.setToolderived(true);
        modifyRequiredRole.setAffectedElement((Object)requiredRole);
        modifyRequiredRole.getCausingElements().addAll(causingSignatures);
        for (Signature signature : causingSignatures) {
            ISModifySignature modifySignature = ISModificationmarksFactory.eINSTANCE.createISModifySignature();
            modifySignature.setToolderived(true);
            modifySignature.setAffectedElement((Object)signature);
            modifySignature.getCausingElements().add((Object)signature);
            modifyRequiredRole.getSignatureModifications().add((Object)modifySignature);
        }
        return modifyRequiredRole;
    }

    private ISModifyRequiredRole createRequiredRoleModification(RequiredRole requiredRole, Map<ProvidedRole, Set<Signature>> causingProvidedRoles) {
        HashMap<Signature, ISModifySignature> markedSignatures = new HashMap<Signature, ISModifySignature>();
        ISModifyRequiredRole modifyRequiredRole = ISModificationmarksFactory.eINSTANCE.createISModifyRequiredRole();
        modifyRequiredRole.setToolderived(true);
        modifyRequiredRole.setAffectedElement((Object)requiredRole);
        for (Map.Entry<ProvidedRole, Set<Signature>> providedRolesEntry : causingProvidedRoles.entrySet()) {
            modifyRequiredRole.getCausingElements().add((Object)((EObject)providedRolesEntry.getKey()));
            for (Signature signatureToBeMarked : providedRolesEntry.getValue()) {
                if (!markedSignatures.containsKey(signatureToBeMarked)) {
                    ISModifySignature modifySignature = ISModificationmarksFactory.eINSTANCE.createISModifySignature();
                    modifySignature.setToolderived(true);
                    modifySignature.setAffectedElement((Object)signatureToBeMarked);
                    modifyRequiredRole.getSignatureModifications().add((Object)modifySignature);
                    markedSignatures.put(signatureToBeMarked, modifySignature);
                }
                ((ISModifySignature)markedSignatures.get(signatureToBeMarked)).getCausingElements().add((Object)((EObject)providedRolesEntry.getKey()));
            }
        }
        return modifyRequiredRole;
    }

    protected void calculateRoleToRoleDependencies(Iterable<RoleToRoleDependency> dependencies, ISModifyComponent modifyComponent, Map<ProvidedRole, Set<Signature>> providedRolesToBeAnalysedInNextStep, Collection<Signature> markedSignatures) {
        for (RoleToRoleDependency r2rDependency : dependencies) {
            HashSet<Signature> signaturesToBeAnalysed;
            boolean newSignatureMarked;
            boolean newRoleMarked;
            ISModifyProvidedRole modifyProvidedRole;
            if (r2rDependency.getProvidedRole() instanceof OperationProvidedRole) {
                modifyProvidedRole = ISArchitectureModelLookup.lookUpMarkedProvidedRoleForDependency(modifyComponent, r2rDependency);
                newRoleMarked = false;
                if (modifyProvidedRole == null) {
                    modifyProvidedRole = ISModificationmarksFactory.eINSTANCE.createISModifyProvidedRole();
                    modifyProvidedRole.setToolderived(true);
                    modifyProvidedRole.setAffectedElement((Object)r2rDependency.getProvidedRole());
                    newRoleMarked = true;
                }
                modifyProvidedRole.getCausingElements().add((Object)r2rDependency.getRequiredRole());
                newSignatureMarked = this.calculateOperationToOperationDependencies(r2rDependency, markedSignatures, modifyProvidedRole);
                if (newRoleMarked && (newSignatureMarked || !this.getVisitedProvidedRoles().containsKey(r2rDependency.getProvidedRole()))) {
                    modifyComponent.getProvidedRoleModifications().add((Object)modifyProvidedRole);
                }
                if (newSignatureMarked) {
                    signaturesToBeAnalysed = new HashSet<Signature>();
                    for (ISModifySignature signatureModification : modifyProvidedRole.getSignatureModifications()) {
                        signaturesToBeAnalysed.add((Signature)signatureModification.getAffectedElement());
                    }
                    MapUtil.putOrAddToMap(providedRolesToBeAnalysedInNextStep, (Object)((OperationProvidedRole)r2rDependency.getProvidedRole()), signaturesToBeAnalysed);
                    continue;
                }
                if (this.getVisitedProvidedRoles().containsKey(r2rDependency.getProvidedRole())) continue;
                this.getVisitedProvidedRoles().put(r2rDependency.getProvidedRole(), new HashSet());
                continue;
            }
            if (!(r2rDependency.getProvidedRole() instanceof SinkRole)) continue;
            modifyProvidedRole = ISArchitectureModelLookup.lookUpMarkedProvidedRoleForDependency(modifyComponent, r2rDependency);
            newRoleMarked = false;
            if (modifyProvidedRole == null) {
                modifyProvidedRole = ISModificationmarksFactory.eINSTANCE.createISModifyProvidedRole();
                modifyProvidedRole.setToolderived(true);
                modifyProvidedRole.setAffectedElement((Object)r2rDependency.getProvidedRole());
                newRoleMarked = true;
            }
            modifyProvidedRole.getCausingElements().add((Object)r2rDependency.getRequiredRole());
            newSignatureMarked = this.calculateOperationToOperationDependencies(r2rDependency, markedSignatures, modifyProvidedRole);
            if (newRoleMarked && (newSignatureMarked || !this.getVisitedProvidedRoles().containsKey(r2rDependency.getProvidedRole()))) {
                modifyComponent.getProvidedRoleModifications().add((Object)modifyProvidedRole);
            }
            if (newSignatureMarked) {
                signaturesToBeAnalysed = new HashSet();
                for (ISModifySignature signatureModification : modifyProvidedRole.getSignatureModifications()) {
                    signaturesToBeAnalysed.add((Signature)signatureModification.getAffectedElement());
                }
                MapUtil.putOrAddToMap(providedRolesToBeAnalysedInNextStep, (Object)((SinkRole)r2rDependency.getProvidedRole()), signaturesToBeAnalysed);
                continue;
            }
            if (this.getVisitedProvidedRoles().containsKey(r2rDependency.getProvidedRole())) continue;
            this.getVisitedProvidedRoles().put(r2rDependency.getProvidedRole(), new HashSet());
        }
    }

    protected boolean calculateOperationToOperationDependencies(RoleToRoleDependency r2rDependency, Collection<Signature> markedSignatures, ISModifyProvidedRole modifyProvidedRole) {
        boolean newSignatureMarked = false;
        for (OperationToOperationDependency o2oDependency : r2rDependency.getOperationToOperationDependency()) {
            LinkedList markedRequiredSignatures = new LinkedList(o2oDependency.getRequiredSignatures());
            markedRequiredSignatures.retainAll(markedSignatures);
            if (markedRequiredSignatures.isEmpty()) continue;
            for (Signature providedSignatureToBeMarked : o2oDependency.getProvidedSignatures()) {
                ISModifySignature modifyProvidedSignature = ISArchitectureModelLookup.lookUpProvidedSignatureMarkForRoleModification(providedSignatureToBeMarked, modifyProvidedRole);
                if (modifyProvidedSignature == null) {
                    modifyProvidedSignature = ISModificationmarksFactory.eINSTANCE.createISModifySignature();
                    modifyProvidedSignature.setToolderived(true);
                    modifyProvidedSignature.setAffectedElement((Object)providedSignatureToBeMarked);
                    modifyProvidedRole.getSignatureModifications().add((Object)modifyProvidedSignature);
                    if (!this.getVisitedProvidedRoles().containsKey(modifyProvidedRole.getAffectedElement()) || !this.getVisitedProvidedRoles().get(modifyProvidedRole.getAffectedElement()).contains(providedSignatureToBeMarked)) {
                        MapUtil.putOrAddToMap(this.getVisitedProvidedRoles(), (Object)((ProvidedRole)modifyProvidedRole.getAffectedElement()), (Object)providedSignatureToBeMarked);
                        newSignatureMarked = true;
                    }
                }
                for (Signature requiredSignature : markedRequiredSignatures) {
                    if (modifyProvidedSignature.getCausingElements().contains((Object)requiredSignature)) continue;
                    modifyProvidedSignature.getCausingElements().add((Object)requiredSignature);
                }
            }
        }
        return newSignatureMarked;
    }

    public Map<RequiredRole, Map<ProvidedRole, Set<Signature>>> calculateInterComponentPropagation(Map<ProvidedRole, Set<Signature>> newProvidedRolesMarked, S version) {
        HashMap<RequiredRole, Map<ProvidedRole, Set<Signature>>> requiredRolesToBeAnalysedInNextStep = new HashMap<RequiredRole, Map<ProvidedRole, Set<Signature>>>();
        ISIntercomponentPropagation intercomponentPropagation = ISModificationmarksFactory.eINSTANCE.createISIntercomponentPropagation();
        for (Map.Entry<ProvidedRole, Set<Signature>> providedRoleEntry : newProvidedRolesMarked.entrySet()) {
            List<AssemblyConnector> assemblyConnectors = ISArchitectureModelLookup.lookUpAssemblyConnectorsAttachedToProvidedRole(version, providedRoleEntry.getKey());
            for (AssemblyConnector assemblyConnector : assemblyConnectors) {
                this.createAndAddAssemblyConnectorModification(version, assemblyConnector, intercomponentPropagation);
            }
            for (RequiredRole requiredRole : ISArchitectureModelLookup.lookUpRequiredRolesForAssemblyConnectors(assemblyConnectors)) {
                if (requiredRolesToBeAnalysedInNextStep.containsKey(requiredRole)) {
                    MapUtil.putOrAddToMap((Map)((Map)requiredRolesToBeAnalysedInNextStep.get(requiredRole)), (Object)providedRoleEntry.getKey(), providedRoleEntry.getValue());
                    continue;
                }
                HashMap<ProvidedRole, Set<Signature>> causingProvidedRole = new HashMap<ProvidedRole, Set<Signature>>();
                causingProvidedRole.put(providedRoleEntry.getKey(), providedRoleEntry.getValue());
                requiredRolesToBeAnalysedInNextStep.put(requiredRole, causingProvidedRole);
            }
        }
        if (!intercomponentPropagation.getConnectorModifications().isEmpty()) {
            ((AbstractISModificationRepository)version.getModificationMarkRepository()).getChangePropagationSteps().add((Object)intercomponentPropagation);
        }
        return requiredRolesToBeAnalysedInNextStep;
    }

    private void createAndAddAssemblyConnectorModification(S version, AssemblyConnector assemblyConnector, ISIntercomponentPropagation intercomponentPropagation) {
        ISModifyConnector modifyAssemblyConnector = ISModificationmarksFactory.eINSTANCE.createISModifyConnector();
        modifyAssemblyConnector.setAffectedElement((Object)assemblyConnector);
        modifyAssemblyConnector.setToolderived(true);
        modifyAssemblyConnector.getCausingElements().add((Object)assemblyConnector.getProvidedRole_AssemblyConnector());
        intercomponentPropagation.getConnectorModifications().add((Object)modifyAssemblyConnector);
    }

    protected T getChangePropagationDueToDataDependencies() {
        return this.changePropagationDueToDataDependencies;
    }

    protected void setChangePropagationDueToDataDependencies(T changePropagationDueToDataDependencies) {
        this.changePropagationDueToDataDependencies = changePropagationDueToDataDependencies;
    }

    protected Map<ProvidedRole, Set<Signature>> getVisitedProvidedRoles() {
        return this.visitedProvidedRoles;
    }

    protected void setVisitedProvidedRoles(Map<ProvidedRole, Set<Signature>> visitedProvidedRoles) {
        this.visitedProvidedRoles = visitedProvidedRoles;
    }
}

