/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.kamp4bp.core.derivation;

import de.uhd.ifi.se.pcm.bppcm.bpusagemodel.AcquireDeviceResourceAction;
import de.uhd.ifi.se.pcm.bppcm.bpusagemodel.ReleaseDeviceResourceAction;
import de.uhd.ifi.se.pcm.bppcm.organizationenvironmentmodel.DeviceResource;
import edu.kit.ipd.sdq.kamp.model.modificationmarks.AbstractModification;
import edu.kit.ipd.sdq.kamp.model.modificationmarks.ChangePropagationStep;
import edu.kit.ipd.sdq.kamp.workplan.AbstractActivityElementType;
import edu.kit.ipd.sdq.kamp.workplan.AbstractActivityType;
import edu.kit.ipd.sdq.kamp.workplan.Activity;
import edu.kit.ipd.sdq.kamp.workplan.BasicActivity;
import edu.kit.ipd.sdq.kamp4bp.core.BPActivityElementType;
import edu.kit.ipd.sdq.kamp4bp.core.BPActivityType;
import edu.kit.ipd.sdq.kamp4bp.core.BPArchitectureVersion;
import edu.kit.ipd.sdq.kamp4bp.model.modificationmarks.BPChangePropagationDueToDataDependencies;
import edu.kit.ipd.sdq.kamp4bp.model.modificationmarks.BPInterBusinessProcessPropagation;
import edu.kit.ipd.sdq.kamp4bp.model.modificationmarks.BPModificationmarksFactory;
import edu.kit.ipd.sdq.kamp4bp.model.modificationmarks.BPModifyAbstractUserAction;
import edu.kit.ipd.sdq.kamp4bp.model.modificationmarks.BPModifyAcquireDeviceResourceAction;
import edu.kit.ipd.sdq.kamp4bp.model.modificationmarks.BPModifyDataObject;
import edu.kit.ipd.sdq.kamp4bp.model.modificationmarks.BPModifyReleaseDeviceResourceAction;
import edu.kit.ipd.sdq.kamp4is.core.ISActivityElementType;
import edu.kit.ipd.sdq.kamp4is.core.derivation.ISInternalModificationDerivation;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.AbstractISModificationRepository;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.ISModifyDataType;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

public class BPInternalModificationDerivation {
    private BPChangePropagationDueToDataDependencies bpChangePropagationDueToDataDependencies = BPModificationmarksFactory.eINSTANCE.createBPChangePropagationDueToDataDependencies();
    private BPInterBusinessProcessPropagation interBusinessPropagation = BPModificationmarksFactory.eINSTANCE.createBPInterBusinessProcessPropagation();

    public List<Activity> deriveInternalModifications(BPArchitectureVersion targetVersion) {
        ArrayList<Activity> activityList = new ArrayList<Activity>();
        if (targetVersion.getModificationMarkRepository() != null) {
            this.findRelevantPropagationSteps((AbstractISModificationRepository)targetVersion.getModificationMarkRepository());
            this.deriveDataTypeModifications(activityList);
            this.deriveDataObjectModifications(activityList);
            this.deriveUserActionModifications(activityList);
        }
        return activityList;
    }

    private void findRelevantPropagationSteps(AbstractISModificationRepository<?> modificationRepository) {
        for (ChangePropagationStep step : modificationRepository.getChangePropagationSteps()) {
            if (step instanceof BPChangePropagationDueToDataDependencies) {
                this.setChangePropagationDueToDataDependencies((BPChangePropagationDueToDataDependencies)step);
                continue;
            }
            if (!(step instanceof BPInterBusinessProcessPropagation)) continue;
            this.setInterBusinessPropagation((BPInterBusinessProcessPropagation)step);
        }
    }

    private void deriveDataTypeModifications(List<Activity> activityList) {
        ArrayList datatypeModifications = new ArrayList(this.getChangePropagationDueToDataDependencies().getDatatypeModifications());
        for (ISModifyDataType modifyDatatype : datatypeModifications) {
            activityList.add(ISInternalModificationDerivation.createModificationActivity((AbstractModification)modifyDatatype, (AbstractActivityElementType)ISActivityElementType.DATATYPE));
        }
    }

    private void deriveDataObjectModifications(List<Activity> activityList) {
        ArrayList dataObjectModifications = new ArrayList(this.getChangePropagationDueToDataDependencies().getDataObjectModifications());
        for (BPModifyDataObject modifyDataObject : dataObjectModifications) {
            activityList.add(ISInternalModificationDerivation.createModificationActivity((AbstractModification)modifyDataObject, (AbstractActivityElementType)BPActivityElementType.getArchitectureActivityTypeForObject((EObject)modifyDataObject.getAffectedElement())));
        }
    }

    private void deriveUserActionModifications(List<Activity> activityList) {
        ArrayList userActionModifications = new ArrayList(this.getInterBusinessPropagation().getAbstractUserActionModifications());
        userActionModifications.addAll(this.getChangePropagationDueToDataDependencies().getActorStepModifications());
        userActionModifications.addAll(this.getChangePropagationDueToDataDependencies().getEntryLevelSystemCallModifications());
        for (BPModifyAbstractUserAction modifyAbstractUserAction : userActionModifications) {
            DeviceResource deviceResource;
            if (modifyAbstractUserAction instanceof BPModifyAcquireDeviceResourceAction && modifyAbstractUserAction.getAffectedElement() == null) {
                deviceResource = ((AcquireDeviceResourceAction)((BPModifyAcquireDeviceResourceAction)modifyAbstractUserAction).getAffectedElement()).getPassiveresource_AcquireAction();
                activityList.add(new Activity((AbstractActivityType)BPActivityType.WARNING, (AbstractActivityElementType)BPActivityElementType.ACQUIREDEVICERESOURCEACTION, (EObject)deviceResource, deviceResource.getEntityName(), null, BasicActivity.MODIFY, "Warning: No matching acquire action found."));
                continue;
            }
            if (modifyAbstractUserAction instanceof BPModifyReleaseDeviceResourceAction && modifyAbstractUserAction.getAffectedElement() == null) {
                deviceResource = ((ReleaseDeviceResourceAction)((BPModifyReleaseDeviceResourceAction)modifyAbstractUserAction).getAffectedElement()).getPassiveresource_ReleaseAction();
                activityList.add(new Activity((AbstractActivityType)BPActivityType.WARNING, (AbstractActivityElementType)BPActivityElementType.RELEASEDEVICERESOURCEACTION, (EObject)deviceResource, deviceResource.getEntityName(), null, BasicActivity.MODIFY, "Warning: No matching release action found."));
                continue;
            }
            activityList.add(ISInternalModificationDerivation.createModificationActivity((AbstractModification)modifyAbstractUserAction, (AbstractActivityElementType)BPActivityElementType.getArchitectureActivityTypeForObject((EObject)modifyAbstractUserAction.getAffectedElement())));
        }
    }

    protected BPChangePropagationDueToDataDependencies getChangePropagationDueToDataDependencies() {
        return this.bpChangePropagationDueToDataDependencies;
    }

    protected void setChangePropagationDueToDataDependencies(BPChangePropagationDueToDataDependencies bpChangePropagationDueToDataDependencies) {
        this.bpChangePropagationDueToDataDependencies = bpChangePropagationDueToDataDependencies;
    }

    protected BPInterBusinessProcessPropagation getInterBusinessPropagation() {
        return this.interBusinessPropagation;
    }

    protected void setInterBusinessPropagation(BPInterBusinessProcessPropagation interBusinessPropagation) {
        this.interBusinessPropagation = interBusinessPropagation;
    }
}

