/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.kamp4bp.core;

import de.uhd.ifi.se.pcm.bppcm.bpusagemodel.AcquireDeviceResourceAction;
import de.uhd.ifi.se.pcm.bppcm.bpusagemodel.ActorStep;
import de.uhd.ifi.se.pcm.bppcm.bpusagemodel.ReleaseDeviceResourceAction;
import de.uhd.ifi.se.pcm.bppcm.datamodel.DataObject;
import de.uhd.ifi.se.pcm.bppcm.organizationenvironmentmodel.DeviceResource;
import de.uhd.ifi.se.pcm.bppcm.organizationenvironmentmodel.Role;
import edu.kit.ipd.sdq.kamp.architecture.AbstractArchitectureVersion;
import edu.kit.ipd.sdq.kamp.architecture.ArchitectureModelLookup;
import edu.kit.ipd.sdq.kamp.model.modificationmarks.AbstractModification;
import edu.kit.ipd.sdq.kamp.util.MapUtil;
import edu.kit.ipd.sdq.kamp4bp.core.BPArchitectureModelLookup;
import edu.kit.ipd.sdq.kamp4bp.core.BPArchitectureVersion;
import edu.kit.ipd.sdq.kamp4bp.model.modificationmarks.BPChangePropagationDueToDataDependencies;
import edu.kit.ipd.sdq.kamp4bp.model.modificationmarks.BPInterBusinessProcessPropagation;
import edu.kit.ipd.sdq.kamp4bp.model.modificationmarks.BPModificationmarksFactory;
import edu.kit.ipd.sdq.kamp4bp.model.modificationmarks.BPModifyAbstractUserAction;
import edu.kit.ipd.sdq.kamp4bp.model.modificationmarks.BPModifyAcquireDeviceResourceAction;
import edu.kit.ipd.sdq.kamp4bp.model.modificationmarks.BPModifyActorStep;
import edu.kit.ipd.sdq.kamp4bp.model.modificationmarks.BPModifyDataObject;
import edu.kit.ipd.sdq.kamp4bp.model.modificationmarks.BPModifyEntryLevelSystemCall;
import edu.kit.ipd.sdq.kamp4bp.model.modificationmarks.BPModifyReleaseDeviceResourceAction;
import edu.kit.ipd.sdq.kamp4is.core.AbstractISChangePropagationAnalysis;
import edu.kit.ipd.sdq.kamp4is.core.ISArchitectureModelLookup;
import edu.kit.ipd.sdq.kamp4is.core.ISArchitectureVersion;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.AbstractISModificationRepository;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.ISChangePropagationDueToDataDependencies;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.ISModificationmarksFactory;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.ISModifyDataType;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.ISModifyInterface;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.ISModifySignature;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.repository.DataType;
import org.palladiosimulator.pcm.repository.Interface;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.usagemodel.AbstractUserAction;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;

public class BPChangePropagationAnalysis
extends AbstractISChangePropagationAnalysis<BPArchitectureVersion, BPChangePropagationDueToDataDependencies> {
    private BPInterBusinessProcessPropagation interBusinessProcessPropagation;
    private Collection<DataType> markedDataTypes;
    private Collection<DataObject<?>> markedDataObjects;

    public void runChangePropagationAnalysis(BPArchitectureVersion version) {
        this.prepareAnalysis(version);
        this.calculateChangePropagationDueToDataDependencies(version);
        this.calculateInterfaceAndComponentPropagation(version);
        this.calculateInterBusinessProcessPropagation(version);
    }

    private void prepareAnalysis(BPArchitectureVersion version) {
        this.setChangePropagationDueToDataDependencies((ISChangePropagationDueToDataDependencies)BPModificationmarksFactory.eINSTANCE.createBPChangePropagationDueToDataDependencies());
        ((AbstractISModificationRepository)version.getModificationMarkRepository()).getChangePropagationSteps().add((Object)this.getChangePropagationDueToDataDependencies());
        this.setInterBusinessProcessPropagation(BPModificationmarksFactory.eINSTANCE.createBPInterBusinessProcessPropagation());
        ((AbstractISModificationRepository)version.getModificationMarkRepository()).getChangePropagationSteps().add((Object)this.getInterBusinessProcessPropagation());
        this.setMarkedDataObjects(ArchitectureModelLookup.lookUpMarkedObjectsOfAType((AbstractArchitectureVersion)version, DataObject.class));
        this.setMarkedDataTypes(ArchitectureModelLookup.lookUpMarkedObjectsOfAType((AbstractArchitectureVersion)version, DataType.class));
    }

    public void calculateChangePropagationDueToDataDependencies(BPArchitectureVersion version) {
        HashMap elementsMarkedInThisStep = new HashMap();
        this.calculateAndMarkDataTypeToDataTypePropagation(version, elementsMarkedInThisStep);
        this.calculateAndMarkDataTypeToDataObjectPropagation(version, elementsMarkedInThisStep);
        this.calculateAndMarkDataObjectToDataObjectPropagation(version, elementsMarkedInThisStep);
        this.calculateAndMarkDataObjectToActorStepPropagation(version);
        this.calculateAndMarkDataObjectToDataTypePropagation(version, elementsMarkedInThisStep);
        this.calculateAndMarkDataTypeToDataTypePropagation(version, elementsMarkedInThisStep);
        this.calculateAndMarkDataTypeToEntryLevelSystemCallPropagation(version);
        this.calculateAndMarkToInterfacePropagation(version);
        if (((BPChangePropagationDueToDataDependencies)this.getChangePropagationDueToDataDependencies()).eContents().isEmpty()) {
            ((AbstractISModificationRepository)version.getModificationMarkRepository()).getChangePropagationSteps().remove((Object)this.getChangePropagationDueToDataDependencies());
        }
    }

    public void calculateInterBusinessProcessPropagation(BPArchitectureVersion version) {
        HashMap elementsMarkedInThisStep = new HashMap();
        this.calculateAndMarkRoleToActorStepPropagation(version, elementsMarkedInThisStep);
        this.calculateAndMarkActorStepToActorStepAndELSCPropagation(version, elementsMarkedInThisStep);
        this.calculateAndMarkDeviceResourceToDeviceResourceActionPropagation(version, elementsMarkedInThisStep);
        this.calculateAndMarkSignatureToEntryLevelSystemCallPropagation(version, elementsMarkedInThisStep);
        if (this.getInterBusinessProcessPropagation().eContents().isEmpty()) {
            ((AbstractISModificationRepository)version.getModificationMarkRepository()).getChangePropagationSteps().remove((Object)this.getInterBusinessProcessPropagation());
        }
    }

    protected void calculateAndMarkDataTypeToDataTypePropagation(BPArchitectureVersion version, Map<EObject, AbstractModification<?, EObject>> elementsMarkedInThisStep) {
        Map<DataType, Set<DataType>> dataTypesToBeMarked = BPArchitectureModelLookup.lookUpCompositeAndCollectionDataTypesOfDataTypes(version, this.getMarkedDataTypes());
        for (Map.Entry<DataType, Set<DataType>> dataTypeToBeMarkedEntry : dataTypesToBeMarked.entrySet()) {
            if (elementsMarkedInThisStep.containsKey(dataTypeToBeMarkedEntry.getKey())) {
                for (DataType cause : dataTypeToBeMarkedEntry.getValue()) {
                    if (elementsMarkedInThisStep.get(dataTypeToBeMarkedEntry.getKey()).getCausingElements().contains((Object)cause)) continue;
                    elementsMarkedInThisStep.get(dataTypeToBeMarkedEntry.getKey()).getCausingElements().add((Object)cause);
                }
                continue;
            }
            ISModifyDataType modifyDataType = ISModificationmarksFactory.eINSTANCE.createISModifyDataType();
            modifyDataType.setToolderived(true);
            modifyDataType.setAffectedElement((Object)dataTypeToBeMarkedEntry.getKey());
            modifyDataType.getCausingElements().addAll((Collection)dataTypeToBeMarkedEntry.getValue());
            elementsMarkedInThisStep.put((EObject)dataTypeToBeMarkedEntry.getKey(), (AbstractModification<?, EObject>)modifyDataType);
            this.getMarkedDataTypes().add(dataTypeToBeMarkedEntry.getKey());
            ((BPChangePropagationDueToDataDependencies)this.getChangePropagationDueToDataDependencies()).getDatatypeModifications().add((Object)modifyDataType);
        }
    }

    protected void calculateAndMarkDataTypeToEntryLevelSystemCallPropagation(BPArchitectureVersion version) {
        Map<EntryLevelSystemCall, Set<DataType>> elscsToBeMarked = BPArchitectureModelLookup.lookUpEntryLevelSystemCallsWithParameterOfTypes(version, this.getMarkedDataTypes());
        for (Map.Entry<EntryLevelSystemCall, Set<DataType>> elscToBeMarkedEntry : elscsToBeMarked.entrySet()) {
            BPModifyEntryLevelSystemCall modifyELSC = BPModificationmarksFactory.eINSTANCE.createBPModifyEntryLevelSystemCall();
            modifyELSC.setToolderived(true);
            modifyELSC.setAffectedElement((Object)elscToBeMarkedEntry.getKey());
            modifyELSC.getCausingElements().addAll((Collection)elscToBeMarkedEntry.getValue());
            ((BPChangePropagationDueToDataDependencies)this.getChangePropagationDueToDataDependencies()).getEntryLevelSystemCallModifications().add((Object)modifyELSC);
        }
    }

    protected void calculateAndMarkDataTypeToDataObjectPropagation(BPArchitectureVersion version, Map<EObject, AbstractModification<?, EObject>> elementsMarkedInThisStep) {
        Map<DataObject<?>, Set<DataType>> dataObjectsToBeMarked = BPArchitectureModelLookup.lookUpDataObjectsWithDataTypes(version, this.getMarkedDataTypes());
        for (Map.Entry<DataObject<?>, Set<DataType>> dataObjectToBeMarkedEntry : dataObjectsToBeMarked.entrySet()) {
            if (elementsMarkedInThisStep.containsKey(dataObjectToBeMarkedEntry.getKey())) {
                elementsMarkedInThisStep.get(dataObjectToBeMarkedEntry.getKey()).getCausingElements().addAll((Collection)dataObjectToBeMarkedEntry.getValue());
                continue;
            }
            BPModifyDataObject modifyDataObject = BPModificationmarksFactory.eINSTANCE.createBPModifyDataObject();
            modifyDataObject.setToolderived(true);
            modifyDataObject.setAffectedElement(dataObjectToBeMarkedEntry.getKey());
            modifyDataObject.getCausingElements().addAll((Collection)dataObjectToBeMarkedEntry.getValue());
            elementsMarkedInThisStep.put((EObject)dataObjectToBeMarkedEntry.getKey(), (AbstractModification<?, EObject>)modifyDataObject);
            this.getMarkedDataObjects().add(dataObjectToBeMarkedEntry.getKey());
            ((BPChangePropagationDueToDataDependencies)this.getChangePropagationDueToDataDependencies()).getDataObjectModifications().add((Object)modifyDataObject);
        }
    }

    protected void calculateAndMarkDataObjectToDataObjectPropagation(BPArchitectureVersion version, Map<EObject, AbstractModification<?, EObject>> elementsMarkedInThisStep) {
        Map<DataObject<?>, Set<DataObject<?>>> dataObjectsToBeMarked = BPArchitectureModelLookup.lookUpCompositeAndCollectionDataObjectsWithDataObjects(version, this.getMarkedDataObjects());
        for (Map.Entry<DataObject<?>, Set<DataObject<?>>> dataObjectToBeMarkedEntry : dataObjectsToBeMarked.entrySet()) {
            if (elementsMarkedInThisStep.containsKey(dataObjectToBeMarkedEntry.getKey())) {
                for (DataObject<?> cause : dataObjectToBeMarkedEntry.getValue()) {
                    if (elementsMarkedInThisStep.get(dataObjectToBeMarkedEntry.getKey()).getCausingElements().contains(cause)) continue;
                    elementsMarkedInThisStep.get(dataObjectToBeMarkedEntry.getKey()).getCausingElements().add(cause);
                }
                continue;
            }
            BPModifyDataObject modifyDataObject = BPModificationmarksFactory.eINSTANCE.createBPModifyDataObject();
            modifyDataObject.setToolderived(true);
            modifyDataObject.setAffectedElement(dataObjectToBeMarkedEntry.getKey());
            modifyDataObject.getCausingElements().addAll((Collection)dataObjectToBeMarkedEntry.getValue());
            elementsMarkedInThisStep.put((EObject)dataObjectToBeMarkedEntry.getKey(), (AbstractModification<?, EObject>)modifyDataObject);
            this.getMarkedDataObjects().add(dataObjectToBeMarkedEntry.getKey());
            ((BPChangePropagationDueToDataDependencies)this.getChangePropagationDueToDataDependencies()).getDataObjectModifications().add((Object)modifyDataObject);
        }
    }

    protected void calculateAndMarkDataObjectToActorStepPropagation(BPArchitectureVersion version) {
        Map<ActorStep, Set<DataObject<?>>> actorStepsToBeMarked = BPArchitectureModelLookup.lookUpActorStepsWithDataObjects(version, this.getMarkedDataObjects());
        for (Map.Entry<ActorStep, Set<DataObject<?>>> actorStepToBeMarkedEntry : actorStepsToBeMarked.entrySet()) {
            ((BPChangePropagationDueToDataDependencies)this.getChangePropagationDueToDataDependencies()).getActorStepModifications().add((Object)this.createActorStepModification(actorStepToBeMarkedEntry.getKey(), (Collection<? extends Entity>)actorStepToBeMarkedEntry.getValue()));
        }
    }

    protected void calculateAndMarkDataObjectToDataTypePropagation(BPArchitectureVersion version, Map<EObject, AbstractModification<?, EObject>> elementsMarkedInThisStep) {
        Map<DataType, Set<DataObject<?>>> dataTypesToBeMarked = BPArchitectureModelLookup.lookUpDataTypesWithDataObjects(version, this.getMarkedDataObjects());
        BPChangePropagationAnalysis.filterCircularCauses(dataTypesToBeMarked, elementsMarkedInThisStep);
        for (Map.Entry<DataType, Set<DataObject<?>>> dataTypeToBeMarkedEntry : dataTypesToBeMarked.entrySet()) {
            if (elementsMarkedInThisStep.containsKey(dataTypeToBeMarkedEntry.getKey())) {
                elementsMarkedInThisStep.get(dataTypeToBeMarkedEntry.getKey()).getCausingElements().addAll((Collection)dataTypeToBeMarkedEntry.getValue());
                continue;
            }
            ISModifyDataType modifyDataType = ISModificationmarksFactory.eINSTANCE.createISModifyDataType();
            modifyDataType.setToolderived(true);
            modifyDataType.setAffectedElement((Object)dataTypeToBeMarkedEntry.getKey());
            modifyDataType.getCausingElements().addAll((Collection)dataTypeToBeMarkedEntry.getValue());
            elementsMarkedInThisStep.put((EObject)dataTypeToBeMarkedEntry.getKey(), (AbstractModification<?, EObject>)modifyDataType);
            this.getMarkedDataTypes().add(dataTypeToBeMarkedEntry.getKey());
            ((BPChangePropagationDueToDataDependencies)this.getChangePropagationDueToDataDependencies()).getDatatypeModifications().add((Object)modifyDataType);
        }
    }

    private static void filterCircularCauses(Map<DataType, Set<DataObject<?>>> objectsToBeMarked, Map<EObject, AbstractModification<?, EObject>> elementsMarkedInThisStep) {
        HashMap circularMarks = new HashMap();
        for (Map.Entry<DataType, Set<DataObject<?>>> objectsToBeMarkedEntry : objectsToBeMarked.entrySet()) {
            for (DataObject<?> causingObject : objectsToBeMarkedEntry.getValue()) {
                if (!elementsMarkedInThisStep.containsKey(causingObject) || !elementsMarkedInThisStep.get(causingObject).getCausingElements().contains((Object)objectsToBeMarkedEntry.getKey())) continue;
                MapUtil.putOrAddToMap(circularMarks, (Object)objectsToBeMarkedEntry.getKey(), causingObject);
            }
        }
        MapUtil.removeAllFromMap(objectsToBeMarked, circularMarks);
    }

    protected void calculateAndMarkToInterfacePropagation(BPArchitectureVersion version) {
        Set initialMarkedSignatures = ArchitectureModelLookup.lookUpMarkedObjectsOfAType((AbstractArchitectureVersion)version, Signature.class);
        Set initialMarkedELSCs = ArchitectureModelLookup.lookUpMarkedObjectsOfAType((AbstractArchitectureVersion)version, EntryLevelSystemCall.class);
        HashMap<Signature, Set<DataType>> dtSignaturesToBeMarked = new HashMap<Signature, Set<DataType>>();
        HashMap<Signature, EntryLevelSystemCall> elSignaturesToBeMarked = new HashMap<Signature, EntryLevelSystemCall>();
        Map interfacesToBeMarked = ISArchitectureModelLookup.lookUpInterfacesAndSignaturesWithSignatures((ISArchitectureVersion)version, (Collection)initialMarkedSignatures);
        ISArchitectureModelLookup.lookUpInterfacesAndSignaturesWithParametersOfTypes((ISArchitectureVersion)version, this.getMarkedDataTypes(), (Map)interfacesToBeMarked, dtSignaturesToBeMarked);
        BPArchitectureModelLookup.lookUpInterfacesAndSignaturesWithEntryLevelSystemCalls(version, initialMarkedELSCs, interfacesToBeMarked, elSignaturesToBeMarked);
        this.createAndAddInterfaceModifications(interfacesToBeMarked, dtSignaturesToBeMarked, elSignaturesToBeMarked, (Collection<ISModifyInterface>)((BPChangePropagationDueToDataDependencies)this.getChangePropagationDueToDataDependencies()).getInterfaceModifications());
    }

    private void createAndAddInterfaceModifications(Map<Interface, Set<Signature>> interfacesToBeMarked, Map<Signature, Set<DataType>> dtSignaturesToBeMarked, Map<Signature, EntryLevelSystemCall> elSignaturesToBeMarked, Collection<ISModifyInterface> targetCollection) {
        for (Map.Entry<Interface, Set<Signature>> interfaceToBeMarkedEntry : interfacesToBeMarked.entrySet()) {
            ISModifyInterface modifyInterface = ISModificationmarksFactory.eINSTANCE.createISModifyInterface();
            modifyInterface.setToolderived(true);
            modifyInterface.setAffectedElement((Object)interfaceToBeMarkedEntry.getKey());
            modifyInterface.getCausingElements().addAll((Collection)interfaceToBeMarkedEntry.getValue());
            for (Signature signature : interfaceToBeMarkedEntry.getValue()) {
                if (!dtSignaturesToBeMarked.containsKey(signature) && !elSignaturesToBeMarked.containsKey(signature)) continue;
                ISModifySignature modifySignature = ISModificationmarksFactory.eINSTANCE.createISModifySignature();
                modifySignature.setToolderived(true);
                modifySignature.setAffectedElement((Object)signature);
                if (dtSignaturesToBeMarked.containsKey(signature)) {
                    modifySignature.getCausingElements().addAll((Collection)dtSignaturesToBeMarked.get(signature));
                }
                if (elSignaturesToBeMarked.containsKey(signature)) {
                    modifySignature.getCausingElements().add((Object)((EObject)elSignaturesToBeMarked.get(signature)));
                }
                modifyInterface.getSignatureModifications().add((Object)modifySignature);
            }
            targetCollection.add(modifyInterface);
        }
    }

    protected void calculateAndMarkRoleToActorStepPropagation(BPArchitectureVersion version, Map<EObject, AbstractModification<?, EObject>> elementsMarkedInThisStep) {
        Set markedRoles = ArchitectureModelLookup.lookUpMarkedObjectsOfAType((AbstractArchitectureVersion)version, Role.class);
        List<ActorStep> actorStepsToBeMarked = BPArchitectureModelLookup.lookUpActorStepsWithRoles(version, markedRoles);
        for (ActorStep actorStepToBeMarked : actorStepsToBeMarked) {
            if (elementsMarkedInThisStep.containsKey(actorStepToBeMarked)) {
                elementsMarkedInThisStep.get(actorStepToBeMarked).getCausingElements().add((Object)actorStepToBeMarked.getResponsibleRole());
                continue;
            }
            BPModifyActorStep modifyActorStep = this.createActorStepModification(actorStepToBeMarked, Collections.singleton(actorStepToBeMarked.getResponsibleRole()));
            this.getInterBusinessProcessPropagation().getAbstractUserActionModifications().add((Object)modifyActorStep);
        }
    }

    private BPModifyActorStep createActorStepModification(ActorStep actorStep, Collection<? extends Entity> causes) {
        BPModifyActorStep modifyActorStep = BPModificationmarksFactory.eINSTANCE.createBPModifyActorStep();
        modifyActorStep.setToolderived(true);
        modifyActorStep.setAffectedElement((Object)actorStep);
        modifyActorStep.getCausingElements().addAll(causes);
        return modifyActorStep;
    }

    protected void calculateAndMarkActorStepToActorStepAndELSCPropagation(BPArchitectureVersion version, Map<EObject, AbstractModification<?, EObject>> elementsMarkedInThisStep) {
        Set markedActorSteps = ArchitectureModelLookup.lookUpMarkedObjectsOfAType((AbstractArchitectureVersion)version, ActorStep.class);
        Map<AbstractUserAction, List<ActorStep>> userActionsToBeMarked = BPArchitectureModelLookup.lookUpUserActionsAfterMarkedActorSteps(markedActorSteps, version);
        for (Map.Entry<AbstractUserAction, List<ActorStep>> userActionToBeMarkedEntry : userActionsToBeMarked.entrySet()) {
            if (elementsMarkedInThisStep.containsKey(userActionToBeMarkedEntry.getKey())) {
                elementsMarkedInThisStep.get(userActionToBeMarkedEntry.getKey()).getCausingElements().addAll((Collection)userActionToBeMarkedEntry.getValue());
                continue;
            }
            if (userActionToBeMarkedEntry.getKey() instanceof ActorStep) {
                BPModifyActorStep modifyActorStep = this.createActorStepModification((ActorStep)userActionToBeMarkedEntry.getKey(), (Collection<? extends Entity>)userActionToBeMarkedEntry.getValue());
                elementsMarkedInThisStep.put((EObject)userActionToBeMarkedEntry.getKey(), (AbstractModification<?, EObject>)modifyActorStep);
                this.getInterBusinessProcessPropagation().getAbstractUserActionModifications().add((Object)modifyActorStep);
                continue;
            }
            if (!(userActionToBeMarkedEntry.getKey() instanceof EntryLevelSystemCall)) continue;
            EntryLevelSystemCall userActionToBeMarked = (EntryLevelSystemCall)userActionToBeMarkedEntry.getKey();
            BPModifyEntryLevelSystemCall modifyEntryLevelSystemCall = BPModificationmarksFactory.eINSTANCE.createBPModifyEntryLevelSystemCall();
            modifyEntryLevelSystemCall.setToolderived(true);
            modifyEntryLevelSystemCall.setAffectedElement((Object)userActionToBeMarked);
            modifyEntryLevelSystemCall.getCausingElements().addAll((Collection)userActionToBeMarkedEntry.getValue());
            elementsMarkedInThisStep.put((EObject)userActionToBeMarked, (AbstractModification<?, EObject>)modifyEntryLevelSystemCall);
            this.getInterBusinessProcessPropagation().getAbstractUserActionModifications().add((Object)modifyEntryLevelSystemCall);
        }
    }

    protected void calculateAndMarkDeviceResourceToDeviceResourceActionPropagation(BPArchitectureVersion version, Map<EObject, AbstractModification<?, EObject>> elementsMarkedInThisStep) {
        Set markedDeviceResources = ArchitectureModelLookup.lookUpMarkedObjectsOfAType((AbstractArchitectureVersion)version, DeviceResource.class);
        List<AcquireDeviceResourceAction> acquireDeviceResourceActionsToBeMarked = BPArchitectureModelLookup.lookUpAcquireDeviceResourceActionsWithDeviceResources(version, markedDeviceResources);
        List<ReleaseDeviceResourceAction> releaseDeviceResourceActionsToBeMarked = BPArchitectureModelLookup.lookUpReleaseDeviceResourceActionsWithDeviceResources(version, markedDeviceResources);
        Map<AcquireDeviceResourceAction, BPModifyAcquireDeviceResourceAction> acquireActionModifications = this.calculateAndMarkDeviceResourceToAcquireDeviceResourceActionPropagation(acquireDeviceResourceActionsToBeMarked, elementsMarkedInThisStep);
        Map<ReleaseDeviceResourceAction, BPModifyReleaseDeviceResourceAction> releaseActionModifications = this.calculateAndMarkDeviceResourceToReleaseDeviceResourceActionPropagation(releaseDeviceResourceActionsToBeMarked, elementsMarkedInThisStep);
        this.calculateAndMarkPropagationFromAcquireDeviceResourceActions(acquireActionModifications, releaseActionModifications, elementsMarkedInThisStep);
        this.calculateAndMarkPropagationFromReleaseDeviceResourceActions(releaseActionModifications);
    }

    protected Map<AcquireDeviceResourceAction, BPModifyAcquireDeviceResourceAction> calculateAndMarkDeviceResourceToAcquireDeviceResourceActionPropagation(Collection<AcquireDeviceResourceAction> deviceResourceActionsToBeMarked, Map<EObject, AbstractModification<?, EObject>> elementsMarkedInThisStep) {
        HashMap<AcquireDeviceResourceAction, BPModifyAcquireDeviceResourceAction> results = new HashMap<AcquireDeviceResourceAction, BPModifyAcquireDeviceResourceAction>();
        for (AcquireDeviceResourceAction deviceResourceActionToBeMarked : deviceResourceActionsToBeMarked) {
            if (elementsMarkedInThisStep.containsKey(deviceResourceActionToBeMarked)) {
                elementsMarkedInThisStep.get(deviceResourceActionToBeMarked).getCausingElements().add((Object)deviceResourceActionToBeMarked.getPassiveresource_AcquireAction());
                continue;
            }
            BPModifyAcquireDeviceResourceAction modifyDeviceResourceAction = BPModificationmarksFactory.eINSTANCE.createBPModifyAcquireDeviceResourceAction();
            modifyDeviceResourceAction.setToolderived(true);
            modifyDeviceResourceAction.setAffectedElement((Object)deviceResourceActionToBeMarked);
            modifyDeviceResourceAction.getCausingElements().add((Object)deviceResourceActionToBeMarked.getPassiveresource_AcquireAction());
            elementsMarkedInThisStep.put((EObject)deviceResourceActionToBeMarked, (AbstractModification<?, EObject>)modifyDeviceResourceAction);
            results.put(deviceResourceActionToBeMarked, modifyDeviceResourceAction);
        }
        return results;
    }

    protected Map<ReleaseDeviceResourceAction, BPModifyReleaseDeviceResourceAction> calculateAndMarkDeviceResourceToReleaseDeviceResourceActionPropagation(Collection<ReleaseDeviceResourceAction> deviceResourceActionsToBeMarked, Map<EObject, AbstractModification<?, EObject>> elementsMarkedInThisStep) {
        HashMap<ReleaseDeviceResourceAction, BPModifyReleaseDeviceResourceAction> results = new HashMap<ReleaseDeviceResourceAction, BPModifyReleaseDeviceResourceAction>();
        for (ReleaseDeviceResourceAction deviceResourceActionToBeMarked : deviceResourceActionsToBeMarked) {
            if (elementsMarkedInThisStep.containsKey(deviceResourceActionToBeMarked)) {
                elementsMarkedInThisStep.get(deviceResourceActionToBeMarked).getCausingElements().add((Object)deviceResourceActionToBeMarked.getPassiveresource_ReleaseAction());
                continue;
            }
            BPModifyReleaseDeviceResourceAction modifyDeviceResourceAction = BPModificationmarksFactory.eINSTANCE.createBPModifyReleaseDeviceResourceAction();
            modifyDeviceResourceAction.setToolderived(true);
            modifyDeviceResourceAction.setAffectedElement((Object)deviceResourceActionToBeMarked);
            modifyDeviceResourceAction.getCausingElements().add((Object)deviceResourceActionToBeMarked.getPassiveresource_ReleaseAction());
            elementsMarkedInThisStep.put((EObject)deviceResourceActionToBeMarked, (AbstractModification<?, EObject>)modifyDeviceResourceAction);
            results.put(deviceResourceActionToBeMarked, modifyDeviceResourceAction);
        }
        return results;
    }

    protected void calculateAndMarkPropagationFromAcquireDeviceResourceActions(Map<AcquireDeviceResourceAction, BPModifyAcquireDeviceResourceAction> acquireActionModifications, Map<ReleaseDeviceResourceAction, BPModifyReleaseDeviceResourceAction> releaseActionModifications, Map<EObject, AbstractModification<?, EObject>> elementsMarkedInThisStep) {
        while (!acquireActionModifications.isEmpty()) {
            BPModifyAcquireDeviceResourceAction modifyAcquireAction = acquireActionModifications.values().iterator().next();
            this.getInterBusinessProcessPropagation().getAbstractUserActionModifications().add((Object)modifyAcquireAction);
            LinkedList<AcquireDeviceResourceAction> processedAcquireActions = new LinkedList<AcquireDeviceResourceAction>();
            LinkedList<ReleaseDeviceResourceAction> processedReleaseActions = new LinkedList<ReleaseDeviceResourceAction>();
            List<AbstractUserAction> actionsUpToRelease = BPArchitectureModelLookup.lookUpUserActionsUpToReleaseDeviceResource((AcquireDeviceResourceAction)modifyAcquireAction.getAffectedElement(), processedAcquireActions, processedReleaseActions);
            if (actionsUpToRelease != null) {
                ReleaseDeviceResourceAction releaseAction = (ReleaseDeviceResourceAction)actionsUpToRelease.remove(actionsUpToRelease.size() - 1);
                this.getInterBusinessProcessPropagation().getAbstractUserActionModifications().add((Object)((BPModifyAbstractUserAction)releaseActionModifications.get(releaseAction)));
                for (AbstractUserAction actionWithDeviceResource : actionsUpToRelease) {
                    if (elementsMarkedInThisStep.containsKey(actionWithDeviceResource)) {
                        elementsMarkedInThisStep.get(actionWithDeviceResource).getCausingElements().add((Object)releaseAction.getPassiveresource_ReleaseAction());
                        elementsMarkedInThisStep.get(actionWithDeviceResource).getCausingElements().add((Object)((EObject)modifyAcquireAction.getAffectedElement()));
                        continue;
                    }
                    BPModifyAbstractUserAction modifyActionWithDeviceResource = BPModificationmarksFactory.eINSTANCE.createBPModifyAbstractUserAction();
                    modifyActionWithDeviceResource.setToolderived(true);
                    modifyActionWithDeviceResource.setAffectedElement((Object)actionWithDeviceResource);
                    modifyActionWithDeviceResource.getCausingElements().add((Object)releaseAction.getPassiveresource_ReleaseAction());
                    modifyActionWithDeviceResource.getCausingElements().add((Object)((EObject)modifyAcquireAction.getAffectedElement()));
                    elementsMarkedInThisStep.put((EObject)actionWithDeviceResource, (AbstractModification<?, EObject>)modifyActionWithDeviceResource);
                    this.getInterBusinessProcessPropagation().getAbstractUserActionModifications().add((Object)modifyActionWithDeviceResource);
                }
            } else {
                BPModifyReleaseDeviceResourceAction modifyReleaseAction = BPModificationmarksFactory.eINSTANCE.createBPModifyReleaseDeviceResourceAction();
                modifyReleaseAction.setToolderived(true);
                modifyReleaseAction.getCausingElements().add((Object)((AcquireDeviceResourceAction)modifyAcquireAction.getAffectedElement()).getPassiveresource_AcquireAction());
                this.getInterBusinessProcessPropagation().getAbstractUserActionModifications().add((Object)modifyReleaseAction);
            }
            MapUtil.removeAllFromMap(acquireActionModifications, processedAcquireActions);
            MapUtil.removeAllFromMap(releaseActionModifications, processedReleaseActions);
        }
    }

    protected void calculateAndMarkPropagationFromReleaseDeviceResourceActions(Map<ReleaseDeviceResourceAction, BPModifyReleaseDeviceResourceAction> releaseActionModifications) {
        while (!releaseActionModifications.isEmpty()) {
            BPModifyReleaseDeviceResourceAction modifyReleaseAction = releaseActionModifications.remove(0);
            this.getInterBusinessProcessPropagation().getAbstractUserActionModifications().add((Object)modifyReleaseAction);
            BPModifyAcquireDeviceResourceAction modifyAcquireAction = BPModificationmarksFactory.eINSTANCE.createBPModifyAcquireDeviceResourceAction();
            modifyAcquireAction.setToolderived(true);
            modifyAcquireAction.getCausingElements().add((Object)((AcquireDeviceResourceAction)modifyAcquireAction.getAffectedElement()).getPassiveresource_AcquireAction());
            this.getInterBusinessProcessPropagation().getAbstractUserActionModifications().add((Object)modifyAcquireAction);
        }
    }

    protected void calculateAndMarkSignatureToEntryLevelSystemCallPropagation(BPArchitectureVersion version, Map<EObject, AbstractModification<?, EObject>> elementsMarkedInThisStep) {
        Set markedSignatures = ArchitectureModelLookup.lookUpMarkedObjectsOfAType((AbstractArchitectureVersion)version, OperationSignature.class);
        List<EntryLevelSystemCall> entryLevelSystemCallsToBeMarked = BPArchitectureModelLookup.lookUpEntryLevelSystemCallsWithSignatures(version, markedSignatures);
        for (EntryLevelSystemCall eLSCToBeMarked : entryLevelSystemCallsToBeMarked) {
            if (elementsMarkedInThisStep.containsKey(eLSCToBeMarked)) {
                elementsMarkedInThisStep.get(eLSCToBeMarked).getCausingElements().add((Object)eLSCToBeMarked.getOperationSignature__EntryLevelSystemCall());
                continue;
            }
            BPModifyEntryLevelSystemCall modifyEntryLevelSystemCall = BPModificationmarksFactory.eINSTANCE.createBPModifyEntryLevelSystemCall();
            modifyEntryLevelSystemCall.setToolderived(true);
            modifyEntryLevelSystemCall.setAffectedElement((Object)eLSCToBeMarked);
            modifyEntryLevelSystemCall.getCausingElements().add((Object)eLSCToBeMarked.getOperationSignature__EntryLevelSystemCall());
            elementsMarkedInThisStep.put((EObject)eLSCToBeMarked, (AbstractModification<?, EObject>)modifyEntryLevelSystemCall);
            this.getInterBusinessProcessPropagation().getAbstractUserActionModifications().add((Object)modifyEntryLevelSystemCall);
        }
    }

    protected BPInterBusinessProcessPropagation getInterBusinessProcessPropagation() {
        return this.interBusinessProcessPropagation;
    }

    protected void setInterBusinessProcessPropagation(BPInterBusinessProcessPropagation interBusinessProcessPropagation) {
        this.interBusinessProcessPropagation = interBusinessProcessPropagation;
    }

    protected Collection<DataType> getMarkedDataTypes() {
        return this.markedDataTypes;
    }

    protected void setMarkedDataTypes(Collection<DataType> markedDataTypes) {
        this.markedDataTypes = markedDataTypes;
    }

    protected Collection<DataObject<?>> getMarkedDataObjects() {
        return this.markedDataObjects;
    }

    protected void setMarkedDataObjects(Collection<DataObject<?>> markedDataObjects) {
        this.markedDataObjects = markedDataObjects;
    }
}

