/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.kamp4bp.core;

import de.uhd.ifi.se.pcm.bppcm.bpusagemodel.BpusagemodelPackage;
import de.uhd.ifi.se.pcm.bppcm.datamodel.DataModel;
import de.uhd.ifi.se.pcm.bppcm.datamodel.DatamodelPackage;
import de.uhd.ifi.se.pcm.bppcm.organizationenvironmentmodel.OrganizationEnvironmentModel;
import de.uhd.ifi.se.pcm.bppcm.organizationenvironmentmodel.OrganizationenvironmentmodelPackage;
import de.uka.ipd.sdq.componentInternalDependencies.ComponentInternalDependencyRepository;
import edu.kit.ipd.sdq.kamp.util.FileAndFolderManagement;
import edu.kit.ipd.sdq.kamp4bp.core.BPArchitectureVersion;
import edu.kit.ipd.sdq.kamp4bp.model.fieldofactivityannotations.BPFieldOfActivityAnnotationsPackage;
import edu.kit.ipd.sdq.kamp4bp.model.modificationmarks.BPModificationmarksPackage;
import edu.kit.ipd.sdq.kamp4is.core.AbstractISArchitectureVersionPersistency;
import edu.kit.ipd.sdq.kamp4is.core.ISArchitectureVersion;
import edu.kit.ipd.sdq.kamp4is.model.fieldofactivityannotations.ISFieldOfActivityAnnotationsRepository;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.AbstractISModificationRepository;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.system.System;
import org.palladiosimulator.pcm.usagemodel.UsageModel;
import org.palladiosimulator.pcm.usagemodel.UsagemodelPackage;

public class BPArchitectureVersionPersistency
extends AbstractISArchitectureVersionPersistency<BPArchitectureVersion> {
    public static final String FILEEXTENSION_USAGEMODEL = "usagemodel";
    public static final String FILEEXTENSION_BPUSAGEMODEL = "bpusagemodel";
    public static final String FILEEXTENSION_DATAMODEL = "datamodel";
    public static final String FILEEXTENSION_ORGANIZATIONENVIRONMENTMODEL = "organizationenvironmentmodel";

    public BPArchitectureVersion load(String folderpath, String filename, String versionname) {
        ResourceSetImpl loadResourceSet = new ResourceSetImpl();
        String repositoryfilePath = String.valueOf(filename) + "." + "repository";
        String systemfilePath = String.valueOf(filename) + "." + "system";
        String fieldOfActivityRepositoryFilePath = String.valueOf(filename) + "." + "fieldofactivityannotations";
        String internalModFilePath = String.valueOf(filename) + "." + "modificationmarks";
        String cidepfilePath = String.valueOf(filename) + "." + "componentinternaldependencies";
        String usageModelFilePath = String.valueOf(filename) + "." + FILEEXTENSION_USAGEMODEL;
        String bpusageModelFilePath = String.valueOf(filename) + "." + FILEEXTENSION_BPUSAGEMODEL;
        String dataModelFilePath = String.valueOf(filename) + "." + FILEEXTENSION_DATAMODEL;
        String orgEnvironmentModelFilePath = String.valueOf(filename) + "." + FILEEXTENSION_ORGANIZATIONENVIRONMENTMODEL;
        Repository repository = (Repository)this.loadEmfModelFromResource(folderpath, repositoryfilePath, (ResourceSet)loadResourceSet);
        System system = (System)this.loadEmfModelFromResource(folderpath, systemfilePath, (ResourceSet)loadResourceSet);
        ISFieldOfActivityAnnotationsRepository fieldOfActivityRepository = (ISFieldOfActivityAnnotationsRepository)this.loadEmfModelFromResource(folderpath, fieldOfActivityRepositoryFilePath, (ResourceSet)loadResourceSet);
        AbstractISModificationRepository internalModificationMarkRepository = (AbstractISModificationRepository)this.loadEmfModelFromResource(folderpath, internalModFilePath, (ResourceSet)loadResourceSet);
        ComponentInternalDependencyRepository componentInternalDependencyRepository = (ComponentInternalDependencyRepository)this.loadEmfModelFromResource(folderpath, cidepfilePath, (ResourceSet)loadResourceSet);
        UsageModel usageModel = (UsageModel)this.loadEmfModelFromResource(folderpath, bpusageModelFilePath, (ResourceSet)loadResourceSet);
        if (usageModel == null) {
            usageModel = (UsageModel)this.loadEmfModelFromResource(folderpath, usageModelFilePath, (ResourceSet)loadResourceSet);
        }
        DataModel dataModel = (DataModel)this.loadEmfModelFromResource(folderpath, dataModelFilePath, (ResourceSet)loadResourceSet);
        OrganizationEnvironmentModel orgEnviromentModel = (OrganizationEnvironmentModel)this.loadEmfModelFromResource(folderpath, orgEnvironmentModelFilePath, (ResourceSet)loadResourceSet);
        return new BPArchitectureVersion(versionname, repository, system, fieldOfActivityRepository, internalModificationMarkRepository, componentInternalDependencyRepository, Collections.singletonMap("default", usageModel), dataModel, orgEnviromentModel);
    }

    public BPArchitectureVersion load(IContainer folder, String versionname) {
        ResourceSetImpl loadResourceSet = new ResourceSetImpl();
        IFile repositoryfile = FileAndFolderManagement.retrieveFileWithExtension((IContainer)folder, (String)"repository");
        IFile systemfile = FileAndFolderManagement.retrieveFileWithExtension((IContainer)folder, (String)"system");
        IFile fieldOfActivityRepositoryFile = FileAndFolderManagement.retrieveFileWithExtension((IContainer)folder, (String)"fieldofactivityannotations");
        IFile internalModFile = FileAndFolderManagement.retrieveFileWithExtension((IContainer)folder, (String)"modificationmarks");
        IFile cidepfile = FileAndFolderManagement.retrieveFileWithExtension((IContainer)folder, (String)"componentinternaldependencies");
        Collection usageModelFiles = FileAndFolderManagement.retrieveFilesWithExtension((IContainer)folder, (String)FILEEXTENSION_BPUSAGEMODEL);
        usageModelFiles.addAll(FileAndFolderManagement.retrieveFilesWithExtension((IContainer)folder, (String)FILEEXTENSION_USAGEMODEL));
        IFile dataModelFile = FileAndFolderManagement.retrieveFileWithExtension((IContainer)folder, (String)FILEEXTENSION_DATAMODEL);
        IFile organizationEnvironmentModelFile = FileAndFolderManagement.retrieveFileWithExtension((IContainer)folder, (String)FILEEXTENSION_ORGANIZATIONENVIRONMENTMODEL);
        Repository repository = null;
        System system = null;
        ISFieldOfActivityAnnotationsRepository fieldOfActivityRepository = null;
        AbstractISModificationRepository internalModificationMarkRepository = null;
        ComponentInternalDependencyRepository componentInternalDependencyRepository = null;
        HashMap<String, UsageModel> usageModels = new HashMap<String, UsageModel>();
        DataModel dataModel = null;
        OrganizationEnvironmentModel organizationEnvironmentModel = null;
        if (repositoryfile != null && repositoryfile.exists()) {
            repository = (Repository)this.loadEmfModelFromResource(repositoryfile.getFullPath().toString(), null, (ResourceSet)loadResourceSet);
        }
        if (systemfile != null && systemfile.exists()) {
            system = (System)this.loadEmfModelFromResource(systemfile.getFullPath().toString(), null, (ResourceSet)loadResourceSet);
        }
        if (fieldOfActivityRepositoryFile != null && fieldOfActivityRepositoryFile.exists()) {
            fieldOfActivityRepository = (ISFieldOfActivityAnnotationsRepository)this.loadEmfModelFromResource(fieldOfActivityRepositoryFile.getFullPath().toString(), null, (ResourceSet)loadResourceSet);
        }
        if (internalModFile != null && internalModFile.exists()) {
            internalModificationMarkRepository = (AbstractISModificationRepository)this.loadEmfModelFromResource(internalModFile.getFullPath().toString(), null, (ResourceSet)loadResourceSet);
        }
        if (cidepfile != null && cidepfile.exists()) {
            componentInternalDependencyRepository = (ComponentInternalDependencyRepository)this.loadEmfModelFromResource(cidepfile.getFullPath().toString(), null, (ResourceSet)loadResourceSet);
        }
        for (IFile usageModelFile : usageModelFiles) {
            if (usageModelFile == null || !usageModelFile.exists()) continue;
            usageModels.put(usageModelFile.getName(), (UsageModel)this.loadEmfModelFromResource(usageModelFile.getFullPath().toString(), null, (ResourceSet)loadResourceSet));
        }
        if (dataModelFile != null && dataModelFile.exists()) {
            dataModel = (DataModel)this.loadEmfModelFromResource(dataModelFile.getFullPath().toString(), null, (ResourceSet)loadResourceSet);
        }
        if (organizationEnvironmentModelFile != null && organizationEnvironmentModelFile.exists()) {
            organizationEnvironmentModel = (OrganizationEnvironmentModel)this.loadEmfModelFromResource(organizationEnvironmentModelFile.getFullPath().toString(), null, (ResourceSet)loadResourceSet);
        }
        return new BPArchitectureVersion(versionname, repository, system, fieldOfActivityRepository, internalModificationMarkRepository, componentInternalDependencyRepository, usageModels, dataModel, organizationEnvironmentModel);
    }

    public void save(String targetDirectoryPath, String filename, BPArchitectureVersion version) {
        BPArchitectureVersionPersistency.savePCMAndKAMPModels((String)targetDirectoryPath, (String)filename, (ISArchitectureVersion)version);
        BPArchitectureVersionPersistency.saveBusinessProcessModels(targetDirectoryPath, filename, version);
    }

    public static void saveBusinessProcessModels(String targetDirectoryPath, String filename, BPArchitectureVersion version) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        String usageModelFilePath = String.valueOf(filename) + "." + FILEEXTENSION_USAGEMODEL;
        String dataModelFilePath = String.valueOf(filename) + "." + FILEEXTENSION_DATAMODEL;
        String organizationEnvironmentModelFilePath = String.valueOf(filename) + "." + FILEEXTENSION_ORGANIZATIONENVIRONMENTMODEL;
        if (version.getUsageModels().containsKey(filename)) {
            BPArchitectureVersionPersistency.saveEmfModelToResource((EObject)((EObject)version.getUsageModels().get(filename)), (String)targetDirectoryPath, (String)usageModelFilePath, (ResourceSet)resourceSet);
        }
        if (version.getDataModel() != null) {
            BPArchitectureVersionPersistency.saveEmfModelToResource((EObject)version.getDataModel(), (String)targetDirectoryPath, (String)dataModelFilePath, (ResourceSet)resourceSet);
        }
        if (version.getOrganizationEnvironmentModel() != null) {
            BPArchitectureVersionPersistency.saveEmfModelToResource((EObject)version.getOrganizationEnvironmentModel(), (String)targetDirectoryPath, (String)organizationEnvironmentModelFilePath, (ResourceSet)resourceSet);
        }
    }

    protected void registerEPackages(ResourceSet resourceSet) {
        BPArchitectureVersionPersistency.registerKAMPPackages((ResourceSet)resourceSet);
        BPArchitectureVersionPersistency.registerBusinessProcessPackages(resourceSet);
    }

    public static void registerBusinessProcessPackages(ResourceSet resourceSet) {
        resourceSet.getPackageRegistry().put((Object)"http://sdq.ipd.kit.edu/KAMP4BPModificationmarks/1.0", (Object)BPModificationmarksPackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)"http://sdq.ipd.kit.edu/KAMP4BPFieldOfActivityAnnotations/1.0", (Object)BPFieldOfActivityAnnotationsPackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)"http://palladiosimulator.org/PalladioComponentModel/UsageModel/5.2", (Object)UsagemodelPackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)"http://palladiosimulator.org/PalladioComponentModel/5.1/bp/bpUsageModel", (Object)BpusagemodelPackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)"http://palladiosimulator.org/PalladioComponentModel/5.1/bp/DataModel", (Object)DatamodelPackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)"http://palladiosimulator.org/PalladioComponentModel/5.1/bp/OrganizationEnvironmentModel", (Object)OrganizationenvironmentmodelPackage.eINSTANCE);
    }
}

