/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.kamp.model.modificationmarks.editor;

import edu.kit.ipd.sdq.kamp.architecture.AbstractArchitectureVersion;
import edu.kit.ipd.sdq.kamp.architecture.AbstractArchitectureVersionPersistency;
import edu.kit.ipd.sdq.kamp.model.modificationmarks.AbstractModificationRepository;
import edu.kit.ipd.sdq.kamp.propagation.AbstractChangePropagationAnalysis;
import edu.kit.ipd.sdq.kamp.ui.AbstractDeriveWorkplanAction;
import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractChangePropagationAction<T extends AbstractArchitectureVersion<?>>
implements IActionDelegate {
    private ISelection selection;

    protected abstract AbstractChangePropagationAnalysis<T> createChangePropagationAnalysis();

    protected abstract AbstractArchitectureVersionPersistency<T> createArchitectureVersionPersistency();

    public void run(IAction action) {
        PlatformUI.getWorkbench().saveAllEditors(false);
        AbstractArchitectureVersionPersistency<T> architectureVersionPersistency = this.createArchitectureVersionPersistency();
        Object selectedElement = null;
        if (this.selection instanceof IStructuredSelection && ((IStructuredSelection)this.selection).size() == 1) {
            selectedElement = ((IStructuredSelection)this.selection).getFirstElement();
        }
        if (selectedElement != null && selectedElement instanceof AbstractModificationRepository) {
            URI resourceURI = ((AbstractModificationRepository)selectedElement).eResource().getURI();
            String fileName = resourceURI.trimFileExtension().lastSegment();
            String folderPathString = resourceURI.trimSegments(1).toPlatformString(false);
            IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(folderPathString));
            AbstractArchitectureVersion targetversion = null;
            if (folderPathString != null) {
                targetversion = architectureVersionPersistency.load((IContainer)folder, "target");
            }
            if (targetversion != null) {
                targetversion.getModificationMarkRepository().getChangePropagationSteps().clear();
                this.createChangePropagationAnalysis().runChangePropagationAnalysis(targetversion);
                try {
                    architectureVersionPersistency.saveModificationMarkFile(folderPathString, fileName, targetversion);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!targetversion.getModificationMarkRepository().getChangePropagationSteps().isEmpty()) {
                AbstractDeriveWorkplanAction.showMessage((String)"Propagation steps have been added to the tree.");
            } else {
                AbstractDeriveWorkplanAction.showMessage((String)"No propagation steps could be found.");
            }
            PlatformUI.getWorkbench().saveAllEditors(false);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }
}

