/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.kamp.model.modificationmarks.editor;

import edu.kit.ipd.sdq.kamp.architecture.AbstractArchitectureVersion;
import edu.kit.ipd.sdq.kamp.model.modificationmarks.AbstractModificationRepository;
import edu.kit.ipd.sdq.kamp.ui.AbstractDeriveWorkplanAction;
import edu.kit.ipd.sdq.kamp.workplan.WorkplanDuplicateRemoval;
import edu.kit.ipd.sdq.kamp.workplan.WorkplanSorter;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractArchitectureBasedWorkplanDerivationAction<T extends AbstractArchitectureVersion<?>>
extends AbstractDeriveWorkplanAction<T> {
    public void run(IAction action) {
        Object selectedElement = null;
        if (this.getSelection() instanceof IStructuredSelection && ((IStructuredSelection)this.getSelection()).size() == 1) {
            selectedElement = ((IStructuredSelection)this.getSelection()).getFirstElement();
        }
        if (selectedElement != null && selectedElement instanceof AbstractModificationRepository) {
            URI resourceURI = ((AbstractModificationRepository)selectedElement).eResource().getURI();
            String nameOfTargetVersionFolder = resourceURI.trimSegments(1).lastSegment();
            String targetFolderPathString = resourceURI.trimSegments(1).toPlatformString(false);
            IFile currentFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(resourceURI.toPlatformString(false)));
            IContainer targetFolder = currentFile.getParent();
            IContainer baseFolder = targetFolder.getParent();
            AbstractArchitectureVersion targetversion = this.loadVersion(targetFolder, "target");
            AbstractArchitectureVersion baseversion = this.loadVersion(baseFolder, "base");
            if (baseversion != null && targetversion != null) {
                String username = System.getProperty("user.name");
                String usernameSuffix = username != null ? username : "";
                List baseActivityList = this.getWorkplanDerivation().deriveWorkplan(baseversion, targetversion);
                baseActivityList = WorkplanDuplicateRemoval.removeModificationDuplicates((List)baseActivityList);
                List enrichedActivityList = this.getEnrichedWorkplanDerivation().deriveEnrichedWorkplan(baseversion, targetversion, baseActivityList);
                WorkplanSorter.sortWorkplanActivities((List)enrichedActivityList);
                this.getArchitectureVersionPersistency().saveActivityListToExcelFile(targetFolderPathString, "activitylist-" + usernameSuffix + "-" + nameOfTargetVersionFolder, enrichedActivityList);
                AbstractArchitectureBasedWorkplanDerivationAction.showMessage((String)"Activity list has been calculated.");
                PlatformUI.getWorkbench().saveAllEditors(false);
                AbstractArchitectureBasedWorkplanDerivationAction.refreshAllProjectsInWorkspace();
            }
            if (baseversion == null) {
                AbstractArchitectureBasedWorkplanDerivationAction.showMessage((String)"Activity list could not be calculated, as the base version was not found.");
            }
            if (targetversion == null) {
                AbstractArchitectureBasedWorkplanDerivationAction.showMessage((String)"Activity list could not be calculated, as the target version was not found.");
            }
        }
    }
}

