/*
 * Decompiled with CFR 0.152.
 */
package de.uhd.ifi.se.pcm.bppcm.ui;

import de.uhd.ifi.se.pcm.bppcm.ui.ActorCalendar;
import de.uhd.ifi.se.pcm.bppcm.ui.ActorDayProfilesPage;
import de.uhd.ifi.se.pcm.bppcm.ui.ActorEditDayProfile;
import java.text.SimpleDateFormat;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ActorEditPeriodPage
extends WizardPage {
    private Composite container;
    protected ActorCalendar calendar;
    protected IWizardPage pageOne;
    protected IWizardPage pageTwo;
    protected Text text1;
    protected Text text2;

    public ActorEditPeriodPage(ActorCalendar actorCalendar, IWizardPage one, IWizardPage two) {
        super("Edit a period");
        this.setTitle("Edit a period");
        this.pageOne = one;
        this.pageTwo = two;
        this.calendar = actorCalendar;
        this.setDescription("Here you can edit a period");
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.container.setLayout((Layout)layout);
        layout.numColumns = 2;
        Label label1 = new Label(this.container, 0);
        label1.setText("Start time:");
        this.text1 = new Text(this.container, 2052);
        Label label2 = new Label(this.container, 0);
        label2.setText("End Time:");
        this.text2 = new Text(this.container, 2052);
        Button saveButton = new Button(this.container, 8);
        saveButton.setText("Save changes");
        saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActorEditPeriodPage.this.editPeriod();
            }
        });
        this.setControl((Control)this.container);
        this.setPageComplete(false);
    }

    public void fillTexts() {
        int indexPeriod = ((ActorEditDayProfile)this.pageTwo).periodList.getSelectionIndex();
        int indexDayProfile = ((ActorDayProfilesPage)this.pageOne).getList().getSelectionIndex();
        this.text1.setText(this.calendar.getDayprofiles().get(indexDayProfile).getPeriods().get(indexPeriod).getStartTimePoint().toPattern());
        this.text2.setText(this.calendar.getDayprofiles().get(indexDayProfile).getPeriods().get(indexPeriod).getEndTimePointtime().toPattern());
    }

    public void editPeriod() {
        if (!this.text1.getText().isEmpty() && !this.text2.getText().isEmpty()) {
            String start = this.text1.getText();
            String end = this.text2.getText();
            if (start.matches("^(?:(?:([01]?\\d|2[0-3]):)?([0-5]?\\d):)?([0-5]?\\d)$") && end.matches("^(?:(?:([01]?\\d|2[0-3]):)?([0-5]?\\d):)?([0-5]?\\d)$")) {
                String[] partsStart = start.split(":");
                String hoursPartsStart = partsStart[0];
                String minutesPartsStart = partsStart[1];
                String secondsPartsStrart = partsStart[2];
                int hoursStart = Integer.parseInt(hoursPartsStart);
                int minutesStart = Integer.parseInt(minutesPartsStart);
                int secondsStart = Integer.parseInt(secondsPartsStrart);
                String[] partsEnd = end.split(":");
                String hoursPartsEnd = partsEnd[0];
                String minutesPartsEnd = partsEnd[1];
                String secondsPartsEnd = partsEnd[2];
                int hoursEnd = Integer.parseInt(hoursPartsEnd);
                int minutesEnd = Integer.parseInt(minutesPartsEnd);
                int secondsEnd = Integer.parseInt(secondsPartsEnd);
                int startInt = secondsStart + 60 * minutesStart + 3600 * hoursStart;
                int endInt = secondsEnd + 60 * minutesEnd + 3600 * hoursEnd;
                int i = ((ActorDayProfilesPage)this.pageOne).getList().getSelectionIndex();
                int index = ((ActorEditDayProfile)this.pageTwo).periodList.getSelectionIndex();
                boolean notOverlap = true;
                int j = 0;
                while (j < this.calendar.getDayprofiles().get(i).getPeriods().size()) {
                    if (j != index) {
                        String st = this.calendar.getDayprofiles().get(i).getPeriods().get(j).getStartTimePoint().toPattern();
                        String en = this.calendar.getDayprofiles().get(i).getPeriods().get(j).getEndTimePointtime().toPattern();
                        String[] partsSt = st.split(":");
                        String hoursPartsSt = partsSt[0];
                        String minutesPartsSt = partsSt[1];
                        String secondsPartsSt = partsSt[2];
                        int hoursSt = Integer.parseInt(hoursPartsSt);
                        int minutesSt = Integer.parseInt(minutesPartsSt);
                        int secondsSt = Integer.parseInt(secondsPartsSt);
                        String[] partsEn = en.split(":");
                        String hoursPartsEn = partsEn[0];
                        String minutesPartsEn = partsEn[1];
                        String secondsPartsEn = partsEn[2];
                        int hoursEn = Integer.parseInt(hoursPartsEn);
                        int minutesEn = Integer.parseInt(minutesPartsEn);
                        int secondsEn = Integer.parseInt(secondsPartsEn);
                        int startIntValue = secondsSt + 60 * minutesSt + 3600 * hoursSt;
                        int endIntValue = secondsEn + 60 * minutesEn + 3600 * hoursEn;
                        if (startInt < endIntValue && endInt > startIntValue) {
                            notOverlap = false;
                            this.setDescription("this period overlaps with an already existing period");
                            this.setPageComplete(false);
                        }
                    }
                    ++j;
                }
                if (notOverlap) {
                    if (startInt < endInt) {
                        this.edit(start, end);
                        ((ActorEditDayProfile)this.pageTwo).fillList();
                        this.setPageComplete(true);
                    } else {
                        this.setDescription("end time is earlier than start time");
                        this.setPageComplete(false);
                    }
                }
            } else {
                this.setDescription("invalid period definition");
                this.setPageComplete(false);
            }
        } else {
            this.setPageComplete(false);
        }
    }

    public void edit(String startTime, String endTime) {
        int indexPeriod = ((ActorEditDayProfile)this.pageTwo).periodList.getSelectionIndex();
        int indexDayProfile = ((ActorDayProfilesPage)this.pageOne).getList().getSelectionIndex();
        SimpleDateFormat start = new SimpleDateFormat(startTime);
        SimpleDateFormat end = new SimpleDateFormat(endTime);
        this.calendar.getDayprofiles().get(indexDayProfile).getPeriods().get(indexPeriod).setStartTimePoint(start);
        this.calendar.getDayprofiles().get(indexDayProfile).getPeriods().get(indexPeriod).setEndTimePointtime(end);
        this.setPageComplete(true);
        this.setDescription(" ");
    }
}

