/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.emf.refactor.tests.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;

public class EcoreBuilder {
    public static void addAttribute(EClass context, String name, EClassifier type, boolean isId, int lowerBound, int upperBound) {
        EAttribute attribute = EcoreFactory.eINSTANCE.createEAttribute();
        context.getEStructuralFeatures().add((Object)attribute);
        attribute.setName(name);
        attribute.setEType(type);
        attribute.setID(isId);
        attribute.setLowerBound(lowerBound);
        attribute.setUpperBound(upperBound);
    }

    public static void addReference(EClass context, String name, EClassifier type, boolean containment, int lowerBound, int upperBound) {
        EReference reference = EcoreFactory.eINSTANCE.createEReference();
        context.getEStructuralFeatures().add((Object)reference);
        reference.setName(name);
        reference.setEType(type);
        reference.setContainment(containment);
        reference.setLowerBound(lowerBound);
        reference.setUpperBound(upperBound);
    }

    public static void makeOppositeReference(EClass firstClass, String firstReferenceName, EClass secondClass, String secondReferenceName) {
        EReference firstReference = null;
        EReference secondReference = null;
        for (EReference currentReference : firstClass.getEAllReferences()) {
            if (!currentReference.getName().equals(firstReferenceName)) continue;
            firstReference = currentReference;
        }
        for (EReference currentReference : secondClass.getEAllReferences()) {
            if (!currentReference.getName().equals(secondReferenceName)) continue;
            secondReference = currentReference;
        }
        if (firstReference != null && secondReference != null) {
            firstReference.setEOpposite(secondReference);
            secondReference.setEOpposite(firstReference);
        }
    }

    public static void addEEnumLiteral(EEnum context, String name, int value) {
        EEnumLiteral enumLiteral = EcoreFactory.eINSTANCE.createEEnumLiteral();
        context.getELiterals().add((Object)enumLiteral);
        enumLiteral.setName(name);
        enumLiteral.setValue(value);
    }

    public static EPackage createPackage(String name, String prefix, String uri) {
        EPackage epackage = EcoreFactory.eINSTANCE.createEPackage();
        epackage.setName(name);
        epackage.setNsPrefix(prefix);
        epackage.setNsURI(uri);
        return epackage;
    }

    public static EClass createEClass(String name) {
        EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        eClass.setName(name);
        return eClass;
    }

    public static EEnum createEEnum(String name) {
        EEnum eEnum = EcoreFactory.eINSTANCE.createEEnum();
        eEnum.setName(name);
        return eEnum;
    }

    public static void addSuperType(EClass context, EPackage superTypePackage, String className) {
        EClass eSuperClass = (EClass)superTypePackage.getEClassifier(className);
        context.getESuperTypes().add((Object)eSuperClass);
    }

    public static void initStandalone() {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
    }

    public static void savePackageToFile(EPackage packageToSave, String filePath) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource outputRes = resourceSet.createResource(URI.createFileURI((String)filePath));
        outputRes.getContents().add((Object)packageToSave);
        try {
            outputRes.save(Collections.emptyMap());
            outputRes.save((OutputStream)System.out, Collections.emptyMap());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

