/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.emf.refactor.tests;

import edu.kit.ipd.sdq.emf.refactor.tests.util.EcoreBuilder;
import edu.kit.ipd.sdq.emf.refactor.tests.util.SmellFinder;
import java.util.LinkedList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.refactor.modelsmell.CyclicDependentModularization;
import org.eclipse.emf.refactor.modelsmell.CyclicHierarchy;
import org.eclipse.emf.refactor.modelsmell.DeepHierarchy;
import org.eclipse.emf.refactor.modelsmell.HubLikeModularization_IncomingDependencies;
import org.eclipse.emf.refactor.modelsmell.HubLikeModularization_OutgoingDependencies;
import org.eclipse.emf.refactor.modelsmell.LateHierarchy;
import org.eclipse.emf.refactor.modelsmell.MissingAbstraction_DataClumpsAttributes;
import org.eclipse.emf.refactor.modelsmell.MissingAbstraction_PrimitiveObessionPrimitiveTypes;
import org.eclipse.emf.refactor.modelsmell.MultipathHierarchy;
import org.eclipse.emf.refactor.modelsmell.ObligatoryContainerRelation;
import org.eclipse.emf.refactor.modelsmell.RedundantContainerRelation;
import org.eclipse.emf.refactor.modelsmell.SpecializationAggregation;
import org.eclipse.emf.refactor.modelsmell.UnutilizedAbstraction_UnusedClasses;
import org.eclipse.emf.refactor.modelsmell.UnutilizedAbstraction_UnusedEnumeration;
import org.eclipse.emf.refactor.modelsmell.WideHierarchy;
import org.eclipse.emf.refactor.smells.core.MetricBasedModelSmellFinderClass;
import org.eclipse.emf.refactor.smells.interfaces.IModelSmellFinder;
import org.eclipse.emf.refactor.smells.runtime.core.Result;
import org.junit.Assert;
import org.junit.Test;

public class DetectionTests {
    @Test
    public void validateWideHierarchyDetection_DifferentLimits() {
        EcoreBuilder.initStandalone();
        EPackage testPackage = EcoreBuilder.createPackage("testPackage", "testPackage", "http://testPackage");
        EClass superType = EcoreBuilder.createEClass("SuperType");
        testPackage.getEClassifiers().add((Object)superType);
        EClass subType1 = EcoreBuilder.createEClass("SubType1");
        testPackage.getEClassifiers().add((Object)subType1);
        EcoreBuilder.addSuperType(subType1, testPackage, superType.getName());
        EClass subType2 = EcoreBuilder.createEClass("SubType2");
        testPackage.getEClassifiers().add((Object)subType2);
        EcoreBuilder.addSuperType(subType2, testPackage, superType.getName());
        EClass subType3 = EcoreBuilder.createEClass("SubType3");
        testPackage.getEClassifiers().add((Object)subType3);
        EcoreBuilder.addSuperType(subType3, testPackage, superType.getName());
        EClass subType4 = EcoreBuilder.createEClass("SubType4");
        testPackage.getEClassifiers().add((Object)subType4);
        EcoreBuilder.addSuperType(subType4, testPackage, superType.getName());
        EClass subType5 = EcoreBuilder.createEClass("SubType5");
        testPackage.getEClassifiers().add((Object)subType5);
        EcoreBuilder.addSuperType(subType5, testPackage, superType.getName());
        EcoreBuilder.savePackageToFile(testPackage, "WideHierarchy.ecore");
        Result result = SmellFinder.findMetricSmellWithLimit((MetricBasedModelSmellFinderClass)new WideHierarchy(), 5.0, (EObject)testPackage);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.getModelelements().size());
        result = SmellFinder.findMetricSmellWithLimit((MetricBasedModelSmellFinderClass)new WideHierarchy(), 6.0, (EObject)testPackage);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.getModelelements().size());
    }

    @Test
    public void validateDeepHierarchyDetection_DifferentLimits() {
        EcoreBuilder.initStandalone();
        EPackage testPackage = EcoreBuilder.createPackage("testPackage", "testPackage", "http://testPackage");
        EClass superType = EcoreBuilder.createEClass("SuperType");
        testPackage.getEClassifiers().add((Object)superType);
        EClass subType = EcoreBuilder.createEClass("SubType");
        testPackage.getEClassifiers().add((Object)subType);
        EcoreBuilder.addSuperType(subType, testPackage, superType.getName());
        EClass subSubType = EcoreBuilder.createEClass("SubSubType");
        testPackage.getEClassifiers().add((Object)subSubType);
        EcoreBuilder.addSuperType(subSubType, testPackage, subType.getName());
        EClass subSubSubType = EcoreBuilder.createEClass("SubSubSubType");
        testPackage.getEClassifiers().add((Object)subSubSubType);
        EcoreBuilder.addSuperType(subSubSubType, testPackage, subSubType.getName());
        EcoreBuilder.savePackageToFile(testPackage, "DeepHierarchy.ecore");
        Result result = SmellFinder.findMetricSmellWithLimit((MetricBasedModelSmellFinderClass)new DeepHierarchy(), 3.0, (EObject)testPackage);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.getModelelements().size());
        result = SmellFinder.findMetricSmellWithLimit((MetricBasedModelSmellFinderClass)new DeepHierarchy(), 4.0, (EObject)testPackage);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.getModelelements().size());
    }

    @Test
    public void validateMissingAbstraction_DataClumpsAttributesDetection() {
        EcoreBuilder.initStandalone();
        EPackage testPackage = EcoreBuilder.createPackage("testPackage", "testPackage", "http://testPackage");
        EClass firstClass = EcoreBuilder.createEClass("FirstClass");
        testPackage.getEClassifiers().add((Object)firstClass);
        EcoreBuilder.addAttribute(firstClass, "firstAttribute", (EClassifier)EcorePackage.Literals.EDOUBLE, false, 0, 1);
        EcoreBuilder.addAttribute(firstClass, "secondAttribute", (EClassifier)EcorePackage.Literals.EINT, false, 0, 1);
        EClass secondClass = EcoreBuilder.createEClass("SecondClass");
        testPackage.getEClassifiers().add((Object)secondClass);
        EcoreBuilder.addAttribute(secondClass, "firstAttribute", (EClassifier)EcorePackage.Literals.EDOUBLE, false, 0, 1);
        EcoreBuilder.addAttribute(secondClass, "secondAttribute", (EClassifier)EcorePackage.Literals.EINT, false, 0, 1);
        EcoreBuilder.savePackageToFile(testPackage, "MissingAbstractionDataClumps.ecore");
        Result result = SmellFinder.findMetricSmellWithLimit((MetricBasedModelSmellFinderClass)new MissingAbstraction_DataClumpsAttributes(), 2.0, (EObject)testPackage);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)2L, (long)result.getModelelements().size());
        result = SmellFinder.findMetricSmellWithLimit((MetricBasedModelSmellFinderClass)new MissingAbstraction_DataClumpsAttributes(), 3.0, (EObject)testPackage);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.getModelelements().size());
    }

    @Test
    public void validateMissingAbstraction_PrimitiveObessionPrimitiveTypesDetection() {
        EcoreBuilder.initStandalone();
        EPackage testPackage = EcoreBuilder.createPackage("testPackage", "testPackage", "http://testPackage");
        EClass firstClass = EcoreBuilder.createEClass("FirstClass");
        testPackage.getEClassifiers().add((Object)firstClass);
        EcoreBuilder.addAttribute(firstClass, "firstAttribute", (EClassifier)EcorePackage.Literals.EINT, false, 0, 1);
        EcoreBuilder.addAttribute(firstClass, "secondAttribute", (EClassifier)EcorePackage.Literals.EINT, false, 0, 1);
        EClass secondClass = EcoreBuilder.createEClass("SecondClass");
        testPackage.getEClassifiers().add((Object)secondClass);
        EcoreBuilder.addAttribute(secondClass, "firstAttribute", (EClassifier)EcorePackage.Literals.EINT, false, 0, 1);
        EcoreBuilder.addAttribute(secondClass, "secondAttribute", (EClassifier)EcorePackage.Literals.EINT, false, 0, 1);
        EcoreBuilder.savePackageToFile(testPackage, "MissingAbstractionPrimitiveObsessionPrimitiveTypes.ecore");
        Result result = SmellFinder.findMetricSmellWithLimit((MetricBasedModelSmellFinderClass)new MissingAbstraction_PrimitiveObessionPrimitiveTypes(), 2.0, (EObject)testPackage);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)2L, (long)result.getModelelements().size());
        result = SmellFinder.findMetricSmellWithLimit((MetricBasedModelSmellFinderClass)new MissingAbstraction_PrimitiveObessionPrimitiveTypes(), 3.0, (EObject)testPackage);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.getModelelements().size());
    }

    @Test
    public void validateMultipathHierarchyDetection() {
        EcoreBuilder.initStandalone();
        EPackage testPackage = EcoreBuilder.createPackage("testPackage", "testPackage", "http://testPackage");
        EClass supersuperClass = EcoreBuilder.createEClass("SuperSuperClass");
        testPackage.getEClassifiers().add((Object)supersuperClass);
        EClass firstSuperClass = EcoreBuilder.createEClass("FirstSuperClass");
        testPackage.getEClassifiers().add((Object)firstSuperClass);
        EcoreBuilder.addSuperType(firstSuperClass, testPackage, "SuperSuperClass");
        EClass secondSuperClass = EcoreBuilder.createEClass("SecondSuperClass");
        testPackage.getEClassifiers().add((Object)secondSuperClass);
        EcoreBuilder.addSuperType(secondSuperClass, testPackage, "SuperSuperClass");
        EClass derivedClass = EcoreBuilder.createEClass("DerivedClass");
        testPackage.getEClassifiers().add((Object)derivedClass);
        EcoreBuilder.addSuperType(derivedClass, testPackage, "FirstSuperClass");
        EcoreBuilder.addSuperType(derivedClass, testPackage, "SecondSuperClass");
        EcoreBuilder.savePackageToFile(testPackage, "MultipathHierarchy.ecore");
        Result result = SmellFinder.findSmell((IModelSmellFinder)new MultipathHierarchy(), (EObject)testPackage);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.getModelelements().size());
        Assert.assertEquals((long)4L, (long)((LinkedList)result.getModelelements().get(0)).size());
    }

    @Test
    public void validateMultipathHierarchyDetection_OneDirectOneIndirect() {
        EcoreBuilder.initStandalone();
        EPackage testPackage = EcoreBuilder.createPackage("testPackage", "testPackage", "http://testPackage");
        EClass supersuperClass = EcoreBuilder.createEClass("SuperSuperClass");
        testPackage.getEClassifiers().add((Object)supersuperClass);
        EClass superClass = EcoreBuilder.createEClass("SuperClass");
        testPackage.getEClassifiers().add((Object)superClass);
        EcoreBuilder.addSuperType(superClass, testPackage, "SuperSuperClass");
        EClass derivedClass = EcoreBuilder.createEClass("DerivedClass");
        testPackage.getEClassifiers().add((Object)derivedClass);
        EcoreBuilder.addSuperType(derivedClass, testPackage, "SuperClass");
        EcoreBuilder.addSuperType(derivedClass, testPackage, "SuperSuperClass");
        EcoreBuilder.savePackageToFile(testPackage, "MultipathHierarchy2.ecore");
        Result result = SmellFinder.findSmell((IModelSmellFinder)new MultipathHierarchy(), (EObject)testPackage);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.getModelelements().size());
        Assert.assertEquals((long)3L, (long)((LinkedList)result.getModelelements().get(0)).size());
    }

    @Test
    public void validateUnutilizedAbstractionUnusedClassDetection_UnusedClasses_BothClassesAreDetected() {
        EcoreBuilder.initStandalone();
        EPackage testPackage = EcoreBuilder.createPackage("testPackage", "testPackage", "http://testPackage");
        EClass superClass = EcoreBuilder.createEClass("SuperClass");
        testPackage.getEClassifiers().add((Object)superClass);
        EClass subClass = EcoreBuilder.createEClass("SubClass");
        testPackage.getEClassifiers().add((Object)subClass);
        EcoreBuilder.savePackageToFile(testPackage, "UnutilizedAbstraction_UnusedClass1.ecore");
        Result result = SmellFinder.findSmell((IModelSmellFinder)new UnutilizedAbstraction_UnusedClasses(), (EObject)testPackage);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)2L, (long)result.getModelelements().size());
        Assert.assertEquals((long)1L, (long)((LinkedList)result.getModelelements().get(0)).size());
        Assert.assertEquals((long)1L, (long)((LinkedList)result.getModelelements().get(1)).size());
    }

    @Test
    public void validateUnutilizedAbstractionUnusedClassDetection_UsedAsSuperType_NoClassDetected() {
        EcoreBuilder.initStandalone();
        EPackage testPackage = EcoreBuilder.createPackage("testPackage", "testPackage", "http://testPackage");
        EClass superClass = EcoreBuilder.createEClass("SuperClass");
        testPackage.getEClassifiers().add((Object)superClass);
        EClass subClass = EcoreBuilder.createEClass("SubClass");
        testPackage.getEClassifiers().add((Object)subClass);
        EcoreBuilder.addSuperType(subClass, testPackage, "SuperClass");
        Result result = SmellFinder.findSmell((IModelSmellFinder)new UnutilizedAbstraction_UnusedClasses(), (EObject)testPackage);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.getModelelements().size());
    }

    @Test
    public void validateUnutilizedAbstractionUnusedClassDetection_UsedAsType_ReferencingClassDetected() {
        EcoreBuilder.initStandalone();
        EPackage testPackage = EcoreBuilder.createPackage("testPackage", "testPackage", "http://testPackage");
        EClass superClass = EcoreBuilder.createEClass("SuperClass");
        testPackage.getEClassifiers().add((Object)superClass);
        EClass subClass = EcoreBuilder.createEClass("SubClass");
        testPackage.getEClassifiers().add((Object)subClass);
        EcoreBuilder.addReference(subClass, "testReference", (EClassifier)superClass, false, 0, 1);
        EcoreBuilder.savePackageToFile(testPackage, "UnutilizedAbstraction_UnusedClass2.ecore");
        Result result = SmellFinder.findSmell((IModelSmellFinder)new UnutilizedAbstraction_UnusedClasses(), (EObject)testPackage);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.getModelelements().size());
    }

    @Test
    public void validateUnutilizedAbstractionUnusedEnumDetection_Unused_EnumDetected() {
        EcoreBuilder.initStandalone();
        EPackage testPackage = EcoreBuilder.createPackage("testPackage", "testPackage", "http://testPackage");
        EEnum eEnum = EcoreBuilder.createEEnum("TestEnum");
        EcoreBuilder.addEEnumLiteral(eEnum, "firstLiteral", 0);
        testPackage.getEClassifiers().add((Object)eEnum);
        EClass superClass = EcoreBuilder.createEClass("SuperClass");
        testPackage.getEClassifiers().add((Object)superClass);
        EcoreBuilder.savePackageToFile(testPackage, "UnutilizedAbstraction_UnusedEnum.ecore");
        Result result = SmellFinder.findSmell((IModelSmellFinder)new UnutilizedAbstraction_UnusedEnumeration(), (EObject)testPackage);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.getModelelements().size());
    }

    @Test
    public void validateUnutilizedAbstractionUnusedEnumDetection_UsedAsType_NoEnumDetected() {
        EcoreBuilder.initStandalone();
        EPackage testPackage = EcoreBuilder.createPackage("testPackage", "testPackage", "http://testPackage");
        EEnum eEnum = EcoreBuilder.createEEnum("TestEnum");
        EcoreBuilder.addEEnumLiteral(eEnum, "firstLiteral", 0);
        testPackage.getEClassifiers().add((Object)eEnum);
        EClass superClass = EcoreBuilder.createEClass("SuperClass");
        testPackage.getEClassifiers().add((Object)superClass);
        EcoreBuilder.addAttribute(superClass, "testEnum", (EClassifier)eEnum, false, 0, 1);
        Result result = SmellFinder.findSmell((IModelSmellFinder)new UnutilizedAbstraction_UnusedEnumeration(), (EObject)testPackage);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.getModelelements().size());
    }

    @Test
    public void validateRedundantContainerRelation_ExplicitReference_ClassIsDetected() {
        EcoreBuilder.initStandalone();
        EPackage testPackage = EcoreBuilder.createPackage("testPackage", "testPackage", "http://testPackage");
        EClass firstClass = EcoreBuilder.createEClass("FirstClass");
        testPackage.getEClassifiers().add((Object)firstClass);
        EClass secondClass = EcoreBuilder.createEClass("SecondClass");
        testPackage.getEClassifiers().add((Object)secondClass);
        EcoreBuilder.addReference(firstClass, "testReference", (EClassifier)secondClass, true, 0, 1);
        EcoreBuilder.addReference(secondClass, "referencingReference", (EClassifier)firstClass, false, 0, 1);
        EcoreBuilder.makeOppositeReference(firstClass, "testReference", secondClass, "referencingReference");
        EcoreBuilder.savePackageToFile(testPackage, "RedundantContainerRelation.ecore");
        Result result = SmellFinder.findSmell((IModelSmellFinder)new RedundantContainerRelation(), (EObject)testPackage);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.getModelelements().size());
    }

    @Test
    public void validateObligatoryContainerRelation_ExplicitReference_ClassIsDetected() {
        EcoreBuilder.initStandalone();
        EPackage testPackage = EcoreBuilder.createPackage("testPackage", "testPackage", "http://testPackage");
        EClass firstClass = EcoreBuilder.createEClass("FirstClass");
        testPackage.getEClassifiers().add((Object)firstClass);
        EClass secondClass = EcoreBuilder.createEClass("SecondClass");
        testPackage.getEClassifiers().add((Object)secondClass);
        EcoreBuilder.addReference(firstClass, "testReference", (EClassifier)secondClass, true, 0, 1);
        EcoreBuilder.addReference(secondClass, "referencingReference", (EClassifier)firstClass, false, 1, 1);
        EcoreBuilder.makeOppositeReference(firstClass, "testReference", secondClass, "referencingReference");
        EcoreBuilder.savePackageToFile(testPackage, "ObligatoryContainerRelation.ecore");
        Result result = SmellFinder.findSmell((IModelSmellFinder)new ObligatoryContainerRelation(), (EObject)testPackage);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.getModelelements().size());
    }

    @Test
    public void validateSpecializationAggregration_SpecialAggrToSubClass_ClassIsDetected() {
        EcoreBuilder.initStandalone();
        EPackage testPackage = EcoreBuilder.createPackage("testPackage", "testPackage", "http://testPackage");
        EClass firstClass = EcoreBuilder.createEClass("FirstClass");
        testPackage.getEClassifiers().add((Object)firstClass);
        EClass secondClass = EcoreBuilder.createEClass("SecondClass");
        testPackage.getEClassifiers().add((Object)secondClass);
        EClass firstSubClass = EcoreBuilder.createEClass("FirstSubClass");
        testPackage.getEClassifiers().add((Object)firstSubClass);
        EcoreBuilder.addSuperType(firstSubClass, testPackage, "FirstClass");
        EClass secondSubClass = EcoreBuilder.createEClass("SecondSubClass");
        testPackage.getEClassifiers().add((Object)secondSubClass);
        EcoreBuilder.addSuperType(secondSubClass, testPackage, "SecondClass");
        EcoreBuilder.addReference(firstClass, "testReference", (EClassifier)secondClass, false, 0, 1);
        EcoreBuilder.addReference(firstSubClass, "specializationReference", (EClassifier)secondSubClass, false, 0, 1);
        EcoreBuilder.savePackageToFile(testPackage, "SpecializationAggregation1.ecore");
        Result result = SmellFinder.findSmell((IModelSmellFinder)new SpecializationAggregation(), (EObject)testPackage);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.getModelelements().size());
    }

    @Test
    public void validateSpecializationAggregration_SpecialAggrToSuperClass_ClassIsDetected() {
        EcoreBuilder.initStandalone();
        EPackage testPackage = EcoreBuilder.createPackage("testPackage", "testPackage", "http://testPackage");
        EClass firstClass = EcoreBuilder.createEClass("FirstClass");
        testPackage.getEClassifiers().add((Object)firstClass);
        EClass secondClass = EcoreBuilder.createEClass("SecondClass");
        testPackage.getEClassifiers().add((Object)secondClass);
        EClass firstSubClass = EcoreBuilder.createEClass("FirstSubClass");
        testPackage.getEClassifiers().add((Object)firstSubClass);
        EcoreBuilder.addSuperType(firstSubClass, testPackage, "FirstClass");
        EClass secondSubClass = EcoreBuilder.createEClass("SecondSubClass");
        testPackage.getEClassifiers().add((Object)secondSubClass);
        EcoreBuilder.addSuperType(secondSubClass, testPackage, "SecondClass");
        EcoreBuilder.addReference(firstClass, "testReference", (EClassifier)secondClass, false, 0, 1);
        EcoreBuilder.addReference(firstSubClass, "specializationReference", (EClassifier)secondClass, false, 0, 1);
        EcoreBuilder.savePackageToFile(testPackage, "SpecializationAggregation2.ecore");
        Result result = SmellFinder.findSmell((IModelSmellFinder)new SpecializationAggregation(), (EObject)testPackage);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.getModelelements().size());
    }

    @Test
    public void validateSpecializationAggregration_NoSpecialAggr_NoClassIsDetected() {
        EcoreBuilder.initStandalone();
        EPackage testPackage = EcoreBuilder.createPackage("testPackage", "testPackage", "http://testPackage");
        EClass firstClass = EcoreBuilder.createEClass("FirstClass");
        testPackage.getEClassifiers().add((Object)firstClass);
        EClass secondClass = EcoreBuilder.createEClass("SecondClass");
        testPackage.getEClassifiers().add((Object)secondClass);
        EClass firstSubClass = EcoreBuilder.createEClass("FirstSubClass");
        testPackage.getEClassifiers().add((Object)firstSubClass);
        EcoreBuilder.addSuperType(firstSubClass, testPackage, "FirstClass");
        EClass secondSubClass = EcoreBuilder.createEClass("SecondSubClass");
        testPackage.getEClassifiers().add((Object)secondSubClass);
        EcoreBuilder.addSuperType(secondSubClass, testPackage, "SecondClass");
        EcoreBuilder.addReference(firstClass, "testReference", (EClassifier)secondClass, false, 0, 1);
        Result result = SmellFinder.findSmell((IModelSmellFinder)new SpecializationAggregation(), (EObject)testPackage);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.getModelelements().size());
    }

    @Test
    public void validateHubLikeModularizationIncomingDependencies_DifferentLimits() {
        EcoreBuilder.initStandalone();
        EPackage testPackage = EcoreBuilder.createPackage("testPackage", "testPackage", "http://testPackage");
        EClass hubClass = EcoreBuilder.createEClass("HubClass");
        testPackage.getEClassifiers().add((Object)hubClass);
        EClass class1 = EcoreBuilder.createEClass("Class1");
        testPackage.getEClassifiers().add((Object)class1);
        EcoreBuilder.addReference(class1, "testReference", (EClassifier)hubClass, false, 0, 1);
        EClass class2 = EcoreBuilder.createEClass("Class2");
        testPackage.getEClassifiers().add((Object)class2);
        EcoreBuilder.addReference(class2, "testReference", (EClassifier)hubClass, false, 0, 1);
        EClass class3 = EcoreBuilder.createEClass("Class3");
        testPackage.getEClassifiers().add((Object)class3);
        EcoreBuilder.addReference(class3, "testReference", (EClassifier)hubClass, false, 0, 1);
        EClass class4 = EcoreBuilder.createEClass("Class4");
        testPackage.getEClassifiers().add((Object)class4);
        EcoreBuilder.addReference(class4, "testReference", (EClassifier)hubClass, false, 0, 1);
        EClass class5 = EcoreBuilder.createEClass("Class5");
        testPackage.getEClassifiers().add((Object)class5);
        EcoreBuilder.addReference(class5, "testReference", (EClassifier)hubClass, false, 0, 1);
        EcoreBuilder.savePackageToFile(testPackage, "HubLike_Incoming.ecore");
        Result result = SmellFinder.findMetricSmellWithLimit((MetricBasedModelSmellFinderClass)new HubLikeModularization_IncomingDependencies(), 5.0, (EObject)testPackage);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.getModelelements().size());
        result = SmellFinder.findMetricSmellWithLimit((MetricBasedModelSmellFinderClass)new HubLikeModularization_IncomingDependencies(), 6.0, (EObject)testPackage);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.getModelelements().size());
    }

    @Test
    public void validateHubLikeModularizationOutgoingDependencies_DifferentLimits() {
        EcoreBuilder.initStandalone();
        EPackage testPackage = EcoreBuilder.createPackage("testPackage", "testPackage", "http://testPackage");
        EClass hubClass = EcoreBuilder.createEClass("HubClass");
        testPackage.getEClassifiers().add((Object)hubClass);
        EClass class1 = EcoreBuilder.createEClass("Class1");
        testPackage.getEClassifiers().add((Object)class1);
        EcoreBuilder.addReference(hubClass, "testReference1", (EClassifier)class1, false, 0, 1);
        EClass class2 = EcoreBuilder.createEClass("Class2");
        testPackage.getEClassifiers().add((Object)class2);
        EcoreBuilder.addReference(hubClass, "testReference2", (EClassifier)class2, false, 0, 1);
        EClass class3 = EcoreBuilder.createEClass("Class3");
        testPackage.getEClassifiers().add((Object)class3);
        EcoreBuilder.addReference(hubClass, "testReference3", (EClassifier)class3, false, 0, 1);
        EClass class4 = EcoreBuilder.createEClass("Class4");
        testPackage.getEClassifiers().add((Object)class4);
        EcoreBuilder.addReference(hubClass, "testReference4", (EClassifier)class4, false, 0, 1);
        EClass class5 = EcoreBuilder.createEClass("Class5");
        testPackage.getEClassifiers().add((Object)class5);
        EcoreBuilder.addReference(hubClass, "testReference5", (EClassifier)class5, false, 0, 1);
        EcoreBuilder.savePackageToFile(testPackage, "HubLike_Outgoing.ecore");
        Result result = SmellFinder.findMetricSmellWithLimit((MetricBasedModelSmellFinderClass)new HubLikeModularization_OutgoingDependencies(), 5.0, (EObject)testPackage);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.getModelelements().size());
        result = SmellFinder.findMetricSmellWithLimit((MetricBasedModelSmellFinderClass)new HubLikeModularization_OutgoingDependencies(), 6.0, (EObject)testPackage);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.getModelelements().size());
    }

    @Test
    public void validateCyclicHierarchyDetection() {
        EcoreBuilder.initStandalone();
        EPackage testPackage = EcoreBuilder.createPackage("testPackage", "testPackage", "http://testPackage");
        EClass superType = EcoreBuilder.createEClass("SuperType");
        testPackage.getEClassifiers().add((Object)superType);
        EClass subType = EcoreBuilder.createEClass("SubType");
        testPackage.getEClassifiers().add((Object)subType);
        EcoreBuilder.addSuperType(subType, testPackage, superType.getName());
        EClass subSubType = EcoreBuilder.createEClass("SubSubType");
        testPackage.getEClassifiers().add((Object)subSubType);
        EcoreBuilder.addSuperType(subSubType, testPackage, subType.getName());
        EcoreBuilder.addReference(superType, "knownDerived", (EClassifier)subSubType, false, 0, 1);
        EcoreBuilder.savePackageToFile(testPackage, "CyclicHierarchy.ecore");
        Result result = SmellFinder.findSmell((IModelSmellFinder)new CyclicHierarchy(), (EObject)testPackage);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.getModelelements().size());
    }

    @Test
    public void validateCyclicDependentModularizationDetection() {
        EcoreBuilder.initStandalone();
        EPackage testPackage = EcoreBuilder.createPackage("testPackage", "testPackage", "http://testPackage");
        EClass superType = EcoreBuilder.createEClass("SuperType");
        testPackage.getEClassifiers().add((Object)superType);
        EClass subType = EcoreBuilder.createEClass("SubType");
        testPackage.getEClassifiers().add((Object)subType);
        EcoreBuilder.addSuperType(subType, testPackage, superType.getName());
        EClass anotherType = EcoreBuilder.createEClass("AnotherType");
        testPackage.getEClassifiers().add((Object)anotherType);
        EClass anotherType2 = EcoreBuilder.createEClass("AnotherType2");
        testPackage.getEClassifiers().add((Object)anotherType2);
        EcoreBuilder.addReference(superType, "TestReference", (EClassifier)anotherType, false, 0, 1);
        EcoreBuilder.addReference(anotherType, "TestReference", (EClassifier)anotherType2, false, 0, 1);
        EcoreBuilder.addReference(anotherType2, "TestReference", (EClassifier)subType, false, 0, 1);
        EcoreBuilder.savePackageToFile(testPackage, "CyclicDependentModularizationHierarchy.ecore");
        Result result = SmellFinder.findSmell((IModelSmellFinder)new CyclicDependentModularization(), (EObject)testPackage);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)3L, (long)result.getModelelements().size());
    }

    @Test
    public void validateCyclicDependentModularizationDetection_NoCycle() {
        EcoreBuilder.initStandalone();
        EPackage testPackage = EcoreBuilder.createPackage("testPackage", "testPackage", "http://testPackage");
        EClass superType = EcoreBuilder.createEClass("SuperType");
        testPackage.getEClassifiers().add((Object)superType);
        EClass subType = EcoreBuilder.createEClass("SubType");
        testPackage.getEClassifiers().add((Object)subType);
        EcoreBuilder.addSuperType(subType, testPackage, superType.getName());
        EClass anotherType = EcoreBuilder.createEClass("AnotherType");
        testPackage.getEClassifiers().add((Object)anotherType);
        EClass anotherType2 = EcoreBuilder.createEClass("AnotherType2");
        testPackage.getEClassifiers().add((Object)anotherType2);
        EcoreBuilder.addReference(superType, "TestReference", (EClassifier)anotherType, false, 0, 1);
        EcoreBuilder.addReference(anotherType, "TestReference", (EClassifier)anotherType2, false, 0, 1);
        Result result = SmellFinder.findSmell((IModelSmellFinder)new CyclicDependentModularization(), (EObject)testPackage);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.getModelelements().size());
    }

    @Test
    public void validateLateHierachyDetection() {
        EcoreBuilder.initStandalone();
        EPackage testPackage = EcoreBuilder.createPackage("testPackage", "testPackage", "http://testPackage");
        EClass superType = EcoreBuilder.createEClass("SuperType");
        testPackage.getEClassifiers().add((Object)superType);
        EClass subType = EcoreBuilder.createEClass("SubType");
        testPackage.getEClassifiers().add((Object)subType);
        subType.setAbstract(true);
        EcoreBuilder.addSuperType(subType, testPackage, superType.getName());
        EcoreBuilder.savePackageToFile(testPackage, "LateHierarchy.ecore");
        Result result = SmellFinder.findSmell((IModelSmellFinder)new LateHierarchy(), (EObject)testPackage);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.getModelelements().size());
    }
}

